var lcfirst = function(string) {
	return string.charAt(0).toLowerCase() + string.substr(1);
};

var ucfirst = function(string) {
	return string.charAt(0).toUpperCase() + string.substr(1);
};

var dashToPascalCase = function(dashString) {
	return dashString.split('-').map(ucfirst).join('');
};


var findIndexByKeyValue = function(key, value, array) {
	for (var i = 0; i < array.length; i++) {
		if (array[i][key] === value)
			return i;
	}
	return false;
};


var sanitize = function(data) {
	var ret = {};
	for (var key in data) {
		if (!key.match(/^\$/))
			ret[(key)] = data[key];
	}
	return ret;
}

/**
 * converts an object to x-www-form-urlencoded serialization.
 * @param {Object} obj
 * @return {String}
 */
var param = function(obj) {

	var query = '', name, value, fullSubName, subName, subValue, innerObj, i;

	for (name in obj) {

		value = obj[name];

		if (value instanceof Array) {
			for (i = 0; i < value.length; ++i) {
				subValue = value[i];
				fullSubName = name + '[' + i + ']';
				innerObj = {};
				innerObj[fullSubName] = subValue;
				query += param(innerObj) + '&';
			}
		} else if (value instanceof Object) {
			for (subName in value) {
				subValue = value[subName];
				fullSubName = name + '[' + subName + ']';
				innerObj = {};
				innerObj[fullSubName] = subValue;
				query += param(innerObj) + '&';
			}
		} else if (value !== undefined && value !== null) {
			query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
		}
	}

	return query.length ? query.substr(0, query.length - 1) : query;
};