EventsMap = function(options) {
	
	var canvasId = options.canvasId;
	var entities = options.entities;
	var icons = options.icons;

	this.parent = new BaseMap;
	this.inheritance = BaseMap;
	this.inheritance();

	if (icons != undefined)
		this.icons = icons;
	
	if (options.center != undefined)
		this.mapOptions.center = options.center;
	
	if (options.zoom != undefined)
		this.mapOptions.zoom = options.zoom;
	
	if (options.mapTypeId != undefined)
		this.mapOptions.mapTypeId = options.mapTypeId;

	this.geocoder;
	this.suggestions = [];


	this.initializeMap = function(canvasId) {
		var _this = this;

		_this.parent.initializeMap.call(_this, canvasId);

		_this.directionsDisplay = new google.maps.DirectionsRenderer();
		_this.geocoder = new google.maps.Geocoder();
	}

	this.parentDisplayMarker = this.displayMarker;
	this.displayMarker = function(id, position, type) {
		var marker = this.parentDisplayMarker(id, position, type);
		marker.type = type;
		marker.eventId = id;
	}

	this.filterEventsByAxisId = function(axisId) {
		for (var id in this.markers) {
			if (this.markers[id].type == axisId)
				this.showMarker(id);
			else
				this.hideMarker(id);
		}
	}

	if (!this.map) {
		this.initializeMap(canvasId);
	}

	for (var key in entities) {
		var entity = entities[key];

		if (entity.Latitude != null && entity.Longitude != null) {
			var position = new google.maps.LatLng(entity.Latitude, entity.Longitude);
			var markerType = (entity.Markertype && entity.Markertype in this.icons) ? entity.Markertype : "default";
			this.displayMarker(entity.Id, position, markerType);
			if (options.markerInfoFn != undefined)
				this.setMarkerInfo(entity.Id, options.markerInfoFn(entity));
		}
	}
};
