<?php

/**
 * usage: [
 *     'MyNamespace\MyEntity' => [
 *         'prefix' => 'newPrefix', // use this to change default prefix for all actions from default ('myNamespaceMyEntitys') to 'newPrefix'
 *         'actions' => [
 *             'myAction' => 'newPrefixAndAction' // use this to override route for 'myAction'
 *         ]
 *     ]
 * ]
 */

return [

	'BooleanIndicator' => [
		'prefix' => 'indicatorsBoolean',
		'actions' => [
			'doDelete' => 'indicatorsDoDelete',
			'view' => 'indicatorsBooleanEdit'
		]
	],

	'NumericIndicator' => [
		'prefix' => 'indicatorsNumeric',
		'actions' => [
			'doDelete' => 'indicatorsDoDelete',
			'view' => 'indicatorsNumericEdit'
		]
	],

	'ExpectedIndicatorValue' => [
		'prefix' => 'indicatorsExpectedValue'
	],

	'RealIndicatorValue' => [
		'prefix' => 'indicatorsRealValue'
	],

	'Objective' => [
		'actions' => [
			'view' => 'objectivesEdit'
		]
	],

	'Position' => [
		'actions' => [
			'view' => 'positionsEdit'
		]
	],

	'Egytca\Modules\Panel\Activity' => [
		'actions' => [
			'view' => 'panelActivityEdit'
		]
	],

	'Egytca\Modules\Panel\Project' => [
		'actions' => [
			'view' => 'panelProjectEdit'
		]
	],

	'Egytca\Modules\Processes\ChecklistFollowup' => [
		'actions' => [
			'doDelete' => 'processesFollowupDoDelete',
			'doEdit' => 'processesFollowupDoEdit'
		]
	],

	'Egytca\Modules\Processes\ChecklistFollowupDescription' => [
		'actions' => [
			'doDelete' => 'processesFollowupDescriptionDoDelete',
			'doEdit' => 'processesFollowupDescriptionDoEdit'
		]
	],

	'Egytca\Modules\Processes\Process' => [
		'prefix' => 'processes'
	],

	'AlertDigest' => [
		'prefix' => 'panelAlertDigests'
	]
];
