<?php
/*
 * load_config.php
 * Carga archivos de configuracion de la aplicacion.
 * Lo hace a dos niveles, el config.xml que se puede modificar desde la aplicacion y el config_module
 * que no se tiene acceso desde al aplicacion
 * @package config
 * @author Modulos Empresarios / Egytca
 * @copyright Copyright (c) 2017, Egytca
 */
function loadConfig($xmlFile, $dataFile)
{

	global $appDir;

	if (!file_exists($xmlFile))
		echo "No existe $xmlFile";
	else
	{

		if (file_exists($dataFile))
			$timeData = filemtime($dataFile);
		else
			$timeData = 0;

		$timeXML = filemtime($xmlFile);

		//Si el XML fue modificado despues de crear el data, tengo que generar el data
		if ($timeXML > $timeData)
		{
			$configXml = simplexml_load_string(file_get_contents($xmlFile), "SimpleXMLElement", LIBXML_NOCDATA);
			$configJson = json_encode($configXml);
			$configArray = array();
			$configArray["config"] = json_decode($configJson, true);
			file_put_contents($dataFile, serialize($configArray));
		}
		return unserialize(file_get_contents($dataFile));
	}
}

global $appDir;
global $system;

$xmlFile = $appDir . "/config/config.xml";
$dataFile = $appDir . "/config/config.data";

$system = loadConfig($xmlFile, $dataFile);

if (file_exists($appDir . "/config/config.local.xml"))
{
	$localConfig = loadConfig($appDir . "/config/config.local.xml", $appDir . "/config/config.local.data");
	if (!empty($localConfig["config"]))
		$system = array_replace_recursive($system, $localConfig);
}


/**
 * ConfigModule
 * Clase para obtener variables de configuracion de modulos
 *
 * @package config
 * @author Modulos Empresarios / Egytca
 * @copyright Copyright (c) 2017, Egytca
 */
class ConfigModule
{
	/**
	 * Instancia que define los parametros de configuracion en un array
	 */
	private static $configModule = [];

	/**
	 * Obtiene la configuracion cargando la configuracion local si existe
	 */
	public static function init()
	{
		self::$configModule = require_once __DIR__.'/config_module.php';
		self::mergeConfigModuleWithLocal();
	}

	/**
	 * Obtencion del valor de configuracion a partir de nombre de modulo y valor buscado
	 * $module		string		Nombre del modulo buscado
	 * $key			string		Nombre del parametro buscado
	 * @return		mixed		Valor o array con valores solicitados, vacio si no existe
	 */
	public static function get($module, $key)
	{
		if (!isset(ConfigModule::$configModule[$module]) || !isset(ConfigModule::$configModule[$module][$key]))
			return;
		else
			return ConfigModule::$configModule[$module][$key];
	}

	/**
	 * Combina los valores de configuracion locales si existen en el array configModule
	 */
	private static function mergeConfigModuleWithLocal()
	{
		global $appDir;
		$localConfigFile = __DIR__ . "/config_module.local.php";
		if (file_exists($localConfigFile))
		{
			$localConfig = require_once $localConfigFile;
			self::$configModule = array_replace_recursive(self::$configModule, $localConfig);
		}
	}

} // End class ConfigModule

ConfigModule::init();