<?php

/**
 * Configuraciones de manejo del cache
 *
 * @package    config
 */

	/**
	 * Determina si se usa el cache en base al nombre del action solicitado
	 *
	 * @param $doPath string con nombre del action
	 * @returns bool si usa cache, si no, false
	 */
	function useCache($doPath) {
		if ($doPath === 'js')
			return true;
		return false;
	}

	/**
	 * Devuelve el valor a usar en el session_cache_limiter segun la funcion useCache
	 *
	 * @param $doPath string con nombre del action
	 * @returns string con parametro a usar en el session_cache_limiter
	 */
	function getSessionCacheDelimiter($doPath) {
		return useCache($doPath) ? 'private_no_expire' : 'nocache';
	}
