<?php


/**
 * Skeleton subclass for performing query and update operations on the 'users_user' table.
 *
 * Users
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.users.classes
 */
class UserQuery extends BaseUserQuery {

	/**
	 * Agrega filtros por nombre, apellido o nombre d eusuario
	 *
	 * @param   type string $filterValue texto a buscar
	 * @return condicion de filtrado por texto a buscar
	 */
	public function searchString($filterValue) {
		return $this->filterByName("%$filterValue%", Criteria::LIKE)
				->_or()
					->filterBySurname("%$filterValue%", Criteria::LIKE)
				->_or()
					->filterByUsername("%$filterValue%", Criteria::LIKE);
	}

 /**
	* Selecciona usuarios bloquados
	*
	* @param $blocked bool
	*/
	public function selectBlocked($blocked){
		if($blocked)
			$this->where('User.BlockedAt IS NOT NULL');
		return $this;
	}
	
 /**
	* Permite filtrar los usuarios que tienen las ids pasadas por parametro
	*
	* @param $ids array de ids que se quieren pasar por alto en la busqueda 
	*/
	public function getDifferentFrom($ids){
		return $this->filterById($ids,Criteria::NOT_IN);
	}

 /**
	* Permite filtrar los usuarios que tienen las ids pasadas por parametro
	*/
	public function getLoged(){
		return $this->filterBySession(null, Criteria::ISNOTNULL);
	}

 /**
	* Aplica filtro para ignorar usuario de sistema
	*/
	public function ignoreNonRealUsers(){
		return $this->filterById(0, Criteria::GREATER_THAN);
	}

 /**
	* Aplica filtro para usuarios reales y activos
	*/
	public function filterByRealAndActive(){
		return $this->filterById(0, Criteria::GREATER_THAN)->filterByActive(1);
	}


 /**
	 * Filtra usuarios que esten en funciones
	 */
	function withActiveTenuere() {

		$activeTenureUsersId = PositionTenureQuery::create()
												->select('Objectid')
												->filterByObjecttype('User')
												->filterByDateto(null, Criteria::ISNULL)
												->usePositionQuery()
													->filterByLastVersion()
												->endUse()
											->find()
											->toArray();
		return $this->filterByid($activeTenureUsersId,Criteria::IN);
	}


} // UserQuery
