﻿|-if $invalidId-|
	<h2>Tablero de Gestión</h2>
	<h1>Administración de |-if $type eq 'activity'-|Actividades|-else-|Subactividades|-/if-|</h1>
	<div class="resultError">Debe seleccionar un proyecto válido</div>
|-else-|

<link type="text/css" href="css/smoothness/jquery-ui-1.8.19.custom.css" rel="Stylesheet" />
<script type="text/javascript" src="scripts/jquery/jquery-ui-1.8.19.custom.min.js"></script>
<link type="text/css" href="css/jquery-ui-timepicker-addon.css" rel="Stylesheet" />
<script type="text/javascript" src="scripts/jquery/jquery-ui-timepicker-addon.js"></script>
<script type="text/javascript" src="scripts/jquery/jquery.ui.datepicker-es.js"></script>
<script type="text/javascript" src="scripts/jquery/jquery.ui.timepicker-es.js"></script>

<script>
	$(function() {
		initializeDatePickers();
	});
	
	function initializeDatePickers() {
				
		$("*").find('input[id^=params\\[plannedStart\\]').datepicker(
			{
				dateFormat: 'dd-mm-yy',
				numberOfMonths: 3,
				autoclose: true,
				onSelect: function() {
					setDateLimits($(this).attr("data-activityId"));
				}
			}
		);
		$("*").find('input[id^=params\\[plannedEnd\\]').datepicker(
			{
				dateFormat: 'dd-mm-yy',
				numberOfMonths: 3,
				autoclose: true,
				onSelect: function() {
					setDateLimits($(this).attr("data-activityId"));
				}
			}
		);
		
		$("*").find('input[id^=params\\[plannedStart\\]').each(function(){
			setDateLimits($(this).attr("data-activityId"));
		})

	}
	
	function setDateLimits(datepickerid){

		if ($('#params\\[plannedEnd\\]\\['+datepickerid+'\\]').val() != ""){
			$('#params\\[plannedStart\\]\\['+datepickerid+'\\]').datepicker( "option", "maxDate", $('#params\\[plannedEnd\\]\\['+datepickerid+'\\]').datepicker("getDate"));
		}
		if ($('#params\\[plannedStart\\]\\['+datepickerid+'\\]').val() != ""){
			$('#params\\[plannedEnd\\]\\['+datepickerid+'\\]').datepicker( "option", "minDate", $('#params\\[plannedStart\\]\\['+datepickerid+'\\]').datepicker("getDate"));
		}
	}
	
	function validatefields(activityId){
		var valid = false;
		
		if ($('#params\\[name\\]\\['+activityId+'\\]').val()==""){
			alert ("Debe ingresar un nombre para la actividad");
		}else if ($('#params\\[plannedStart\\]\\['+activityId+'\\]').val()==""){
			alert ("Debe especificar una fecha de inicio planificada");
		}else if ($('#params\\[plannedEnd\\]\\['+activityId+'\\]').val()==""){
			alert ("Debe especificar una fecha de fin planificada");
		}else{
			valid = true;
		}
		
		return valid;	
	}
	
	function updateactivity(activityId){
		if (validatefields(activityId)){
				
			var jsonParams={
						   name : $('#params\\[name\\]\\['+activityId+'\\]').val(),
						   plannedStart: $('#params\\[plannedStart\\]\\['+activityId+'\\]').val(),
						   plannedEnd: $('#params\\[plannedEnd\\]\\['+activityId+'\\]').val(),
						   projectId: |-$parentObject->getId()-|
						  }		

			$.ajax({
			url: url,
			type: 'post',
			data: {params:jsonParams,do:"projectsActivitiesBulkDoEditX",id: activityId},
			success: function(data) {
				console.log(data);			
			}
			});
		}
	}
	function addactivity(){
		
		if (validatefields("new")){
		
			$("#newLineButton").html('Guardando...');
			
			var jsonparams = {
						   name : $('#params\\[name\\]\\[new\\]').val(),
						   plannedStart: $('#params\\[plannedStart\\]\\[new\\]').val(),
						   plannedEnd: $('#params\\[plannedEnd\\]\\[new\\]').val(),
						   |-* Se agregan estos dos parametros para que se puedan mostrar en el projectsActivitiesBulkEdit, observacion : sino es 2016 no se muestra *-|
						   startingYear:|-$configModule->get('planning', 'minYear')-|,
						   endingYear:|-$configModule->get('planning', 'maxYear')-|,
						   |-if $type eq 'activity'-|projectId|-else-|parentActivityId|-/if-|: |-$parentObject->getId()-|
						}		
			
			$.ajax({
			url: url,
			type: 'post',
			data: {params:jsonparams,do:"projectsActivitiesBulkDoEditX"},
			success: function(data) {
				
				$("#newLineButton").html('<input type="button" id="submitline" name="submitline" title="Actualizar" value="Actualizar" onClick="updateactivity('+data+');">');
				$("#newLineButton").removeAttr("id");
				
				$("#deleteLineButton").html('<input type="button" id="removeline" name="removeline" title="Eliminar" value="Eliminar" onClick="deleteactivity('+data+');">');
				$("#deleteLineButton").removeAttr("id");
				
				$('#params\\[name\\]\\[new\\]').attr("name","params[name]["+data+"]");
				$('#params\\[plannedStart\\]\\[new\\]').attr("name","params[plannedStart]["+data+"]");
				$('#params\\[plannedEnd\\]\\[new\\]').attr("name","params[plannedEnd]["+data+"]");

				$('#params\\[name\\]\\[new\\]').attr("id","params[name]["+data+"]");
				$('#params\\[plannedStart\\]\\[new\\]').attr("id","params[plannedStart]["+data+"]");
				$('#params\\[plannedEnd\\]\\[new\\]').attr("id","params[plannedEnd]["+data+"]");

				$('#params\\[plannedStart\\]\\[new\\]').attr("data-activityId",data);
				$('#params\\[plannedEnd\\]\\[new\\]').attr("data-activityId",data);
				
				var newLine = '<tr>';	
				newLine += '<td><input type="text" id="params[name][new]" name="params[name][new]" size="70" value="" title="Nombre de la actividad" /></td>';
				newLine += '<td align="center"><input type="text" data-activityId="new" id="params[plannedStart][new]" name="params[plannedStart][new]" size="10" class="dateValidation" value="" title="Fecha de inicio planificado (Formato: dd-mm-yyyy)" /></td>';
				newLine += '<td align="center"><input type="text" data-activityId="new" id="params[plannedEnd][new]" name="params[plannedEnd][new]" size="10" class="dateValidation" value="" title="Fecha de planificada de finalizacion (Formato: dd-mm-yyyy)" /></td>';
				newLine += '<td align="center" id="newLineButton"><input type="button" id="submitline" name="submitline" title="Agregar" value="Agregar" onClick="addactivity();"></td>';
				newLine += '<td align="center" id="deleteLineButton"></td>';
				newLine += '</tr>';
				
				$("#activityListTable > tbody:last-child").append(newLine);
				
				initializeDatePickers();
				
			}
			});
		}
	}
	
	function deleteactivity(activityId){
		if (confirm("¿Seguro que desea eliminar la actividad?")){
			$.ajax({
				url: url,
				type: 'post',
				data: {do:"projectsActivitiesBulkDoDeleteX",id: activityId},
				success: function(data) {
					console.log(data);
					$("#activityline\\["+activityId+"\\]").remove();
				}
				});
		}
	}
</script>
<h2>Tablero de Gestión</h2>
<h1>Administración de |-if $type eq 'activity'-|Actividades|-else-|Subactividades|-/if-|</h1>
<p>A continuación se muestra la lista de |-if $type eq 'activity'-|actividades|-else-|subactividades|-/if-| cargadas en el sistema.</p>

|-if is_object($parentObject)-|<div id="navBar">|-include file="NavigationParentInclude.tpl" object=$parentObject first="true"-| |-*$parentObject->getOrderPath()*-|&nbsp;|-$parentObject->getName()-|</div>|-/if-|

<table id="activityListTable">
 <thead>
  <tr>
     <th>|-if $type eq 'activity'-|Actividad|-else-|Subactividad|-/if-|</th>
     <th>Inicio Planificado</th>
	 <th>Fin Planificado</th>
	 <th></th>
	 <th></th>
  </tr>
 </thead>
 <tbody>
|-foreach from=$activitiesList item=activity name=for_activities-|
  <tr id="activityline[|-$activity->getId()-|]">	
	<td><input type="text" id="params[name][|-$activity->getId()-|]" name="params[name][|-$activity->getId()-|]" size="70" value="|-$activity->getname()|escape-|" title="Nombre de la actividad" /></td>
	<td align="center"><input type="text" data-activityId="|-$activity->getId()-|" readonly='true' id="params[plannedStart][|-$activity->getId()-|]" name="params[plannedStart][|-$activity->getId()-|]" size="10" class="dateValidation" value="|-$activity->getplannedStart()|date_format:"%d-%m-%Y"-|" title="Fecha de inicio planificado (Formato: dd-mm-yyyy)" /></td>
	<td align="center"><input type="text" data-activityId="|-$activity->getId()-|" readonly='true' id="params[plannedEnd][|-$activity->getId()-|]" name="params[plannedEnd][|-$activity->getId()-|]" size="10" class="dateValidation" value="|-$activity->getplannedEnd()|date_format:"%d-%m-%Y"-|" title="Fecha de planificada de finalización (Formato: dd-mm-yyyy)" /></td>
	<td align="center"><input type="button" id="submitline" name="submitline" title="Actualizar" value="Actualizar" onClick='updateactivity(|-$activity->getId()-|);'></td>
	<td align="center"><input type="button" id="removeline" name="removeline" title="Eliminar" value="Eliminar" onClick='deleteactivity(|-$activity->getId()-|);'></td>
  </tr>	
|-/foreach-|
  <tr>	
	<td><input type="text" id="params[name][new]" name="params[name][new]" size="70" value="" title="Nombre de la actividad" /></td>
	<td align="center"><input type="text" data-activityId="new" readonly='true' id="params[plannedStart][new]" name="params[plannedStart][new]" size="10" class="dateValidation" value="" title="Fecha de inicio planificado (Formato: dd-mm-yyyy)" /></td>
	<td align="center"><input type="text" data-activityId="new" readonly='true' id="params[plannedEnd][new]" name="params[plannedEnd][new]" size="10" class="dateValidation" value="" title="Fecha de planificada de finalización (Formato: dd-mm-yyyy)" /></td>
	<td align="center" id="newLineButton"><input type="button" id="submitline" name="submitline" title="Agregar" value="Agregar" onClick='addactivity();'></td>
	<td align="center" id="deleteLineButton"></td>
  </tr>	
  </tbody>
</table>
|-/if-|
