<?php


/**
 * Base class that represents a row from the 'projects_milestone' table.
 *
 * Milestone
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectMilestone extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ProjectMilestonePeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ProjectMilestonePeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the projectid field.
     * @var        int
     */
    protected $projectid;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the date field.
     * @var        string
     */
    protected $date;

    /**
     * The value for the expirationdate field.
     * @var        string
     */
    protected $expirationdate;

    /**
     * The value for the completed field.
     * @var        boolean
     */
    protected $completed;

    /**
     * The value for the notes field.
     * @var        string
     */
    protected $notes;

    /**
     * @var        Project
     */
    protected $aProject;

    /**
     * @var        PropelObjectCollection|ProjectMilestoneLog[] Collection to store aggregation of ProjectMilestoneLog objects.
     */
    protected $collProjectMilestoneLogs;
    protected $collProjectMilestoneLogsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectMilestoneLogsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Milestone Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [projectid] column value.
     * Project Id
     * @return int
     */
    public function getProjectid()
    {
        return $this->projectid;
    }

    /**
     * Get the [name] column value.
     * Milestone Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [optionally formatted] temporal [date] column value.
     * Milestone Creation Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDate($format = '%Y/%m/%d')
    {
        if ($this->date === null) {
            return null;
        }

        if ($this->date === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->date);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->date, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [expirationdate] column value.
     * Milestone Expiration Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getExpirationdate($format = '%Y/%m/%d')
    {
        if ($this->expirationdate === null) {
            return null;
        }

        if ($this->expirationdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->expirationdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->expirationdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [completed] column value.
     * is Milestone Completed?
     * @return boolean
     */
    public function getCompleted()
    {
        return $this->completed;
    }

    /**
     * Get the [notes] column value.
     * Project Notes
     * @return string
     */
    public function getNotes()
    {
        return $this->notes;
    }

    /**
     * Set the value of [id] column.
     * Milestone Id
     * @param int $v new value
     * @return ProjectMilestone The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ProjectMilestonePeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [projectid] column.
     * Project Id
     * @param int $v new value
     * @return ProjectMilestone The current object (for fluent API support)
     */
    public function setProjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->projectid !== $v) {
            $this->projectid = $v;
            $this->modifiedColumns[] = ProjectMilestonePeer::PROJECTID;
        }

        if ($this->aProject !== null && $this->aProject->getId() !== $v) {
            $this->aProject = null;
        }


        return $this;
    } // setProjectid()

    /**
     * Set the value of [name] column.
     * Milestone Name
     * @param string $v new value
     * @return ProjectMilestone The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ProjectMilestonePeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Sets the value of [date] column to a normalized version of the date/time value specified.
     * Milestone Creation Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectMilestone The current object (for fluent API support)
     */
    public function setDate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->date !== null || $dt !== null) {
            $currentDateAsString = ($this->date !== null && $tmpDt = new DateTime($this->date)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->date = $newDateAsString;
                $this->modifiedColumns[] = ProjectMilestonePeer::DATE;
            }
        } // if either are not null


        return $this;
    } // setDate()

    /**
     * Sets the value of [expirationdate] column to a normalized version of the date/time value specified.
     * Milestone Expiration Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectMilestone The current object (for fluent API support)
     */
    public function setExpirationdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->expirationdate !== null || $dt !== null) {
            $currentDateAsString = ($this->expirationdate !== null && $tmpDt = new DateTime($this->expirationdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->expirationdate = $newDateAsString;
                $this->modifiedColumns[] = ProjectMilestonePeer::EXPIRATIONDATE;
            }
        } // if either are not null


        return $this;
    } // setExpirationdate()

    /**
     * Sets the value of the [completed] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is Milestone Completed?
     * @param boolean|integer|string $v The new value
     * @return ProjectMilestone The current object (for fluent API support)
     */
    public function setCompleted($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->completed !== $v) {
            $this->completed = $v;
            $this->modifiedColumns[] = ProjectMilestonePeer::COMPLETED;
        }


        return $this;
    } // setCompleted()

    /**
     * Set the value of [notes] column.
     * Project Notes
     * @param string $v new value
     * @return ProjectMilestone The current object (for fluent API support)
     */
    public function setNotes($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notes !== $v) {
            $this->notes = $v;
            $this->modifiedColumns[] = ProjectMilestonePeer::NOTES;
        }


        return $this;
    } // setNotes()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->projectid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->name = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->date = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->expirationdate = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->completed = ($row[$startcol + 5] !== null) ? (boolean) $row[$startcol + 5] : null;
            $this->notes = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 7; // 7 = ProjectMilestonePeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating ProjectMilestone object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aProject !== null && $this->projectid !== $this->aProject->getId()) {
            $this->aProject = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectMilestonePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ProjectMilestonePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aProject = null;
            $this->collProjectMilestoneLogs = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectMilestonePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ProjectMilestoneQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectMilestonePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ProjectMilestonePeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if ($this->aProject->isModified() || $this->aProject->isNew()) {
                    $affectedRows += $this->aProject->save($con);
                }
                $this->setProject($this->aProject);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->projectMilestoneLogsScheduledForDeletion !== null) {
                if (!$this->projectMilestoneLogsScheduledForDeletion->isEmpty()) {
                    ProjectMilestoneLogQuery::create()
                        ->filterByPrimaryKeys($this->projectMilestoneLogsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectMilestoneLogsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectMilestoneLogs !== null) {
                foreach ($this->collProjectMilestoneLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ProjectMilestonePeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ProjectMilestonePeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ProjectMilestonePeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ProjectMilestonePeer::PROJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`PROJECTID`';
        }
        if ($this->isColumnModified(ProjectMilestonePeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ProjectMilestonePeer::DATE)) {
            $modifiedColumns[':p' . $index++]  = '`DATE`';
        }
        if ($this->isColumnModified(ProjectMilestonePeer::EXPIRATIONDATE)) {
            $modifiedColumns[':p' . $index++]  = '`EXPIRATIONDATE`';
        }
        if ($this->isColumnModified(ProjectMilestonePeer::COMPLETED)) {
            $modifiedColumns[':p' . $index++]  = '`COMPLETED`';
        }
        if ($this->isColumnModified(ProjectMilestonePeer::NOTES)) {
            $modifiedColumns[':p' . $index++]  = '`NOTES`';
        }

        $sql = sprintf(
            'INSERT INTO `projects_milestone` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`PROJECTID`':
                        $stmt->bindValue($identifier, $this->projectid, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`DATE`':
                        $stmt->bindValue($identifier, $this->date, PDO::PARAM_STR);
                        break;
                    case '`EXPIRATIONDATE`':
                        $stmt->bindValue($identifier, $this->expirationdate, PDO::PARAM_STR);
                        break;
                    case '`COMPLETED`':
                        $stmt->bindValue($identifier, (int) $this->completed, PDO::PARAM_INT);
                        break;
                    case '`NOTES`':
                        $stmt->bindValue($identifier, $this->notes, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if (!$this->aProject->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aProject->getValidationFailures());
                }
            }


            if (($retval = ProjectMilestonePeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collProjectMilestoneLogs !== null) {
                    foreach ($this->collProjectMilestoneLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProjectMilestonePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getProjectid();
                break;
            case 2:
                return $this->getName();
                break;
            case 3:
                return $this->getDate();
                break;
            case 4:
                return $this->getExpirationdate();
                break;
            case 5:
                return $this->getCompleted();
                break;
            case 6:
                return $this->getNotes();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['ProjectMilestone'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['ProjectMilestone'][$this->getPrimaryKey()] = true;
        $keys = ProjectMilestonePeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getProjectid(),
            $keys[2] => $this->getName(),
            $keys[3] => $this->getDate(),
            $keys[4] => $this->getExpirationdate(),
            $keys[5] => $this->getCompleted(),
            $keys[6] => $this->getNotes(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aProject) {
                $result['Project'] = $this->aProject->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collProjectMilestoneLogs) {
                $result['ProjectMilestoneLogs'] = $this->collProjectMilestoneLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProjectMilestonePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setProjectid($value);
                break;
            case 2:
                $this->setName($value);
                break;
            case 3:
                $this->setDate($value);
                break;
            case 4:
                $this->setExpirationdate($value);
                break;
            case 5:
                $this->setCompleted($value);
                break;
            case 6:
                $this->setNotes($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ProjectMilestonePeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setProjectid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setName($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setDate($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setExpirationdate($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setCompleted($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setNotes($arr[$keys[6]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ProjectMilestonePeer::DATABASE_NAME);

        if ($this->isColumnModified(ProjectMilestonePeer::ID)) $criteria->add(ProjectMilestonePeer::ID, $this->id);
        if ($this->isColumnModified(ProjectMilestonePeer::PROJECTID)) $criteria->add(ProjectMilestonePeer::PROJECTID, $this->projectid);
        if ($this->isColumnModified(ProjectMilestonePeer::NAME)) $criteria->add(ProjectMilestonePeer::NAME, $this->name);
        if ($this->isColumnModified(ProjectMilestonePeer::DATE)) $criteria->add(ProjectMilestonePeer::DATE, $this->date);
        if ($this->isColumnModified(ProjectMilestonePeer::EXPIRATIONDATE)) $criteria->add(ProjectMilestonePeer::EXPIRATIONDATE, $this->expirationdate);
        if ($this->isColumnModified(ProjectMilestonePeer::COMPLETED)) $criteria->add(ProjectMilestonePeer::COMPLETED, $this->completed);
        if ($this->isColumnModified(ProjectMilestonePeer::NOTES)) $criteria->add(ProjectMilestonePeer::NOTES, $this->notes);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ProjectMilestonePeer::DATABASE_NAME);
        $criteria->add(ProjectMilestonePeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of ProjectMilestone (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setProjectid($this->getProjectid());
        $copyObj->setName($this->getName());
        $copyObj->setDate($this->getDate());
        $copyObj->setExpirationdate($this->getExpirationdate());
        $copyObj->setCompleted($this->getCompleted());
        $copyObj->setNotes($this->getNotes());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getProjectMilestoneLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectMilestoneLog($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return ProjectMilestone Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ProjectMilestonePeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ProjectMilestonePeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Project object.
     *
     * @param             Project $v
     * @return ProjectMilestone The current object (for fluent API support)
     * @throws PropelException
     */
    public function setProject(Project $v = null)
    {
        if ($v === null) {
            $this->setProjectid(NULL);
        } else {
            $this->setProjectid($v->getId());
        }

        $this->aProject = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Project object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectMilestone($this);
        }


        return $this;
    }


    /**
     * Get the associated Project object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Project The associated Project object.
     * @throws PropelException
     */
    public function getProject(PropelPDO $con = null)
    {
        if ($this->aProject === null && ($this->projectid !== null)) {
            $this->aProject = ProjectQuery::create()->findPk($this->projectid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aProject->addProjectMilestones($this);
             */
        }

        return $this->aProject;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('ProjectMilestoneLog' == $relationName) {
            $this->initProjectMilestoneLogs();
        }
    }

    /**
     * Clears out the collProjectMilestoneLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectMilestoneLogs()
     */
    public function clearProjectMilestoneLogs()
    {
        $this->collProjectMilestoneLogs = null; // important to set this to null since that means it is uninitialized
        $this->collProjectMilestoneLogsPartial = null;
    }

    /**
     * reset is the collProjectMilestoneLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectMilestoneLogs($v = true)
    {
        $this->collProjectMilestoneLogsPartial = $v;
    }

    /**
     * Initializes the collProjectMilestoneLogs collection.
     *
     * By default this just sets the collProjectMilestoneLogs collection to an empty array (like clearcollProjectMilestoneLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectMilestoneLogs($overrideExisting = true)
    {
        if (null !== $this->collProjectMilestoneLogs && !$overrideExisting) {
            return;
        }
        $this->collProjectMilestoneLogs = new PropelObjectCollection();
        $this->collProjectMilestoneLogs->setModel('ProjectMilestoneLog');
    }

    /**
     * Gets an array of ProjectMilestoneLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ProjectMilestone is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectMilestoneLog[] List of ProjectMilestoneLog objects
     * @throws PropelException
     */
    public function getProjectMilestoneLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectMilestoneLogsPartial && !$this->isNew();
        if (null === $this->collProjectMilestoneLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectMilestoneLogs) {
                // return empty collection
                $this->initProjectMilestoneLogs();
            } else {
                $collProjectMilestoneLogs = ProjectMilestoneLogQuery::create(null, $criteria)
                    ->filterByProjectMilestone($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectMilestoneLogsPartial && count($collProjectMilestoneLogs)) {
                      $this->initProjectMilestoneLogs(false);

                      foreach($collProjectMilestoneLogs as $obj) {
                        if (false == $this->collProjectMilestoneLogs->contains($obj)) {
                          $this->collProjectMilestoneLogs->append($obj);
                        }
                      }

                      $this->collProjectMilestoneLogsPartial = true;
                    }

                    return $collProjectMilestoneLogs;
                }

                if($partial && $this->collProjectMilestoneLogs) {
                    foreach($this->collProjectMilestoneLogs as $obj) {
                        if($obj->isNew()) {
                            $collProjectMilestoneLogs[] = $obj;
                        }
                    }
                }

                $this->collProjectMilestoneLogs = $collProjectMilestoneLogs;
                $this->collProjectMilestoneLogsPartial = false;
            }
        }

        return $this->collProjectMilestoneLogs;
    }

    /**
     * Sets a collection of ProjectMilestoneLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectMilestoneLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectMilestoneLogs(PropelCollection $projectMilestoneLogs, PropelPDO $con = null)
    {
        $this->projectMilestoneLogsScheduledForDeletion = $this->getProjectMilestoneLogs(new Criteria(), $con)->diff($projectMilestoneLogs);

        foreach ($this->projectMilestoneLogsScheduledForDeletion as $projectMilestoneLogRemoved) {
            $projectMilestoneLogRemoved->setProjectMilestone(null);
        }

        $this->collProjectMilestoneLogs = null;
        foreach ($projectMilestoneLogs as $projectMilestoneLog) {
            $this->addProjectMilestoneLog($projectMilestoneLog);
        }

        $this->collProjectMilestoneLogs = $projectMilestoneLogs;
        $this->collProjectMilestoneLogsPartial = false;
    }

    /**
     * Returns the number of related ProjectMilestoneLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectMilestoneLog objects.
     * @throws PropelException
     */
    public function countProjectMilestoneLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectMilestoneLogsPartial && !$this->isNew();
        if (null === $this->collProjectMilestoneLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectMilestoneLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectMilestoneLogs());
                }
                $query = ProjectMilestoneLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByProjectMilestone($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectMilestoneLogs);
        }
    }

    /**
     * Method called to associate a ProjectMilestoneLog object to this object
     * through the ProjectMilestoneLog foreign key attribute.
     *
     * @param    ProjectMilestoneLog $l ProjectMilestoneLog
     * @return ProjectMilestone The current object (for fluent API support)
     */
    public function addProjectMilestoneLog(ProjectMilestoneLog $l)
    {
        if ($this->collProjectMilestoneLogs === null) {
            $this->initProjectMilestoneLogs();
            $this->collProjectMilestoneLogsPartial = true;
        }
        if (!$this->collProjectMilestoneLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectMilestoneLog($l);
        }

        return $this;
    }

    /**
     * @param	ProjectMilestoneLog $projectMilestoneLog The projectMilestoneLog object to add.
     */
    protected function doAddProjectMilestoneLog($projectMilestoneLog)
    {
        $this->collProjectMilestoneLogs[]= $projectMilestoneLog;
        $projectMilestoneLog->setProjectMilestone($this);
    }

    /**
     * @param	ProjectMilestoneLog $projectMilestoneLog The projectMilestoneLog object to remove.
     */
    public function removeProjectMilestoneLog($projectMilestoneLog)
    {
        if ($this->getProjectMilestoneLogs()->contains($projectMilestoneLog)) {
            $this->collProjectMilestoneLogs->remove($this->collProjectMilestoneLogs->search($projectMilestoneLog));
            if (null === $this->projectMilestoneLogsScheduledForDeletion) {
                $this->projectMilestoneLogsScheduledForDeletion = clone $this->collProjectMilestoneLogs;
                $this->projectMilestoneLogsScheduledForDeletion->clear();
            }
            $this->projectMilestoneLogsScheduledForDeletion[]= $projectMilestoneLog;
            $projectMilestoneLog->setProjectMilestone(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this ProjectMilestone is new, it will return
     * an empty collection; or if this ProjectMilestone has previously
     * been saved, it will retrieve related ProjectMilestoneLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in ProjectMilestone.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectMilestoneLog[] List of ProjectMilestoneLog objects
     */
    public function getProjectMilestoneLogsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectMilestoneLogQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectMilestoneLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this ProjectMilestone is new, it will return
     * an empty collection; or if this ProjectMilestone has previously
     * been saved, it will retrieve related ProjectMilestoneLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in ProjectMilestone.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectMilestoneLog[] List of ProjectMilestoneLog objects
     */
    public function getProjectMilestoneLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectMilestoneLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjectMilestoneLogs($query, $con);
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->projectid = null;
        $this->name = null;
        $this->date = null;
        $this->expirationdate = null;
        $this->completed = null;
        $this->notes = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collProjectMilestoneLogs) {
                foreach ($this->collProjectMilestoneLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collProjectMilestoneLogs instanceof PropelCollection) {
            $this->collProjectMilestoneLogs->clearIterator();
        }
        $this->collProjectMilestoneLogs = null;
        $this->aProject = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
