<?php


/**
 * Base class that represents a query for the 'projects_indicator' table.
 *
 * Indicator
 *
 * @method ProjectIndicatorQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ProjectIndicatorQuery orderByProjectid($order = Criteria::ASC) Order by the projectId column
 * @method ProjectIndicatorQuery orderByCommuneid($order = Criteria::ASC) Order by the communeId column
 * @method ProjectIndicatorQuery orderByRegionid($order = Criteria::ASC) Order by the regionId column
 * @method ProjectIndicatorQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ProjectIndicatorQuery orderByExpirationdate($order = Criteria::ASC) Order by the expirationDate column
 * @method ProjectIndicatorQuery orderByMeasureunitid($order = Criteria::ASC) Order by the measureUnitId column
 * @method ProjectIndicatorQuery orderByNotes($order = Criteria::ASC) Order by the notes column
 * @method ProjectIndicatorQuery orderByStarted($order = Criteria::ASC) Order by the started column
 * @method ProjectIndicatorQuery orderByStartdate($order = Criteria::ASC) Order by the startDate column
 * @method ProjectIndicatorQuery orderByEnddate($order = Criteria::ASC) Order by the endDate column
 * @method ProjectIndicatorQuery orderByActualprogress($order = Criteria::ASC) Order by the actualProgress column
 *
 * @method ProjectIndicatorQuery groupById() Group by the id column
 * @method ProjectIndicatorQuery groupByProjectid() Group by the projectId column
 * @method ProjectIndicatorQuery groupByCommuneid() Group by the communeId column
 * @method ProjectIndicatorQuery groupByRegionid() Group by the regionId column
 * @method ProjectIndicatorQuery groupByName() Group by the name column
 * @method ProjectIndicatorQuery groupByExpirationdate() Group by the expirationDate column
 * @method ProjectIndicatorQuery groupByMeasureunitid() Group by the measureUnitId column
 * @method ProjectIndicatorQuery groupByNotes() Group by the notes column
 * @method ProjectIndicatorQuery groupByStarted() Group by the started column
 * @method ProjectIndicatorQuery groupByStartdate() Group by the startDate column
 * @method ProjectIndicatorQuery groupByEnddate() Group by the endDate column
 * @method ProjectIndicatorQuery groupByActualprogress() Group by the actualProgress column
 *
 * @method ProjectIndicatorQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ProjectIndicatorQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ProjectIndicatorQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ProjectIndicatorQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method ProjectIndicatorQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method ProjectIndicatorQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method ProjectIndicatorQuery leftJoinRegion($relationAlias = null) Adds a LEFT JOIN clause to the query using the Region relation
 * @method ProjectIndicatorQuery rightJoinRegion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Region relation
 * @method ProjectIndicatorQuery innerJoinRegion($relationAlias = null) Adds a INNER JOIN clause to the query using the Region relation
 *
 * @method ProjectIndicator findOne(PropelPDO $con = null) Return the first ProjectIndicator matching the query
 * @method ProjectIndicator findOneOrCreate(PropelPDO $con = null) Return the first ProjectIndicator matching the query, or a new ProjectIndicator object populated from the query conditions when no match is found
 *
 * @method ProjectIndicator findOneById(int $id) Return the first ProjectIndicator filtered by the id column
 * @method ProjectIndicator findOneByProjectid(int $projectId) Return the first ProjectIndicator filtered by the projectId column
 * @method ProjectIndicator findOneByCommuneid(int $communeId) Return the first ProjectIndicator filtered by the communeId column
 * @method ProjectIndicator findOneByRegionid(int $regionId) Return the first ProjectIndicator filtered by the regionId column
 * @method ProjectIndicator findOneByName(string $name) Return the first ProjectIndicator filtered by the name column
 * @method ProjectIndicator findOneByExpirationdate(string $expirationDate) Return the first ProjectIndicator filtered by the expirationDate column
 * @method ProjectIndicator findOneByMeasureunitid(int $measureUnitId) Return the first ProjectIndicator filtered by the measureUnitId column
 * @method ProjectIndicator findOneByNotes(string $notes) Return the first ProjectIndicator filtered by the notes column
 * @method ProjectIndicator findOneByStarted(boolean $started) Return the first ProjectIndicator filtered by the started column
 * @method ProjectIndicator findOneByStartdate(string $startDate) Return the first ProjectIndicator filtered by the startDate column
 * @method ProjectIndicator findOneByEnddate(string $endDate) Return the first ProjectIndicator filtered by the endDate column
 * @method ProjectIndicator findOneByActualprogress(int $actualProgress) Return the first ProjectIndicator filtered by the actualProgress column
 *
 * @method array findById(int $id) Return ProjectIndicator objects filtered by the id column
 * @method array findByProjectid(int $projectId) Return ProjectIndicator objects filtered by the projectId column
 * @method array findByCommuneid(int $communeId) Return ProjectIndicator objects filtered by the communeId column
 * @method array findByRegionid(int $regionId) Return ProjectIndicator objects filtered by the regionId column
 * @method array findByName(string $name) Return ProjectIndicator objects filtered by the name column
 * @method array findByExpirationdate(string $expirationDate) Return ProjectIndicator objects filtered by the expirationDate column
 * @method array findByMeasureunitid(int $measureUnitId) Return ProjectIndicator objects filtered by the measureUnitId column
 * @method array findByNotes(string $notes) Return ProjectIndicator objects filtered by the notes column
 * @method array findByStarted(boolean $started) Return ProjectIndicator objects filtered by the started column
 * @method array findByStartdate(string $startDate) Return ProjectIndicator objects filtered by the startDate column
 * @method array findByEnddate(string $endDate) Return ProjectIndicator objects filtered by the endDate column
 * @method array findByActualprogress(int $actualProgress) Return ProjectIndicator objects filtered by the actualProgress column
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectIndicatorQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseProjectIndicatorQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ProjectIndicator', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ProjectIndicatorQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ProjectIndicatorQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ProjectIndicatorQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ProjectIndicatorQuery) {
            return $criteria;
        }
        $query = new ProjectIndicatorQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ProjectIndicator|ProjectIndicator[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ProjectIndicatorPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ProjectIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ProjectIndicator A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `PROJECTID`, `COMMUNEID`, `REGIONID`, `NAME`, `EXPIRATIONDATE`, `MEASUREUNITID`, `NOTES`, `STARTED`, `STARTDATE`, `ENDDATE`, `ACTUALPROGRESS` FROM `projects_indicator` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ProjectIndicator();
            $obj->hydrate($row);
            ProjectIndicatorPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ProjectIndicator|ProjectIndicator[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ProjectIndicator[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProjectIndicatorPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProjectIndicatorPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the projectId column
     *
     * Example usage:
     * <code>
     * $query->filterByProjectid(1234); // WHERE projectId = 1234
     * $query->filterByProjectid(array(12, 34)); // WHERE projectId IN (12, 34)
     * $query->filterByProjectid(array('min' => 12)); // WHERE projectId > 12
     * </code>
     *
     * @see       filterByProject()
     *
     * @param     mixed $projectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByProjectid($projectid = null, $comparison = null)
    {
        if (is_array($projectid)) {
            $useMinMax = false;
            if (isset($projectid['min'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::PROJECTID, $projectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($projectid['max'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::PROJECTID, $projectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::PROJECTID, $projectid, $comparison);
    }

    /**
     * Filter the query on the communeId column
     *
     * Example usage:
     * <code>
     * $query->filterByCommuneid(1234); // WHERE communeId = 1234
     * $query->filterByCommuneid(array(12, 34)); // WHERE communeId IN (12, 34)
     * $query->filterByCommuneid(array('min' => 12)); // WHERE communeId > 12
     * </code>
     *
     * @param     mixed $communeid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByCommuneid($communeid = null, $comparison = null)
    {
        if (is_array($communeid)) {
            $useMinMax = false;
            if (isset($communeid['min'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::COMMUNEID, $communeid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($communeid['max'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::COMMUNEID, $communeid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::COMMUNEID, $communeid, $comparison);
    }

    /**
     * Filter the query on the regionId column
     *
     * Example usage:
     * <code>
     * $query->filterByRegionid(1234); // WHERE regionId = 1234
     * $query->filterByRegionid(array(12, 34)); // WHERE regionId IN (12, 34)
     * $query->filterByRegionid(array('min' => 12)); // WHERE regionId > 12
     * </code>
     *
     * @see       filterByRegion()
     *
     * @param     mixed $regionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByRegionid($regionid = null, $comparison = null)
    {
        if (is_array($regionid)) {
            $useMinMax = false;
            if (isset($regionid['min'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::REGIONID, $regionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($regionid['max'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::REGIONID, $regionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::REGIONID, $regionid, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the expirationDate column
     *
     * Example usage:
     * <code>
     * $query->filterByExpirationdate('2011-03-14'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate('now'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate(array('max' => 'yesterday')); // WHERE expirationDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $expirationdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByExpirationdate($expirationdate = null, $comparison = null)
    {
        if (is_array($expirationdate)) {
            $useMinMax = false;
            if (isset($expirationdate['min'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::EXPIRATIONDATE, $expirationdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($expirationdate['max'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::EXPIRATIONDATE, $expirationdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::EXPIRATIONDATE, $expirationdate, $comparison);
    }

    /**
     * Filter the query on the measureUnitId column
     *
     * Example usage:
     * <code>
     * $query->filterByMeasureunitid(1234); // WHERE measureUnitId = 1234
     * $query->filterByMeasureunitid(array(12, 34)); // WHERE measureUnitId IN (12, 34)
     * $query->filterByMeasureunitid(array('min' => 12)); // WHERE measureUnitId > 12
     * </code>
     *
     * @param     mixed $measureunitid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByMeasureunitid($measureunitid = null, $comparison = null)
    {
        if (is_array($measureunitid)) {
            $useMinMax = false;
            if (isset($measureunitid['min'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::MEASUREUNITID, $measureunitid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($measureunitid['max'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::MEASUREUNITID, $measureunitid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::MEASUREUNITID, $measureunitid, $comparison);
    }

    /**
     * Filter the query on the notes column
     *
     * Example usage:
     * <code>
     * $query->filterByNotes('fooValue');   // WHERE notes = 'fooValue'
     * $query->filterByNotes('%fooValue%'); // WHERE notes LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notes The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByNotes($notes = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notes)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $notes)) {
                $notes = str_replace('*', '%', $notes);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::NOTES, $notes, $comparison);
    }

    /**
     * Filter the query on the started column
     *
     * Example usage:
     * <code>
     * $query->filterByStarted(true); // WHERE started = true
     * $query->filterByStarted('yes'); // WHERE started = true
     * </code>
     *
     * @param     boolean|string $started The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByStarted($started = null, $comparison = null)
    {
        if (is_string($started)) {
            $started = in_array(strtolower($started), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::STARTED, $started, $comparison);
    }

    /**
     * Filter the query on the startDate column
     *
     * Example usage:
     * <code>
     * $query->filterByStartdate('2011-03-14'); // WHERE startDate = '2011-03-14'
     * $query->filterByStartdate('now'); // WHERE startDate = '2011-03-14'
     * $query->filterByStartdate(array('max' => 'yesterday')); // WHERE startDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $startdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByStartdate($startdate = null, $comparison = null)
    {
        if (is_array($startdate)) {
            $useMinMax = false;
            if (isset($startdate['min'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::STARTDATE, $startdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startdate['max'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::STARTDATE, $startdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::STARTDATE, $startdate, $comparison);
    }

    /**
     * Filter the query on the endDate column
     *
     * Example usage:
     * <code>
     * $query->filterByEnddate('2011-03-14'); // WHERE endDate = '2011-03-14'
     * $query->filterByEnddate('now'); // WHERE endDate = '2011-03-14'
     * $query->filterByEnddate(array('max' => 'yesterday')); // WHERE endDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $enddate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByEnddate($enddate = null, $comparison = null)
    {
        if (is_array($enddate)) {
            $useMinMax = false;
            if (isset($enddate['min'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::ENDDATE, $enddate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($enddate['max'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::ENDDATE, $enddate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::ENDDATE, $enddate, $comparison);
    }

    /**
     * Filter the query on the actualProgress column
     *
     * Example usage:
     * <code>
     * $query->filterByActualprogress(1234); // WHERE actualProgress = 1234
     * $query->filterByActualprogress(array(12, 34)); // WHERE actualProgress IN (12, 34)
     * $query->filterByActualprogress(array('min' => 12)); // WHERE actualProgress > 12
     * </code>
     *
     * @param     mixed $actualprogress The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function filterByActualprogress($actualprogress = null, $comparison = null)
    {
        if (is_array($actualprogress)) {
            $useMinMax = false;
            if (isset($actualprogress['min'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::ACTUALPROGRESS, $actualprogress['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($actualprogress['max'])) {
                $this->addUsingAlias(ProjectIndicatorPeer::ACTUALPROGRESS, $actualprogress['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectIndicatorPeer::ACTUALPROGRESS, $actualprogress, $comparison);
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectIndicatorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(ProjectIndicatorPeer::PROJECTID, $project->getId(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectIndicatorPeer::PROJECTID, $project->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related Region object
     *
     * @param   Region|PropelObjectCollection $region The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectIndicatorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByRegion($region, $comparison = null)
    {
        if ($region instanceof Region) {
            return $this
                ->addUsingAlias(ProjectIndicatorPeer::REGIONID, $region->getId(), $comparison);
        } elseif ($region instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectIndicatorPeer::REGIONID, $region->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByRegion() only accepts arguments of type Region or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Region relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function joinRegion($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Region');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Region');
        }

        return $this;
    }

    /**
     * Use the Region relation Region object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   RegionQuery A secondary query class using the current class as primary query
     */
    public function useRegionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinRegion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Region', 'RegionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ProjectIndicator $projectIndicator Object to remove from the list of results
     *
     * @return ProjectIndicatorQuery The current query, for fluid interface
     */
    public function prune($projectIndicator = null)
    {
        if ($projectIndicator) {
            $this->addUsingAlias(ProjectIndicatorPeer::ID, $projectIndicator->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
