<?php



/**
 * This class defines the structure of the 'projects_project' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.projects.classes.map
 */
class ProjectTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'projects.classes.map.ProjectTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('projects_project');
        $this->setPhpName('Project');
        $this->setClassname('Project');
        $this->setPackage('projects.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addForeignKey('OBJECTIVEID', 'Objectiveid', 'INTEGER', 'objectives_objective', 'ID', true, null, null);
        $this->addColumn('CODE', 'Code', 'VARCHAR', false, 50, null);
        $this->addColumn('CODEAUX', 'Codeaux', 'VARCHAR', false, 50, null);
        $this->addColumn('NAME', 'Name', 'VARCHAR', true, 255, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('DESCRIPTION', 'Description', 'LONGVARCHAR', false, null, null);
        $this->addColumn('IMPACT', 'Impact', 'LONGVARCHAR', false, null, null);
        $this->addColumn('UNIQUEGOAL', 'Uniquegoal', 'LONGVARCHAR', false, null, null);
        $this->addColumn('GOALEXPIRATIONDATE', 'Goalexpirationdate', 'DATE', false, null, null);
        $this->addColumn('DATE', 'Date', 'TIMESTAMP', false, null, null);
        $this->addColumn('BUDGETPLANNED', 'Budgetplanned', 'FLOAT', false, null, null);
        $this->addColumn('BUDGET', 'Budget', 'FLOAT', false, null, null);
        $this->addColumn('EXCHANGERATE', 'Exchangerate', 'FLOAT', false, null, null);
        $this->addColumn('VISIBILITY', 'Visibility', 'INTEGER', false, null, null);
        $this->addColumn('COORDINATENEED', 'Coordinateneed', 'LONGVARCHAR', false, null, null);
        $this->addColumn('FREQUENCY', 'Frequency', 'LONGVARCHAR', false, null, null);
        $this->addColumn('FINISHED', 'Finished', 'BOOLEAN', false, 1, null);
        $this->addColumn('NOTES', 'Notes', 'LONGVARCHAR', false, null, null);
        $this->addColumn('POSTALCODE', 'Postalcode', 'VARCHAR', false, 8, null);
        $this->addColumn('UNIQUEGOALNUMERIC', 'Uniquegoalnumeric', 'INTEGER', false, null, null);
        $this->addColumn('GOALPROGRESS', 'Goalprogress', 'INTEGER', false, null, null);
        $this->addColumn('LATITUDE', 'Latitude', 'FLOAT', false, null, null);
        $this->addColumn('LONGITUDE', 'Longitude', 'FLOAT', false, null, null);
        $this->addColumn('OLDID', 'Oldid', 'INTEGER', false, null, null);
        $this->addColumn('REGIONID', 'Regionid', 'INTEGER', false, null, null);
        $this->addColumn('OLDREGIONID', 'Oldregionid', 'INTEGER', false, null, null);
        $this->addColumn('LASTMODIFICATION', 'Lastmodification', 'TIMESTAMP', false, null, null);
        $this->addColumn('ADDRESS', 'Address', 'VARCHAR', false, 255, null);
        $this->addColumn('STREET', 'Street', 'VARCHAR', false, 100, null);
        $this->addColumn('NUMBER', 'Number', 'INTEGER', false, null, null);
        $this->addColumn('PRIORITY', 'Priority', 'INTEGER', false, null, null);
        $this->addColumn('MODIFICATIONS', 'Modifications', 'INTEGER', false, null, null);
        $this->addColumn('PLANNEDSTART', 'Plannedstart', 'DATE', false, null, null);
        $this->addColumn('PLANNEDEND', 'Plannedend', 'DATE', false, null, null);
        $this->addColumn('REALSTART', 'Realstart', 'DATE', false, null, null);
        $this->addColumn('REALEND', 'Realend', 'DATE', false, null, null);
        $this->addColumn('CANCELLED', 'Cancelled', 'BOOLEAN', false, 1, null);
        $this->addColumn('ISCONSTRUCTION', 'Isconstruction', 'BOOLEAN', false, 1, null);
        $this->addColumn('RELEVANCE', 'Relevance', 'VARCHAR', false, 255, null);
        $this->addForeignKey('USERID', 'Userid', 'INTEGER', 'users_user', 'ID', false, null, null);
        $this->addColumn('ORDER', 'Order', 'INTEGER', true, null, 0);
        $this->addColumn('WEIGHT', 'Weight', 'DECIMAL', true, null, 0);
        $this->addColumn('UPDATED', 'Updated', 'TIMESTAMP', false, null, null);
        $this->addForeignKey('RESPONSIBLECODE', 'Responsiblecode', 'INTEGER', 'positions_position', 'CODE', true, null, null);
        $this->addForeignKey('INDICATORID', 'Indicatorid', 'INTEGER', 'indicators_indicator', 'ID', false, null, null);
        $this->addColumn('PRIMARYSOURCE', 'Primarysource', 'VARCHAR', false, 24, null);
        $this->addColumn('ADDITIONALSOURCE', 'Additionalsource', 'VARCHAR', false, 24, null);
        $this->addColumn('STARTINGYEAR', 'Startingyear', 'INTEGER', false, null, null);
        $this->addColumn('ENDINGYEAR', 'Endingyear', 'INTEGER', false, null, null);
        $this->addColumn('SUBPROJECT', 'Subproject', 'VARCHAR', false, 255, null);
        $this->addColumn('ONGOING', 'Ongoing', 'LONGVARCHAR', false, null, null);
        $this->addColumn('RELATEDAREAS', 'Relatedareas', 'LONGVARCHAR', false, null, null);
        $this->addColumn('GOAL', 'Goal', 'VARCHAR', false, 255, null);
        $this->addColumn('LEGAL', 'Legal', 'LONGVARCHAR', false, null, null);
        $this->addColumn('EXECRESP', 'Execresp', 'VARCHAR', false, 255, null);
        $this->addColumn('EXECTENURE', 'Exectenure', 'VARCHAR', false, 255, null);
        $this->addColumn('EXECDEPENDENCY', 'Execdependency', 'VARCHAR', false, 255, null);
        $this->addColumn('EXECCONTACT', 'Execcontact', 'VARCHAR', false, 255, null);
        $this->addColumn('SUBSECRETARY', 'Subsecretary', 'VARCHAR', false, 255, null);
        $this->addColumn('BUDGETREQUESTED', 'Budgetrequested', 'FLOAT', false, null, null);
        $this->addColumn('BUDGETSANCTIONED', 'Budgetsanctioned', 'FLOAT', false, null, null);
        $this->addColumn('BELGRANO', 'Belgrano', 'BOOLEAN', false, 1, null);
        $this->addColumn('CLASIFICATION', 'Clasification', 'INTEGER', false, null, 0);
        $this->addColumn('PRESS', 'Press', 'BOOLEAN', false, 1, null);
        $this->addColumn('PRIORITYAREA', 'Priorityarea', 'INTEGER', false, null, 0);
        $this->addColumn('BENEFICIARIO', 'Beneficiario', 'LONGVARCHAR', false, null, null);
        $this->addColumn('REQUIRECONTRACTOR', 'Requirecontractor', 'BOOLEAN', false, 1, null);
        $this->addColumn('PURCHASETYPE', 'Purchasetype', 'INTEGER', false, null, null);
        $this->addColumn('CONSTRUCTIONTYPE', 'Constructiontype', 'INTEGER', false, null, null);
        $this->addColumn('REQUIREEXRARESOURCES', 'Requireexraresources', 'BOOLEAN', false, 1, null);
        $this->addColumn('IMPLEMENTATIONPARTNER', 'Implementationpartner', 'LONGVARCHAR', false, null, null);
        $this->addColumn('RISKFACTORS', 'Riskfactors', 'LONGVARCHAR', false, null, null);
        $this->addColumn('OWNFINANCE', 'Ownfinance', 'INTEGER', false, null, null);
        $this->addColumn('PROVINCEFINANCE', 'Provincefinance', 'INTEGER', false, null, null);
        $this->addColumn('NATIONFINANCE', 'Nationfinance', 'INTEGER', false, null, null);
        $this->addColumn('OTHERFINANCE', 'Otherfinance', 'INTEGER', false, null, null);
        $this->addColumn('FINANCEDETAIL', 'Financedetail', 'VARCHAR', false, 255, null);
        $this->addColumn('FINANCEPROGRAM', 'Financeprogram', 'VARCHAR', false, 255, null);
        $this->addColumn('CREATED_AT', 'CreatedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('UPDATED_AT', 'UpdatedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        // validators
        $this->addValidator('NAME', 'maxLength', 'propel.validator.MaxLengthValidator', '255', 'El nombre no debe contener mas de 255 caracteres');
        $this->addValidator('NAME', 'required', 'propel.validator.RequiredValidator', '', 'El nombre es obligatorio');
        $this->addValidator('RESPONSIBLECODE', 'required', 'propel.validator.RequiredValidator', '', 'El responsable es obligatorio');
        $this->addValidator('OBJECTIVEID', 'required', 'propel.validator.RequiredValidator', '', 'El ##objectives,3,Objetivo## es obligatorio');
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Objective', 'Objective', RelationMap::MANY_TO_ONE, array('objectiveId' => 'id', ), null, null);
        $this->addRelation('Position', 'Position', RelationMap::MANY_TO_ONE, array('responsibleCode' => 'code', ), null, null);
        $this->addRelation('Indicator', 'Indicator', RelationMap::MANY_TO_ONE, array('indicatorId' => 'id', ), null, null);
        $this->addRelation('User', 'User', RelationMap::MANY_TO_ONE, array('userId' => 'id', ), null, null);
        $this->addRelation('Construction', 'Construction', RelationMap::ONE_TO_MANY, array('id' => 'proyectId', ), 'CASCADE', null, 'Constructions');
        $this->addRelation('Guarantee', 'Guarantee', RelationMap::ONE_TO_MANY, array('id' => 'projectId', ), 'SET NULL', null, 'Guarantees');
        $this->addRelation('AdministrativeAct', 'AdministrativeAct', RelationMap::ONE_TO_MANY, array('id' => 'projectId', ), 'SET NULL', null, 'AdministrativeActs');
        $this->addRelation('Mission', 'Mission', RelationMap::ONE_TO_MANY, array('id' => 'projectId', ), 'SET NULL', null, 'Missions');
        $this->addRelation('ProjectRegion', 'ProjectRegion', RelationMap::ONE_TO_MANY, array('id' => 'projectId', ), null, null, 'ProjectRegions');
        $this->addRelation('ProjectMilestone', 'ProjectMilestone', RelationMap::ONE_TO_MANY, array('id' => 'projectId', ), null, null, 'ProjectMilestones');
        $this->addRelation('ProjectIndicator', 'ProjectIndicator', RelationMap::ONE_TO_MANY, array('id' => 'projectId', ), null, null, 'ProjectIndicators');
        $this->addRelation('ProjectActivity', 'ProjectActivity', RelationMap::ONE_TO_MANY, array('id' => 'projectId', ), null, null, 'ProjectActivitys');
        $this->addRelation('ProjectDocument', 'ProjectDocument', RelationMap::ONE_TO_MANY, array('id' => 'project_id', ), 'CASCADE', null, 'ProjectDocuments');
        $this->addRelation('ProjectContractor', 'ProjectContractor', RelationMap::ONE_TO_MANY, array('id' => 'project_id', ), 'CASCADE', null, 'ProjectContractors');
        $this->addRelation('ProjectLog', 'ProjectLog', RelationMap::ONE_TO_MANY, array('id' => 'projectId', ), null, null, 'ProjectLogs');
        $this->addRelation('ProjectMilestoneLog', 'ProjectMilestoneLog', RelationMap::ONE_TO_MANY, array('id' => 'projectId', ), null, null, 'ProjectMilestoneLogs');
        $this->addRelation('ProjectActivityLog', 'ProjectActivityLog', RelationMap::ONE_TO_MANY, array('id' => 'projectId', ), null, null, 'ProjectActivityLogs');
        $this->addRelation('Region', 'Region', RelationMap::MANY_TO_MANY, array(), null, null, 'Regions');
        $this->addRelation('Document', 'Document', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Documents');
        $this->addRelation('Contractor', 'Contractor', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Contractors');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'timestampable' => array('create_column' => 'created_at', 'update_column' => 'updated_at', 'disable_updated_at' => 'false', ),
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
        );
    } // getBehaviors()

} // ProjectTableMap
