<?php

class PositionsBarChartXmlAction extends BaseAction {
	
	private $valueGetter;
	private $averageAndPercentilesGetter;
	
	public function __construct($valueGetter, $averageAndPercentilesGetter) {
		$this->valueGetter = $valueGetter;
		$this->averageAndPercentilesGetter = $averageAndPercentilesGetter;
	}
	
	public function execute($mapping, $form, &$request, &$response) {
		
		parent::execute($mapping, $form, $request, $response);
		
		$plugInKey = 'SMARTY_PLUGIN';
		$this->smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($this->smarty == NULL) {
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";
		}
		
		if (empty($_GET['id'])) {
			$this->smarty->assign('invalidId', true);
			return $mapping->findForwardConfig('success');
		}
		
		$position = PositionQuery::create()->findOneById($_GET['id']);
		if (!$position) {
			$this->smarty->assign('invalidId', true);
			return $mapping->findForwardConfig('success');
		}
		$this->smarty->assign('position', $position);
		
		$valueGetter = $this->valueGetter;
		$averageAndPercentilesGetter = $this->averageAndPercentilesGetter;
		
		$averageAndPercentiles = Position::$averageAndPercentilesGetter(array(25,75));
		$this->smarty->assign('chart', array(
			'average' => $averageAndPercentiles['average'],
			'25thPercentile' => $averageAndPercentiles['percentiles']['25'],
			'75thPercentile' => $averageAndPercentiles['percentiles']['75'],
			'value' => $position->$valueGetter()
		));
		
		$this->prepareOutput();
		return $mapping->findForwardConfig('success');
	}
	
	function prepareOutput() {
		
		header ("content-type: text/xml; charset=utf-8");

		//Encabezado BOM para que el flash chart identifique el UTF-8
		echo pack ( "C3" , 0xef, 0xbb, 0xbf );
		
		$this->template->template = 'TemplatePlain.tpl';
	}
}
