<?php


/**
 * Base static class for performing query and update operations on the 'panel_resultFrameValue' table.
 *
 * Valores de los indicadores del Marco de Resultados
 *
 * @package propel.generator.panel.classes.om
 */
abstract class BaseResultFrameValuePeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'panel_resultFrameValue';

    /** the related Propel class for this table */
    const OM_CLASS = 'ResultFrameValue';

    /** the related TableMap class for this table */
    const TM_CLASS = 'ResultFrameValueTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 7;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 7;

    /** the column name for the ID field */
    const ID = 'panel_resultFrameValue.ID';

    /** the column name for the RESULTFRAMEINDICATORID field */
    const RESULTFRAMEINDICATORID = 'panel_resultFrameValue.RESULTFRAMEINDICATORID';

    /** the column name for the YEAR field */
    const YEAR = 'panel_resultFrameValue.YEAR';

    /** the column name for the VALUE field */
    const VALUE = 'panel_resultFrameValue.VALUE';

    /** the column name for the GOAL field */
    const GOAL = 'panel_resultFrameValue.GOAL';

    /** the column name for the UPDATED field */
    const UPDATED = 'panel_resultFrameValue.UPDATED';

    /** the column name for the DELETED_AT field */
    const DELETED_AT = 'panel_resultFrameValue.DELETED_AT';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of ResultFrameValue objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array ResultFrameValue[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. ResultFrameValuePeer::$fieldNames[ResultFrameValuePeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Resultframeindicatorid', 'Year', 'Value', 'Goal', 'Updated', 'DeletedAt', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'resultframeindicatorid', 'year', 'value', 'goal', 'updated', 'deletedAt', ),
        BasePeer::TYPE_COLNAME => array (ResultFrameValuePeer::ID, ResultFrameValuePeer::RESULTFRAMEINDICATORID, ResultFrameValuePeer::YEAR, ResultFrameValuePeer::VALUE, ResultFrameValuePeer::GOAL, ResultFrameValuePeer::UPDATED, ResultFrameValuePeer::DELETED_AT, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'RESULTFRAMEINDICATORID', 'YEAR', 'VALUE', 'GOAL', 'UPDATED', 'DELETED_AT', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'resultFrameIndicatorId', 'year', 'value', 'goal', 'updated', 'deleted_at', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. ResultFrameValuePeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Resultframeindicatorid' => 1, 'Year' => 2, 'Value' => 3, 'Goal' => 4, 'Updated' => 5, 'DeletedAt' => 6, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'resultframeindicatorid' => 1, 'year' => 2, 'value' => 3, 'goal' => 4, 'updated' => 5, 'deletedAt' => 6, ),
        BasePeer::TYPE_COLNAME => array (ResultFrameValuePeer::ID => 0, ResultFrameValuePeer::RESULTFRAMEINDICATORID => 1, ResultFrameValuePeer::YEAR => 2, ResultFrameValuePeer::VALUE => 3, ResultFrameValuePeer::GOAL => 4, ResultFrameValuePeer::UPDATED => 5, ResultFrameValuePeer::DELETED_AT => 6, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'RESULTFRAMEINDICATORID' => 1, 'YEAR' => 2, 'VALUE' => 3, 'GOAL' => 4, 'UPDATED' => 5, 'DELETED_AT' => 6, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'resultFrameIndicatorId' => 1, 'year' => 2, 'value' => 3, 'goal' => 4, 'updated' => 5, 'deleted_at' => 6, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = ResultFrameValuePeer::getFieldNames($toType);
        $key = isset(ResultFrameValuePeer::$fieldKeys[$fromType][$name]) ? ResultFrameValuePeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(ResultFrameValuePeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, ResultFrameValuePeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return ResultFrameValuePeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. ResultFrameValuePeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(ResultFrameValuePeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ResultFrameValuePeer::ID);
            $criteria->addSelectColumn(ResultFrameValuePeer::RESULTFRAMEINDICATORID);
            $criteria->addSelectColumn(ResultFrameValuePeer::YEAR);
            $criteria->addSelectColumn(ResultFrameValuePeer::VALUE);
            $criteria->addSelectColumn(ResultFrameValuePeer::GOAL);
            $criteria->addSelectColumn(ResultFrameValuePeer::UPDATED);
            $criteria->addSelectColumn(ResultFrameValuePeer::DELETED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.RESULTFRAMEINDICATORID');
            $criteria->addSelectColumn($alias . '.YEAR');
            $criteria->addSelectColumn($alias . '.VALUE');
            $criteria->addSelectColumn($alias . '.GOAL');
            $criteria->addSelectColumn($alias . '.UPDATED');
            $criteria->addSelectColumn($alias . '.DELETED_AT');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ResultFrameValuePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ResultFrameValuePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(ResultFrameValuePeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // soft_delete behavior
        if (ResultFrameValueQuery::isSoftDeleteEnabled()) {
            $criteria->add(ResultFrameValuePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ResultFrameValuePeer::enableSoftDelete();
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 ResultFrameValue
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = ResultFrameValuePeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return ResultFrameValuePeer::populateObjects(ResultFrameValuePeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            ResultFrameValuePeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(ResultFrameValuePeer::DATABASE_NAME);
        // soft_delete behavior
        if (ResultFrameValueQuery::isSoftDeleteEnabled()) {
            $criteria->add(ResultFrameValuePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ResultFrameValuePeer::enableSoftDelete();
        }

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      ResultFrameValue $obj A ResultFrameValue object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            ResultFrameValuePeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A ResultFrameValue object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof ResultFrameValue) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or ResultFrameValue object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(ResultFrameValuePeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   ResultFrameValue Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(ResultFrameValuePeer::$instances[$key])) {
                return ResultFrameValuePeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        ResultFrameValuePeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to panel_resultFrameValue
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = ResultFrameValuePeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = ResultFrameValuePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = ResultFrameValuePeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ResultFrameValuePeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (ResultFrameValue object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = ResultFrameValuePeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = ResultFrameValuePeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + ResultFrameValuePeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ResultFrameValuePeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            ResultFrameValuePeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related ResultFrameIndicator table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinResultFrameIndicator(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ResultFrameValuePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ResultFrameValuePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ResultFrameValuePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ResultFrameValuePeer::RESULTFRAMEINDICATORID, ResultFrameIndicatorPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ResultFrameValueQuery::isSoftDeleteEnabled()) {
            $criteria->add(ResultFrameValuePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ResultFrameValuePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of ResultFrameValue objects pre-filled with their ResultFrameIndicator objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ResultFrameValue objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinResultFrameIndicator(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ResultFrameValuePeer::DATABASE_NAME);
        }

        ResultFrameValuePeer::addSelectColumns($criteria);
        $startcol = ResultFrameValuePeer::NUM_HYDRATE_COLUMNS;
        ResultFrameIndicatorPeer::addSelectColumns($criteria);

        $criteria->addJoin(ResultFrameValuePeer::RESULTFRAMEINDICATORID, ResultFrameIndicatorPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ResultFrameValueQuery::isSoftDeleteEnabled()) {
            $criteria->add(ResultFrameValuePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ResultFrameValuePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ResultFrameValuePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ResultFrameValuePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ResultFrameValuePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ResultFrameValuePeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = ResultFrameIndicatorPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = ResultFrameIndicatorPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ResultFrameIndicatorPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    ResultFrameIndicatorPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ResultFrameValue) to $obj2 (ResultFrameIndicator)
                $obj2->addResultFrameValue($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ResultFrameValuePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ResultFrameValuePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ResultFrameValuePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ResultFrameValuePeer::RESULTFRAMEINDICATORID, ResultFrameIndicatorPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ResultFrameValueQuery::isSoftDeleteEnabled()) {
            $criteria->add(ResultFrameValuePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ResultFrameValuePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of ResultFrameValue objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ResultFrameValue objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ResultFrameValuePeer::DATABASE_NAME);
        }

        ResultFrameValuePeer::addSelectColumns($criteria);
        $startcol2 = ResultFrameValuePeer::NUM_HYDRATE_COLUMNS;

        ResultFrameIndicatorPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ResultFrameIndicatorPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ResultFrameValuePeer::RESULTFRAMEINDICATORID, ResultFrameIndicatorPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ResultFrameValueQuery::isSoftDeleteEnabled()) {
            $criteria->add(ResultFrameValuePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ResultFrameValuePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ResultFrameValuePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ResultFrameValuePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ResultFrameValuePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ResultFrameValuePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined ResultFrameIndicator rows

            $key2 = ResultFrameIndicatorPeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = ResultFrameIndicatorPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ResultFrameIndicatorPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ResultFrameIndicatorPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (ResultFrameValue) to the collection in $obj2 (ResultFrameIndicator)
                $obj2->addResultFrameValue($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(ResultFrameValuePeer::DATABASE_NAME)->getTable(ResultFrameValuePeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseResultFrameValuePeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseResultFrameValuePeer::TABLE_NAME)) {
        $dbMap->addTableObject(new ResultFrameValueTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return ResultFrameValuePeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a ResultFrameValue or Criteria object.
     *
     * @param      mixed $values Criteria or ResultFrameValue object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from ResultFrameValue object
        }

        if ($criteria->containsKey(ResultFrameValuePeer::ID) && $criteria->keyContainsValue(ResultFrameValuePeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ResultFrameValuePeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(ResultFrameValuePeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a ResultFrameValue or Criteria object.
     *
     * @param      mixed $values Criteria or ResultFrameValue object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(ResultFrameValuePeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(ResultFrameValuePeer::ID);
            $value = $criteria->remove(ResultFrameValuePeer::ID);
            if ($value) {
                $selectCriteria->add(ResultFrameValuePeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(ResultFrameValuePeer::TABLE_NAME);
            }

        } else { // $values is ResultFrameValue object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(ResultFrameValuePeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the panel_resultFrameValue table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doForceDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += BasePeer::doDeleteAll(ResultFrameValuePeer::TABLE_NAME, $con, ResultFrameValuePeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ResultFrameValuePeer::clearInstancePool();
            ResultFrameValuePeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a ResultFrameValue or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or ResultFrameValue object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doForceDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // invalidate the cache for all objects of this type, since we have no
            // way of knowing (without running a query) what objects should be invalidated
            // from the cache based on this Criteria.
            ResultFrameValuePeer::clearInstancePool();
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof ResultFrameValue) { // it's a model object
            // invalidate the cache for this single object
            ResultFrameValuePeer::removeInstanceFromPool($values);
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ResultFrameValuePeer::DATABASE_NAME);
            $criteria->add(ResultFrameValuePeer::ID, (array) $values, Criteria::IN);
            // invalidate the cache for this object(s)
            foreach ((array) $values as $singleval) {
                ResultFrameValuePeer::removeInstanceFromPool($singleval);
            }
        }

        // Set the correct dbName
        $criteria->setDbName(ResultFrameValuePeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            $affectedRows += BasePeer::doDelete($criteria, $con);
            ResultFrameValuePeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Validates all modified columns of given ResultFrameValue object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      ResultFrameValue $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(ResultFrameValuePeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(ResultFrameValuePeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(ResultFrameValuePeer::DATABASE_NAME, ResultFrameValuePeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return ResultFrameValue
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = ResultFrameValuePeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(ResultFrameValuePeer::DATABASE_NAME);
        $criteria->add(ResultFrameValuePeer::ID, $pk);

        $v = ResultFrameValuePeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return ResultFrameValue[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(ResultFrameValuePeer::DATABASE_NAME);
            $criteria->add(ResultFrameValuePeer::ID, $pks, Criteria::IN);
            $objs = ResultFrameValuePeer::doSelect($criteria, $con);
        }

        return $objs;
    }

    // soft_delete behavior

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        ResultFrameValueQuery::enableSoftDelete();
        // some soft_deleted objects may be in the instance pool
        ResultFrameValuePeer::clearInstancePool();
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        ResultFrameValueQuery::disableSoftDelete();
    }

    /**
     * Check the soft_delete behavior for this model
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return ResultFrameValueQuery::isSoftDeleteEnabled();
    }

    /**
     * Soft delete records, given a ResultFrameValue or Criteria object OR a primary key value.
     *
     * @param			 mixed $values Criteria or ResultFrameValue object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDelete($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        if ($values instanceof Criteria) {
            // rename for clarity
            $selectCriteria = clone $values;
         } elseif ($values instanceof ResultFrameValue) {
            // create criteria based on pk values
            $selectCriteria = $values->buildPkeyCriteria();
        } else {
            // it must be the primary key
            $selectCriteria = new Criteria(self::DATABASE_NAME);
             $selectCriteria->add(ResultFrameValuePeer::ID, (array) $values, Criteria::IN);
        }
        // Set the correct dbName
        $selectCriteria->setDbName(ResultFrameValuePeer::DATABASE_NAME);
        $updateCriteria = new Criteria(self::DATABASE_NAME);
        $updateCriteria->add(ResultFrameValuePeer::DELETED_AT, time());

         return BasePeer::doUpdate($selectCriteria, $updateCriteria, $con);
    }

    /**
     * Delete or soft delete records, depending on ResultFrameValuePeer::$softDelete
     *
     * @param			 mixed $values Criteria or ResultFrameValue object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDelete($values, PropelPDO $con = null)
    {
        if (ResultFrameValuePeer::isSoftDeleteEnabled()) {
            return ResultFrameValuePeer::doSoftDelete($values, $con);
        } else {
            return ResultFrameValuePeer::doForceDelete($values, $con);
        }
    }
    /**
     * Method to soft delete all rows from the panel_resultFrameValue table.
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $selectCriteria = new Criteria();
        $selectCriteria->add(ResultFrameValuePeer::DELETED_AT, null, Criteria::ISNULL);
        $selectCriteria->setDbName(ResultFrameValuePeer::DATABASE_NAME);
        $modifyCriteria = new Criteria();
        $modifyCriteria->add(ResultFrameValuePeer::DELETED_AT, time());

        return BasePeer::doUpdate($selectCriteria, $modifyCriteria, $con);
    }

    /**
     * Delete or soft delete all records, depending on ResultFrameValuePeer::$softDelete
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if (ResultFrameValuePeer::isSoftDeleteEnabled()) {
            return ResultFrameValuePeer::doSoftDeleteAll($con);
        } else {
            return ResultFrameValuePeer::doForceDeleteAll($con);
        }
    }

} // BaseResultFrameValuePeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseResultFrameValuePeer::buildTableMap();

