<?php


/**
 * Base class that represents a row from the 'panel_resultFrameIndicator' table.
 *
 * Indicador del Marco de Resultados
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseResultFrameIndicator extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ResultFrameIndicatorPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ResultFrameIndicatorPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the type field.
     * @var        int
     */
    protected $type;

    /**
     * The value for the usedata field.
     * @var        boolean
     */
    protected $usedata;

    /**
     * The value for the valuetype field.
     * @var        int
     */
    protected $valuetype;

    /**
     * The value for the content field.
     * @var        string
     */
    protected $content;

    /**
     * The value for the objecttype field.
     * @var        string
     */
    protected $objecttype;

    /**
     * The value for the objectid field.
     * @var        int
     */
    protected $objectid;

    /**
     * The value for the frequency field.
     * @var        int
     */
    protected $frequency;

    /**
     * The value for the basevalue field.
     * @var        string
     */
    protected $basevalue;

    /**
     * The value for the datarecolectioninstrument field.
     * @var        string
     */
    protected $datarecolectioninstrument;

    /**
     * The value for the datarecolectionresponsible field.
     * @var        string
     */
    protected $datarecolectionresponsible;

    /**
     * The value for the updated field.
     * @var        string
     */
    protected $updated;

    /**
     * The value for the tree_left field.
     * @var        int
     */
    protected $tree_left;

    /**
     * The value for the tree_right field.
     * @var        int
     */
    protected $tree_right;

    /**
     * The value for the tree_level field.
     * @var        int
     */
    protected $tree_level;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        PropelObjectCollection|ResultFrameValue[] Collection to store aggregation of ResultFrameValue objects.
     */
    protected $collResultFrameValues;
    protected $collResultFrameValuesPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    // nested_set behavior

    /**
     * Queries to be executed in the save transaction
     * @var        array
     */
    protected $nestedSetQueries = array();

    /**
     * Internal cache for children nodes
     * @var        null|PropelObjectCollection
     */
    protected $collNestedSetChildren = null;

    /**
     * Internal cache for parent node
     * @var        null|ResultFrameIndicator
     */
    protected $aNestedSetParent = null;


    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $resultFrameValuesScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [type] column value.
     * Tipo de indicador
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the [usedata] column value.
     * Utiliza o no datos de indicador
     * @return boolean
     */
    public function getUsedata()
    {
        return $this->usedata;
    }

    /**
     * Get the [valuetype] column value.
     * Tipo de valor del indicador
     * @return int
     */
    public function getValuetype()
    {
        return $this->valuetype;
    }

    /**
     * Get the [content] column value.
     * Content
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Get the [objecttype] column value.
     * Tipo de entidad relacionada.
     * @return string
     */
    public function getObjecttype()
    {
        return $this->objecttype;
    }

    /**
     * Get the [objectid] column value.
     * Id de la entidad relacionada.
     * @return int
     */
    public function getObjectid()
    {
        return $this->objectid;
    }

    /**
     * Get the [frequency] column value.
     * Frecuencia
     * @return int
     */
    public function getFrequency()
    {
        return $this->frequency;
    }

    /**
     * Get the [basevalue] column value.
     * Valor base
     * @return string
     */
    public function getBasevalue()
    {
        return $this->basevalue;
    }

    /**
     * Get the [datarecolectioninstrument] column value.
     * Instrumento de recoleccion de datos
     * @return string
     */
    public function getDatarecolectioninstrument()
    {
        return $this->datarecolectioninstrument;
    }

    /**
     * Get the [datarecolectionresponsible] column value.
     * Encargado de recolectar datos
     * @return string
     */
    public function getDatarecolectionresponsible()
    {
        return $this->datarecolectionresponsible;
    }

    /**
     * Get the [optionally formatted] temporal [updated] column value.
     * Updated
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdated($format = 'Y-m-d H:i:s')
    {
        if ($this->updated === null) {
            return null;
        }

        if ($this->updated === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [tree_left] column value.
     *
     * @return int
     */
    public function getTreeLeft()
    {
        return $this->tree_left;
    }

    /**
     * Get the [tree_right] column value.
     *
     * @return int
     */
    public function getTreeRight()
    {
        return $this->tree_right;
    }

    /**
     * Get the [tree_level] column value.
     *
     * @return int
     */
    public function getTreeLevel()
    {
        return $this->tree_level;
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Name
     * @param string $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [type] column.
     * Tipo de indicador
     * @param int $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setType($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->type !== $v) {
            $this->type = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::TYPE;
        }


        return $this;
    } // setType()

    /**
     * Sets the value of the [usedata] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Utiliza o no datos de indicador
     * @param boolean|integer|string $v The new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setUsedata($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->usedata !== $v) {
            $this->usedata = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::USEDATA;
        }


        return $this;
    } // setUsedata()

    /**
     * Set the value of [valuetype] column.
     * Tipo de valor del indicador
     * @param int $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setValuetype($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->valuetype !== $v) {
            $this->valuetype = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::VALUETYPE;
        }


        return $this;
    } // setValuetype()

    /**
     * Set the value of [content] column.
     * Content
     * @param string $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setContent($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->content !== $v) {
            $this->content = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::CONTENT;
        }


        return $this;
    } // setContent()

    /**
     * Set the value of [objecttype] column.
     * Tipo de entidad relacionada.
     * @param string $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setObjecttype($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->objecttype !== $v) {
            $this->objecttype = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::OBJECTTYPE;
        }


        return $this;
    } // setObjecttype()

    /**
     * Set the value of [objectid] column.
     * Id de la entidad relacionada.
     * @param int $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setObjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->objectid !== $v) {
            $this->objectid = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::OBJECTID;
        }


        return $this;
    } // setObjectid()

    /**
     * Set the value of [frequency] column.
     * Frecuencia
     * @param int $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setFrequency($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->frequency !== $v) {
            $this->frequency = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::FREQUENCY;
        }


        return $this;
    } // setFrequency()

    /**
     * Set the value of [basevalue] column.
     * Valor base
     * @param string $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setBasevalue($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->basevalue !== $v) {
            $this->basevalue = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::BASEVALUE;
        }


        return $this;
    } // setBasevalue()

    /**
     * Set the value of [datarecolectioninstrument] column.
     * Instrumento de recoleccion de datos
     * @param string $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setDatarecolectioninstrument($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->datarecolectioninstrument !== $v) {
            $this->datarecolectioninstrument = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::DATARECOLECTIONINSTRUMENT;
        }


        return $this;
    } // setDatarecolectioninstrument()

    /**
     * Set the value of [datarecolectionresponsible] column.
     * Encargado de recolectar datos
     * @param string $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setDatarecolectionresponsible($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->datarecolectionresponsible !== $v) {
            $this->datarecolectionresponsible = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::DATARECOLECTIONRESPONSIBLE;
        }


        return $this;
    } // setDatarecolectionresponsible()

    /**
     * Sets the value of [updated] column to a normalized version of the date/time value specified.
     * Updated
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setUpdated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated !== null || $dt !== null) {
            $currentDateAsString = ($this->updated !== null && $tmpDt = new DateTime($this->updated)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated = $newDateAsString;
                $this->modifiedColumns[] = ResultFrameIndicatorPeer::UPDATED;
            }
        } // if either are not null


        return $this;
    } // setUpdated()

    /**
     * Set the value of [tree_left] column.
     *
     * @param int $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setTreeLeft($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_left !== $v) {
            $this->tree_left = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::TREE_LEFT;
        }


        return $this;
    } // setTreeLeft()

    /**
     * Set the value of [tree_right] column.
     *
     * @param int $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setTreeRight($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_right !== $v) {
            $this->tree_right = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::TREE_RIGHT;
        }


        return $this;
    } // setTreeRight()

    /**
     * Set the value of [tree_level] column.
     *
     * @param int $v new value
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setTreeLevel($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_level !== $v) {
            $this->tree_level = $v;
            $this->modifiedColumns[] = ResultFrameIndicatorPeer::TREE_LEVEL;
        }


        return $this;
    } // setTreeLevel()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = ResultFrameIndicatorPeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->type = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->usedata = ($row[$startcol + 3] !== null) ? (boolean) $row[$startcol + 3] : null;
            $this->valuetype = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->content = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->objecttype = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->objectid = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
            $this->frequency = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->basevalue = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->datarecolectioninstrument = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->datarecolectionresponsible = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
            $this->updated = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
            $this->tree_left = ($row[$startcol + 13] !== null) ? (int) $row[$startcol + 13] : null;
            $this->tree_right = ($row[$startcol + 14] !== null) ? (int) $row[$startcol + 14] : null;
            $this->tree_level = ($row[$startcol + 15] !== null) ? (int) $row[$startcol + 15] : null;
            $this->deleted_at = ($row[$startcol + 16] !== null) ? (string) $row[$startcol + 16] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 17; // 17 = ResultFrameIndicatorPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating ResultFrameIndicator object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ResultFrameIndicatorPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collResultFrameValues = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ResultFrameIndicatorQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // nested_set behavior
            if ($this->isRoot()) {
                throw new PropelException('Deletion of a root node is disabled for nested sets. Use ResultFrameIndicatorPeer::deleteTree() instead to delete an entire tree');
            }

            if ($this->isInTree()) {
                $this->deleteDescendants($con);
            }

            // soft_delete behavior
            if (!empty($ret) && ResultFrameIndicatorQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                ResultFrameIndicatorPeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                // nested_set behavior
                if ($this->isInTree()) {
                    // fill up the room that was used by the node
                    ResultFrameIndicatorPeer::shiftRLValues(-2, $this->getRightValue() + 1, null, $con);
                }

                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            // nested_set behavior
            if ($this->isNew() && $this->isRoot()) {
                // check if no other root exist in, the tree
                $nbRoots = ResultFrameIndicatorQuery::create()
                    ->addUsingAlias(ResultFrameIndicatorPeer::LEFT_COL, 1, Criteria::EQUAL)
                    ->count($con);
                if ($nbRoots > 0) {
                        throw new PropelException('A root node already exists in this tree. To allow multiple root nodes, add the `use_scope` parameter in the nested_set behavior tag.');
                }
            }
            $this->processNestedSetQueries($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ResultFrameIndicatorPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->resultFrameValuesScheduledForDeletion !== null) {
                if (!$this->resultFrameValuesScheduledForDeletion->isEmpty()) {
                    foreach ($this->resultFrameValuesScheduledForDeletion as $resultFrameValue) {
                        // need to save related object because we set the relation to null
                        $resultFrameValue->save($con);
                    }
                    $this->resultFrameValuesScheduledForDeletion = null;
                }
            }

            if ($this->collResultFrameValues !== null) {
                foreach ($this->collResultFrameValues as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ResultFrameIndicatorPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ResultFrameIndicatorPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ResultFrameIndicatorPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`TYPE`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::USEDATA)) {
            $modifiedColumns[':p' . $index++]  = '`USEDATA`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::VALUETYPE)) {
            $modifiedColumns[':p' . $index++]  = '`VALUETYPE`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::CONTENT)) {
            $modifiedColumns[':p' . $index++]  = '`CONTENT`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::OBJECTTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTTYPE`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::OBJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTID`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::FREQUENCY)) {
            $modifiedColumns[':p' . $index++]  = '`FREQUENCY`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::BASEVALUE)) {
            $modifiedColumns[':p' . $index++]  = '`BASEVALUE`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::DATARECOLECTIONINSTRUMENT)) {
            $modifiedColumns[':p' . $index++]  = '`DATARECOLECTIONINSTRUMENT`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::DATARECOLECTIONRESPONSIBLE)) {
            $modifiedColumns[':p' . $index++]  = '`DATARECOLECTIONRESPONSIBLE`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::UPDATED)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::TREE_LEFT)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_LEFT`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::TREE_RIGHT)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_RIGHT`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::TREE_LEVEL)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_LEVEL`';
        }
        if ($this->isColumnModified(ResultFrameIndicatorPeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `panel_resultFrameIndicator` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`TYPE`':
                        $stmt->bindValue($identifier, $this->type, PDO::PARAM_INT);
                        break;
                    case '`USEDATA`':
                        $stmt->bindValue($identifier, (int) $this->usedata, PDO::PARAM_INT);
                        break;
                    case '`VALUETYPE`':
                        $stmt->bindValue($identifier, $this->valuetype, PDO::PARAM_INT);
                        break;
                    case '`CONTENT`':
                        $stmt->bindValue($identifier, $this->content, PDO::PARAM_STR);
                        break;
                    case '`OBJECTTYPE`':
                        $stmt->bindValue($identifier, $this->objecttype, PDO::PARAM_STR);
                        break;
                    case '`OBJECTID`':
                        $stmt->bindValue($identifier, $this->objectid, PDO::PARAM_INT);
                        break;
                    case '`FREQUENCY`':
                        $stmt->bindValue($identifier, $this->frequency, PDO::PARAM_INT);
                        break;
                    case '`BASEVALUE`':
                        $stmt->bindValue($identifier, $this->basevalue, PDO::PARAM_STR);
                        break;
                    case '`DATARECOLECTIONINSTRUMENT`':
                        $stmt->bindValue($identifier, $this->datarecolectioninstrument, PDO::PARAM_STR);
                        break;
                    case '`DATARECOLECTIONRESPONSIBLE`':
                        $stmt->bindValue($identifier, $this->datarecolectionresponsible, PDO::PARAM_STR);
                        break;
                    case '`UPDATED`':
                        $stmt->bindValue($identifier, $this->updated, PDO::PARAM_STR);
                        break;
                    case '`TREE_LEFT`':
                        $stmt->bindValue($identifier, $this->tree_left, PDO::PARAM_INT);
                        break;
                    case '`TREE_RIGHT`':
                        $stmt->bindValue($identifier, $this->tree_right, PDO::PARAM_INT);
                        break;
                    case '`TREE_LEVEL`':
                        $stmt->bindValue($identifier, $this->tree_level, PDO::PARAM_INT);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = ResultFrameIndicatorPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collResultFrameValues !== null) {
                    foreach ($this->collResultFrameValues as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ResultFrameIndicatorPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getType();
                break;
            case 3:
                return $this->getUsedata();
                break;
            case 4:
                return $this->getValuetype();
                break;
            case 5:
                return $this->getContent();
                break;
            case 6:
                return $this->getObjecttype();
                break;
            case 7:
                return $this->getObjectid();
                break;
            case 8:
                return $this->getFrequency();
                break;
            case 9:
                return $this->getBasevalue();
                break;
            case 10:
                return $this->getDatarecolectioninstrument();
                break;
            case 11:
                return $this->getDatarecolectionresponsible();
                break;
            case 12:
                return $this->getUpdated();
                break;
            case 13:
                return $this->getTreeLeft();
                break;
            case 14:
                return $this->getTreeRight();
                break;
            case 15:
                return $this->getTreeLevel();
                break;
            case 16:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['ResultFrameIndicator'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['ResultFrameIndicator'][$this->getPrimaryKey()] = true;
        $keys = ResultFrameIndicatorPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getType(),
            $keys[3] => $this->getUsedata(),
            $keys[4] => $this->getValuetype(),
            $keys[5] => $this->getContent(),
            $keys[6] => $this->getObjecttype(),
            $keys[7] => $this->getObjectid(),
            $keys[8] => $this->getFrequency(),
            $keys[9] => $this->getBasevalue(),
            $keys[10] => $this->getDatarecolectioninstrument(),
            $keys[11] => $this->getDatarecolectionresponsible(),
            $keys[12] => $this->getUpdated(),
            $keys[13] => $this->getTreeLeft(),
            $keys[14] => $this->getTreeRight(),
            $keys[15] => $this->getTreeLevel(),
            $keys[16] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collResultFrameValues) {
                $result['ResultFrameValues'] = $this->collResultFrameValues->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ResultFrameIndicatorPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setType($value);
                break;
            case 3:
                $this->setUsedata($value);
                break;
            case 4:
                $this->setValuetype($value);
                break;
            case 5:
                $this->setContent($value);
                break;
            case 6:
                $this->setObjecttype($value);
                break;
            case 7:
                $this->setObjectid($value);
                break;
            case 8:
                $this->setFrequency($value);
                break;
            case 9:
                $this->setBasevalue($value);
                break;
            case 10:
                $this->setDatarecolectioninstrument($value);
                break;
            case 11:
                $this->setDatarecolectionresponsible($value);
                break;
            case 12:
                $this->setUpdated($value);
                break;
            case 13:
                $this->setTreeLeft($value);
                break;
            case 14:
                $this->setTreeRight($value);
                break;
            case 15:
                $this->setTreeLevel($value);
                break;
            case 16:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ResultFrameIndicatorPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setType($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setUsedata($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setValuetype($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setContent($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setObjecttype($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setObjectid($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setFrequency($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setBasevalue($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setDatarecolectioninstrument($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setDatarecolectionresponsible($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setUpdated($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setTreeLeft($arr[$keys[13]]);
        if (array_key_exists($keys[14], $arr)) $this->setTreeRight($arr[$keys[14]]);
        if (array_key_exists($keys[15], $arr)) $this->setTreeLevel($arr[$keys[15]]);
        if (array_key_exists($keys[16], $arr)) $this->setDeletedAt($arr[$keys[16]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);

        if ($this->isColumnModified(ResultFrameIndicatorPeer::ID)) $criteria->add(ResultFrameIndicatorPeer::ID, $this->id);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::NAME)) $criteria->add(ResultFrameIndicatorPeer::NAME, $this->name);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::TYPE)) $criteria->add(ResultFrameIndicatorPeer::TYPE, $this->type);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::USEDATA)) $criteria->add(ResultFrameIndicatorPeer::USEDATA, $this->usedata);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::VALUETYPE)) $criteria->add(ResultFrameIndicatorPeer::VALUETYPE, $this->valuetype);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::CONTENT)) $criteria->add(ResultFrameIndicatorPeer::CONTENT, $this->content);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::OBJECTTYPE)) $criteria->add(ResultFrameIndicatorPeer::OBJECTTYPE, $this->objecttype);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::OBJECTID)) $criteria->add(ResultFrameIndicatorPeer::OBJECTID, $this->objectid);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::FREQUENCY)) $criteria->add(ResultFrameIndicatorPeer::FREQUENCY, $this->frequency);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::BASEVALUE)) $criteria->add(ResultFrameIndicatorPeer::BASEVALUE, $this->basevalue);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::DATARECOLECTIONINSTRUMENT)) $criteria->add(ResultFrameIndicatorPeer::DATARECOLECTIONINSTRUMENT, $this->datarecolectioninstrument);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::DATARECOLECTIONRESPONSIBLE)) $criteria->add(ResultFrameIndicatorPeer::DATARECOLECTIONRESPONSIBLE, $this->datarecolectionresponsible);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::UPDATED)) $criteria->add(ResultFrameIndicatorPeer::UPDATED, $this->updated);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::TREE_LEFT)) $criteria->add(ResultFrameIndicatorPeer::TREE_LEFT, $this->tree_left);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::TREE_RIGHT)) $criteria->add(ResultFrameIndicatorPeer::TREE_RIGHT, $this->tree_right);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::TREE_LEVEL)) $criteria->add(ResultFrameIndicatorPeer::TREE_LEVEL, $this->tree_level);
        if ($this->isColumnModified(ResultFrameIndicatorPeer::DELETED_AT)) $criteria->add(ResultFrameIndicatorPeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ResultFrameIndicatorPeer::DATABASE_NAME);
        $criteria->add(ResultFrameIndicatorPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of ResultFrameIndicator (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setType($this->getType());
        $copyObj->setUsedata($this->getUsedata());
        $copyObj->setValuetype($this->getValuetype());
        $copyObj->setContent($this->getContent());
        $copyObj->setObjecttype($this->getObjecttype());
        $copyObj->setObjectid($this->getObjectid());
        $copyObj->setFrequency($this->getFrequency());
        $copyObj->setBasevalue($this->getBasevalue());
        $copyObj->setDatarecolectioninstrument($this->getDatarecolectioninstrument());
        $copyObj->setDatarecolectionresponsible($this->getDatarecolectionresponsible());
        $copyObj->setUpdated($this->getUpdated());
        $copyObj->setTreeLeft($this->getTreeLeft());
        $copyObj->setTreeRight($this->getTreeRight());
        $copyObj->setTreeLevel($this->getTreeLevel());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getResultFrameValues() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addResultFrameValue($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return ResultFrameIndicator Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ResultFrameIndicatorPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ResultFrameIndicatorPeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('ResultFrameValue' == $relationName) {
            $this->initResultFrameValues();
        }
    }

    /**
     * Clears out the collResultFrameValues collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addResultFrameValues()
     */
    public function clearResultFrameValues()
    {
        $this->collResultFrameValues = null; // important to set this to null since that means it is uninitialized
        $this->collResultFrameValuesPartial = null;
    }

    /**
     * reset is the collResultFrameValues collection loaded partially
     *
     * @return void
     */
    public function resetPartialResultFrameValues($v = true)
    {
        $this->collResultFrameValuesPartial = $v;
    }

    /**
     * Initializes the collResultFrameValues collection.
     *
     * By default this just sets the collResultFrameValues collection to an empty array (like clearcollResultFrameValues());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initResultFrameValues($overrideExisting = true)
    {
        if (null !== $this->collResultFrameValues && !$overrideExisting) {
            return;
        }
        $this->collResultFrameValues = new PropelObjectCollection();
        $this->collResultFrameValues->setModel('ResultFrameValue');
    }

    /**
     * Gets an array of ResultFrameValue objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ResultFrameIndicator is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ResultFrameValue[] List of ResultFrameValue objects
     * @throws PropelException
     */
    public function getResultFrameValues($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collResultFrameValuesPartial && !$this->isNew();
        if (null === $this->collResultFrameValues || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collResultFrameValues) {
                // return empty collection
                $this->initResultFrameValues();
            } else {
                $collResultFrameValues = ResultFrameValueQuery::create(null, $criteria)
                    ->filterByResultFrameIndicator($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collResultFrameValuesPartial && count($collResultFrameValues)) {
                      $this->initResultFrameValues(false);

                      foreach($collResultFrameValues as $obj) {
                        if (false == $this->collResultFrameValues->contains($obj)) {
                          $this->collResultFrameValues->append($obj);
                        }
                      }

                      $this->collResultFrameValuesPartial = true;
                    }

                    return $collResultFrameValues;
                }

                if($partial && $this->collResultFrameValues) {
                    foreach($this->collResultFrameValues as $obj) {
                        if($obj->isNew()) {
                            $collResultFrameValues[] = $obj;
                        }
                    }
                }

                $this->collResultFrameValues = $collResultFrameValues;
                $this->collResultFrameValuesPartial = false;
            }
        }

        return $this->collResultFrameValues;
    }

    /**
     * Sets a collection of ResultFrameValue objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $resultFrameValues A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setResultFrameValues(PropelCollection $resultFrameValues, PropelPDO $con = null)
    {
        $this->resultFrameValuesScheduledForDeletion = $this->getResultFrameValues(new Criteria(), $con)->diff($resultFrameValues);

        foreach ($this->resultFrameValuesScheduledForDeletion as $resultFrameValueRemoved) {
            $resultFrameValueRemoved->setResultFrameIndicator(null);
        }

        $this->collResultFrameValues = null;
        foreach ($resultFrameValues as $resultFrameValue) {
            $this->addResultFrameValue($resultFrameValue);
        }

        $this->collResultFrameValues = $resultFrameValues;
        $this->collResultFrameValuesPartial = false;
    }

    /**
     * Returns the number of related ResultFrameValue objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ResultFrameValue objects.
     * @throws PropelException
     */
    public function countResultFrameValues(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collResultFrameValuesPartial && !$this->isNew();
        if (null === $this->collResultFrameValues || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collResultFrameValues) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getResultFrameValues());
                }
                $query = ResultFrameValueQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByResultFrameIndicator($this)
                    ->count($con);
            }
        } else {
            return count($this->collResultFrameValues);
        }
    }

    /**
     * Method called to associate a ResultFrameValue object to this object
     * through the ResultFrameValue foreign key attribute.
     *
     * @param    ResultFrameValue $l ResultFrameValue
     * @return ResultFrameIndicator The current object (for fluent API support)
     */
    public function addResultFrameValue(ResultFrameValue $l)
    {
        if ($this->collResultFrameValues === null) {
            $this->initResultFrameValues();
            $this->collResultFrameValuesPartial = true;
        }
        if (!$this->collResultFrameValues->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddResultFrameValue($l);
        }

        return $this;
    }

    /**
     * @param	ResultFrameValue $resultFrameValue The resultFrameValue object to add.
     */
    protected function doAddResultFrameValue($resultFrameValue)
    {
        $this->collResultFrameValues[]= $resultFrameValue;
        $resultFrameValue->setResultFrameIndicator($this);
    }

    /**
     * @param	ResultFrameValue $resultFrameValue The resultFrameValue object to remove.
     */
    public function removeResultFrameValue($resultFrameValue)
    {
        if ($this->getResultFrameValues()->contains($resultFrameValue)) {
            $this->collResultFrameValues->remove($this->collResultFrameValues->search($resultFrameValue));
            if (null === $this->resultFrameValuesScheduledForDeletion) {
                $this->resultFrameValuesScheduledForDeletion = clone $this->collResultFrameValues;
                $this->resultFrameValuesScheduledForDeletion->clear();
            }
            $this->resultFrameValuesScheduledForDeletion[]= $resultFrameValue;
            $resultFrameValue->setResultFrameIndicator(null);
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->type = null;
        $this->usedata = null;
        $this->valuetype = null;
        $this->content = null;
        $this->objecttype = null;
        $this->objectid = null;
        $this->frequency = null;
        $this->basevalue = null;
        $this->datarecolectioninstrument = null;
        $this->datarecolectionresponsible = null;
        $this->updated = null;
        $this->tree_left = null;
        $this->tree_right = null;
        $this->tree_level = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collResultFrameValues) {
                foreach ($this->collResultFrameValues as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        // nested_set behavior
        $this->collNestedSetChildren = null;
        $this->aNestedSetParent = null;
        if ($this->collResultFrameValues instanceof PropelCollection) {
            $this->collResultFrameValues->clearIterator();
        }
        $this->collResultFrameValues = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(ResultFrameIndicatorPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // nested_set behavior

    /**
     * Execute queries that were saved to be run inside the save transaction
     */
    protected function processNestedSetQueries($con)
    {
        foreach ($this->nestedSetQueries as $query) {
            $query['arguments'][]= $con;
            call_user_func_array($query['callable'], $query['arguments']);
        }
        $this->nestedSetQueries = array();
    }

    /**
     * Proxy getter method for the left value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set left value
     */
    public function getLeftValue()
    {
        return $this->tree_left;
    }

    /**
     * Proxy getter method for the right value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set right value
     */
    public function getRightValue()
    {
        return $this->tree_right;
    }

    /**
     * Proxy getter method for the level value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set level value
     */
    public function getLevel()
    {
        return $this->tree_level;
    }

    /**
     * Proxy setter method for the left value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set left value
     * @return     ResultFrameIndicator The current object (for fluent API support)
     */
    public function setLeftValue($v)
    {
        return $this->setTreeLeft($v);
    }

    /**
     * Proxy setter method for the right value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set right value
     * @return     ResultFrameIndicator The current object (for fluent API support)
     */
    public function setRightValue($v)
    {
        return $this->setTreeRight($v);
    }

    /**
     * Proxy setter method for the level value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set level value
     * @return     ResultFrameIndicator The current object (for fluent API support)
     */
    public function setLevel($v)
    {
        return $this->setTreeLevel($v);
    }

    /**
     * Creates the supplied node as the root node.
     *
     * @return     ResultFrameIndicator The current object (for fluent API support)
     * @throws     PropelException
     */
    public function makeRoot()
    {
        if ($this->getLeftValue() || $this->getRightValue()) {
            throw new PropelException('Cannot turn an existing node into a root node.');
        }

        $this->setLeftValue(1);
        $this->setRightValue(2);
        $this->setLevel(0);

        return $this;
    }

    /**
     * Tests if onbject is a node, i.e. if it is inserted in the tree
     *
     * @return     bool
     */
    public function isInTree()
    {
        return $this->getLeftValue() > 0 && $this->getRightValue() > $this->getLeftValue();
    }

    /**
     * Tests if node is a root
     *
     * @return     bool
     */
    public function isRoot()
    {
        return $this->isInTree() && $this->getLeftValue() == 1;
    }

    /**
     * Tests if node is a leaf
     *
     * @return     bool
     */
    public function isLeaf()
    {
        return $this->isInTree() &&  ($this->getRightValue() - $this->getLeftValue()) == 1;
    }

    /**
     * Tests if node is a descendant of another node
     *
     * @param      ResultFrameIndicator $node Propel node object
     * @return     bool
     */
    public function isDescendantOf($parent)
    {

        return $this->isInTree() && $this->getLeftValue() > $parent->getLeftValue() && $this->getRightValue() < $parent->getRightValue();
    }

    /**
     * Tests if node is a ancestor of another node
     *
     * @param      ResultFrameIndicator $node Propel node object
     * @return     bool
     */
    public function isAncestorOf($child)
    {
        return $child->isDescendantOf($this);
    }

    /**
     * Tests if object has an ancestor
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasParent(PropelPDO $con = null)
    {
        return $this->getLevel() > 0;
    }

    /**
     * Sets the cache for parent node of the current object.
     * Warning: this does not move the current object in the tree.
     * Use moveTofirstChildOf() or moveToLastChildOf() for that purpose
     *
     * @param      ResultFrameIndicator $parent
     * @return     ResultFrameIndicator The current object, for fluid interface
     */
    public function setParent($parent = null)
    {
        $this->aNestedSetParent = $parent;

        return $this;
    }

    /**
     * Gets parent node for the current object if it exists
     * The result is cached so further calls to the same method don't issue any queries
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getParent(PropelPDO $con = null)
    {
        if ($this->aNestedSetParent === null && $this->hasParent()) {
            $this->aNestedSetParent = ResultFrameIndicatorQuery::create()
                ->ancestorsOf($this)
                ->orderByLevel(true)
                ->findOne($con);
        }

        return $this->aNestedSetParent;
    }

    /**
     * Determines if the node has previous sibling
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasPrevSibling(PropelPDO $con = null)
    {
        if (!ResultFrameIndicatorPeer::isValid($this)) {
            return false;
        }

        return ResultFrameIndicatorQuery::create()
            ->filterByTreeRight($this->getLeftValue() - 1)
            ->count($con) > 0;
    }

    /**
     * Gets previous sibling for the given node if it exists
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getPrevSibling(PropelPDO $con = null)
    {
        return ResultFrameIndicatorQuery::create()
            ->filterByTreeRight($this->getLeftValue() - 1)
            ->findOne($con);
    }

    /**
     * Determines if the node has next sibling
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasNextSibling(PropelPDO $con = null)
    {
        if (!ResultFrameIndicatorPeer::isValid($this)) {
            return false;
        }

        return ResultFrameIndicatorQuery::create()
            ->filterByTreeLeft($this->getRightValue() + 1)
            ->count($con) > 0;
    }

    /**
     * Gets next sibling for the given node if it exists
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getNextSibling(PropelPDO $con = null)
    {
        return ResultFrameIndicatorQuery::create()
            ->filterByTreeLeft($this->getRightValue() + 1)
            ->findOne($con);
    }

    /**
     * Clears out the $collNestedSetChildren collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return     void
     */
    public function clearNestedSetChildren()
    {
        $this->collNestedSetChildren = null;
    }

    /**
     * Initializes the $collNestedSetChildren collection.
     *
     * @return     void
     */
    public function initNestedSetChildren()
    {
        $this->collNestedSetChildren = new PropelObjectCollection();
        $this->collNestedSetChildren->setModel('ResultFrameIndicator');
    }

    /**
     * Adds an element to the internal $collNestedSetChildren collection.
     * Beware that this doesn't insert a node in the tree.
     * This method is only used to facilitate children hydration.
     *
     * @param      ResultFrameIndicator $resultFrameIndicator
     *
     * @return     void
     */
    public function addNestedSetChild($resultFrameIndicator)
    {
        if ($this->collNestedSetChildren === null) {
            $this->initNestedSetChildren();
        }
        if (!$this->collNestedSetChildren->contains($resultFrameIndicator)) { // only add it if the **same** object is not already associated
            $this->collNestedSetChildren[]= $resultFrameIndicator;
            $resultFrameIndicator->setParent($this);
        }
    }

    /**
     * Tests if node has children
     *
     * @return     bool
     */
    public function hasChildren()
    {
        return ($this->getRightValue() - $this->getLeftValue()) > 1;
    }

    /**
     * Gets the children of the given node
     *
     * @param      Criteria  $criteria Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array     List of ResultFrameIndicator objects
     */
    public function getChildren($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collNestedSetChildren || null !== $criteria) {
            if ($this->isLeaf() || ($this->isNew() && null === $this->collNestedSetChildren)) {
                // return empty collection
                $this->initNestedSetChildren();
            } else {
                $collNestedSetChildren = ResultFrameIndicatorQuery::create(null, $criteria)
                  ->childrenOf($this)
                  ->orderByBranch()
                    ->find($con);
                if (null !== $criteria) {
                    return $collNestedSetChildren;
                }
                $this->collNestedSetChildren = $collNestedSetChildren;
            }
        }

        return $this->collNestedSetChildren;
    }

    /**
     * Gets number of children for the given node
     *
     * @param      Criteria  $criteria Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     int       Number of children
     */
    public function countChildren($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collNestedSetChildren || null !== $criteria) {
            if ($this->isLeaf() || ($this->isNew() && null === $this->collNestedSetChildren)) {
                return 0;
            } else {
                return ResultFrameIndicatorQuery::create(null, $criteria)
                    ->childrenOf($this)
                    ->count($con);
            }
        } else {
            return count($this->collNestedSetChildren);
        }
    }

    /**
     * Gets the first child of the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of ResultFrameIndicator objects
     */
    public function getFirstChild($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return ResultFrameIndicatorQuery::create(null, $query)
                ->childrenOf($this)
                ->orderByBranch()
                ->findOne($con);
        }
    }

    /**
     * Gets the last child of the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of ResultFrameIndicator objects
     */
    public function getLastChild($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return ResultFrameIndicatorQuery::create(null, $query)
                ->childrenOf($this)
                ->orderByBranch(true)
                ->findOne($con);
        }
    }

    /**
     * Gets the siblings of the given node
     *
     * @param      bool			$includeNode Whether to include the current node or not
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     *
     * @return     array 		List of ResultFrameIndicator objects
     */
    public function getSiblings($includeNode = false, $query = null, PropelPDO $con = null)
    {
        if ($this->isRoot()) {
            return array();
        } else {
             $query = ResultFrameIndicatorQuery::create(null, $query)
                    ->childrenOf($this->getParent($con))
                    ->orderByBranch();
            if (!$includeNode) {
                $query->prune($this);
            }

            return $query->find($con);
        }
    }

    /**
     * Gets descendants for the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of ResultFrameIndicator objects
     */
    public function getDescendants($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return ResultFrameIndicatorQuery::create(null, $query)
                ->descendantsOf($this)
                ->orderByBranch()
                ->find($con);
        }
    }

    /**
     * Gets number of descendants for the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     int 		Number of descendants
     */
    public function countDescendants($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            // save one query
            return 0;
        } else {
            return ResultFrameIndicatorQuery::create(null, $query)
                ->descendantsOf($this)
                ->count($con);
        }
    }

    /**
     * Gets descendants for the given node, plus the current node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of ResultFrameIndicator objects
     */
    public function getBranch($query = null, PropelPDO $con = null)
    {
        return ResultFrameIndicatorQuery::create(null, $query)
            ->branchOf($this)
            ->orderByBranch()
            ->find($con);
    }

    /**
     * Gets ancestors for the given node, starting with the root node
     * Use it for breadcrumb paths for instance
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of ResultFrameIndicator objects
     */
    public function getAncestors($query = null, PropelPDO $con = null)
    {
        if ($this->isRoot()) {
            // save one query
            return array();
        } else {
            return ResultFrameIndicatorQuery::create(null, $query)
                ->ancestorsOf($this)
                ->orderByBranch()
                ->find($con);
        }
    }

    /**
     * Inserts the given $child node as first child of current
     * The modifications in the current object and the tree
     * are not persisted until the child object is saved.
     *
     * @param      ResultFrameIndicator $child	Propel object for child node
     *
     * @return     ResultFrameIndicator The current Propel object
     */
    public function addChild(ResultFrameIndicator $child)
    {
        if ($this->isNew()) {
            throw new PropelException('A ResultFrameIndicator object must not be new to accept children.');
        }
        $child->insertAsFirstChildOf($this);

        return $this;
    }

    /**
     * Inserts the current node as first child of given $parent node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      ResultFrameIndicator $parent	Propel object for parent node
     *
     * @return     ResultFrameIndicator The current Propel object
     */
    public function insertAsFirstChildOf($parent)
    {
        if ($this->isInTree()) {
            throw new PropelException('A ResultFrameIndicator object must not already be in the tree to be inserted. Use the moveToFirstChildOf() instead.');
        }
        $left = $parent->getLeftValue() + 1;
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($parent->getLevel() + 1);
        // update the children collection of the parent
        $parent->addNestedSetChild($this);

        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('ResultFrameIndicatorPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as last child of given $parent node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      ResultFrameIndicator $parent	Propel object for parent node
     *
     * @return     ResultFrameIndicator The current Propel object
     */
    public function insertAsLastChildOf($parent)
    {
        if ($this->isInTree()) {
            throw new PropelException('A ResultFrameIndicator object must not already be in the tree to be inserted. Use the moveToLastChildOf() instead.');
        }
        $left = $parent->getRightValue();
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($parent->getLevel() + 1);
        // update the children collection of the parent
        $parent->addNestedSetChild($this);

        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('ResultFrameIndicatorPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as prev sibling given $sibling node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      ResultFrameIndicator $sibling	Propel object for parent node
     *
     * @return     ResultFrameIndicator The current Propel object
     */
    public function insertAsPrevSiblingOf($sibling)
    {
        if ($this->isInTree()) {
            throw new PropelException('A ResultFrameIndicator object must not already be in the tree to be inserted. Use the moveToPrevSiblingOf() instead.');
        }
        $left = $sibling->getLeftValue();
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($sibling->getLevel());
        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('ResultFrameIndicatorPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as next sibling given $sibling node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      ResultFrameIndicator $sibling	Propel object for parent node
     *
     * @return     ResultFrameIndicator The current Propel object
     */
    public function insertAsNextSiblingOf($sibling)
    {
        if ($this->isInTree()) {
            throw new PropelException('A ResultFrameIndicator object must not already be in the tree to be inserted. Use the moveToNextSiblingOf() instead.');
        }
        $left = $sibling->getRightValue() + 1;
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($sibling->getLevel());
        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('ResultFrameIndicatorPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Moves current node and its subtree to be the first child of $parent
     * The modifications in the current object and the tree are immediate
     *
     * @param      ResultFrameIndicator $parent	Propel object for parent node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ResultFrameIndicator The current Propel object
     */
    public function moveToFirstChildOf($parent, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A ResultFrameIndicator object must be already in the tree to be moved. Use the insertAsFirstChildOf() instead.');
        }
        if ($parent->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as child of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($parent->getLeftValue() + 1, $parent->getLevel() - $this->getLevel() + 1, $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the last child of $parent
     * The modifications in the current object and the tree are immediate
     *
     * @param      ResultFrameIndicator $parent	Propel object for parent node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ResultFrameIndicator The current Propel object
     */
    public function moveToLastChildOf($parent, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A ResultFrameIndicator object must be already in the tree to be moved. Use the insertAsLastChildOf() instead.');
        }
        if ($parent->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as child of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($parent->getRightValue(), $parent->getLevel() - $this->getLevel() + 1, $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the previous sibling of $sibling
     * The modifications in the current object and the tree are immediate
     *
     * @param      ResultFrameIndicator $sibling	Propel object for sibling node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ResultFrameIndicator The current Propel object
     */
    public function moveToPrevSiblingOf($sibling, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A ResultFrameIndicator object must be already in the tree to be moved. Use the insertAsPrevSiblingOf() instead.');
        }
        if ($sibling->isRoot()) {
            throw new PropelException('Cannot move to previous sibling of a root node.');
        }
        if ($sibling->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as sibling of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($sibling->getLeftValue(), $sibling->getLevel() - $this->getLevel(), $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the next sibling of $sibling
     * The modifications in the current object and the tree are immediate
     *
     * @param      ResultFrameIndicator $sibling	Propel object for sibling node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ResultFrameIndicator The current Propel object
     */
    public function moveToNextSiblingOf($sibling, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A ResultFrameIndicator object must be already in the tree to be moved. Use the insertAsNextSiblingOf() instead.');
        }
        if ($sibling->isRoot()) {
            throw new PropelException('Cannot move to next sibling of a root node.');
        }
        if ($sibling->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as sibling of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($sibling->getRightValue() + 1, $sibling->getLevel() - $this->getLevel(), $con);

        return $this;
    }

    /**
     * Move current node and its children to location $destLeft and updates rest of tree
     *
     * @param      int	$destLeft Destination left value
     * @param      int	$levelDelta Delta to add to the levels
     * @param      PropelPDO $con		Connection to use.
     */
    protected function moveSubtreeTo($destLeft, $levelDelta, PropelPDO $con = null)
    {
        $left  = $this->getLeftValue();
        $right = $this->getRightValue();

        $treeSize = $right - $left +1;

        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            // make room next to the target for the subtree
            ResultFrameIndicatorPeer::shiftRLValues($treeSize, $destLeft, null, $con);

            if ($left >= $destLeft) { // src was shifted too?
                $left += $treeSize;
                $right += $treeSize;
            }

            if ($levelDelta) {
                // update the levels of the subtree
                ResultFrameIndicatorPeer::shiftLevel($levelDelta, $left, $right, $con);
            }

            // move the subtree to the target
            ResultFrameIndicatorPeer::shiftRLValues($destLeft - $left, $left, $right, $con);

            // remove the empty room at the previous location of the subtree
            ResultFrameIndicatorPeer::shiftRLValues(-$treeSize, $right + 1, null, $con);

            // update all loaded nodes
            ResultFrameIndicatorPeer::updateLoadedNodes(null, $con);

            $con->commit();
        } catch (PropelException $e) {
            $con->rollback();
            throw $e;
        }
    }

    /**
     * Deletes all descendants for the given node
     * Instance pooling is wiped out by this command,
     * so existing ResultFrameIndicator instances are probably invalid (except for the current one)
     *
     * @param      PropelPDO $con Connection to use.
     *
     * @return     int 		number of deleted nodes
     */
    public function deleteDescendants(PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            // save one query
            return;
        }
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameIndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $left = $this->getLeftValue();
        $right = $this->getRightValue();
        $con->beginTransaction();
        try {
            // delete descendant nodes (will empty the instance pool)
            $ret = ResultFrameIndicatorQuery::create()
                ->descendantsOf($this)
                ->delete($con);

            // fill up the room that was used by descendants
            ResultFrameIndicatorPeer::shiftRLValues($left - $right + 1, $right, null, $con);

            // fix the right value for the current node, which is now a leaf
            $this->setRightValue($left + 1);

            $con->commit();
        } catch (Exception $e) {
            $con->rollback();
            throw $e;
        }

        return $ret;
    }

    /**
     * Returns a pre-order iterator for this node and its children.
     *
     * @return     RecursiveIterator
     */
    public function getIterator()
    {
        return new NestedSetRecursiveIterator($this);
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = ResultFrameIndicatorPeer::isSoftDeleteEnabled()) {
            ResultFrameIndicatorPeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            ResultFrameIndicatorPeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
