<?php


/**
 * Base class that represents a row from the 'panel_notification' table.
 *
 *
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseNotification extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'NotificationPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        NotificationPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the objecttype field.
     * @var        string
     */
    protected $objecttype;

    /**
     * The value for the objectid field.
     * @var        int
     */
    protected $objectid;

    /**
     * The value for the type field.
     * @var        int
     */
    protected $type;

    /**
     * The value for the deliveredon field.
     * @var        string
     */
    protected $deliveredon;

    /**
     * The value for the mailaddress field.
     * @var        string
     */
    protected $mailaddress;

    /**
     * The value for the mailbody field.
     * @var        string
     */
    protected $mailbody;

    /**
     * The value for the result field.
     * @var        int
     */
    protected $result;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [objecttype] column value.
     * Clase del objeto al que se envio la notificacion.
     * @return string
     */
    public function getObjecttype()
    {
        return $this->objecttype;
    }

    /**
     * Get the [objectid] column value.
     * Id del objeto al que se envio la notificacion.
     * @return int
     */
    public function getObjectid()
    {
        return $this->objectid;
    }

    /**
     * Get the [type] column value.
     * Tipo de notificacion.
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the [optionally formatted] temporal [deliveredon] column value.
     * Fecha en que fue enviada la notificacion por ultima vez.
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeliveredon($format = 'Y-m-d H:i:s')
    {
        if ($this->deliveredon === null) {
            return null;
        }

        if ($this->deliveredon === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deliveredon);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deliveredon, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [mailaddress] column value.
     * Direccion de mail de notificaciones sin objeto destinatario
     * @return string
     */
    public function getMailaddress()
    {
        return $this->mailaddress;
    }

    /**
     * Get the [mailbody] column value.
     * Cuerpo del mensaje enviado.
     * @return string
     */
    public function getMailbody()
    {
        return $this->mailbody;
    }

    /**
     * Get the [result] column value.
     * Numero de recipientes aceptados
     * @return int
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return Notification The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = NotificationPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [objecttype] column.
     * Clase del objeto al que se envio la notificacion.
     * @param string $v new value
     * @return Notification The current object (for fluent API support)
     */
    public function setObjecttype($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->objecttype !== $v) {
            $this->objecttype = $v;
            $this->modifiedColumns[] = NotificationPeer::OBJECTTYPE;
        }


        return $this;
    } // setObjecttype()

    /**
     * Set the value of [objectid] column.
     * Id del objeto al que se envio la notificacion.
     * @param int $v new value
     * @return Notification The current object (for fluent API support)
     */
    public function setObjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->objectid !== $v) {
            $this->objectid = $v;
            $this->modifiedColumns[] = NotificationPeer::OBJECTID;
        }


        return $this;
    } // setObjectid()

    /**
     * Set the value of [type] column.
     * Tipo de notificacion.
     * @param int $v new value
     * @return Notification The current object (for fluent API support)
     */
    public function setType($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->type !== $v) {
            $this->type = $v;
            $this->modifiedColumns[] = NotificationPeer::TYPE;
        }


        return $this;
    } // setType()

    /**
     * Sets the value of [deliveredon] column to a normalized version of the date/time value specified.
     * Fecha en que fue enviada la notificacion por ultima vez.
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Notification The current object (for fluent API support)
     */
    public function setDeliveredon($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deliveredon !== null || $dt !== null) {
            $currentDateAsString = ($this->deliveredon !== null && $tmpDt = new DateTime($this->deliveredon)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deliveredon = $newDateAsString;
                $this->modifiedColumns[] = NotificationPeer::DELIVEREDON;
            }
        } // if either are not null


        return $this;
    } // setDeliveredon()

    /**
     * Set the value of [mailaddress] column.
     * Direccion de mail de notificaciones sin objeto destinatario
     * @param string $v new value
     * @return Notification The current object (for fluent API support)
     */
    public function setMailaddress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mailaddress !== $v) {
            $this->mailaddress = $v;
            $this->modifiedColumns[] = NotificationPeer::MAILADDRESS;
        }


        return $this;
    } // setMailaddress()

    /**
     * Set the value of [mailbody] column.
     * Cuerpo del mensaje enviado.
     * @param string $v new value
     * @return Notification The current object (for fluent API support)
     */
    public function setMailbody($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mailbody !== $v) {
            $this->mailbody = $v;
            $this->modifiedColumns[] = NotificationPeer::MAILBODY;
        }


        return $this;
    } // setMailbody()

    /**
     * Set the value of [result] column.
     * Numero de recipientes aceptados
     * @param int $v new value
     * @return Notification The current object (for fluent API support)
     */
    public function setResult($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->result !== $v) {
            $this->result = $v;
            $this->modifiedColumns[] = NotificationPeer::RESULT;
        }


        return $this;
    } // setResult()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->objecttype = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->objectid = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->type = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->deliveredon = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->mailaddress = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->mailbody = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->result = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 8; // 8 = NotificationPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Notification object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(NotificationPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = NotificationPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(NotificationPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = NotificationQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(NotificationPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                NotificationPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = NotificationPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . NotificationPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(NotificationPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(NotificationPeer::OBJECTTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTTYPE`';
        }
        if ($this->isColumnModified(NotificationPeer::OBJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTID`';
        }
        if ($this->isColumnModified(NotificationPeer::TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`TYPE`';
        }
        if ($this->isColumnModified(NotificationPeer::DELIVEREDON)) {
            $modifiedColumns[':p' . $index++]  = '`DELIVEREDON`';
        }
        if ($this->isColumnModified(NotificationPeer::MAILADDRESS)) {
            $modifiedColumns[':p' . $index++]  = '`MAILADDRESS`';
        }
        if ($this->isColumnModified(NotificationPeer::MAILBODY)) {
            $modifiedColumns[':p' . $index++]  = '`MAILBODY`';
        }
        if ($this->isColumnModified(NotificationPeer::RESULT)) {
            $modifiedColumns[':p' . $index++]  = '`RESULT`';
        }

        $sql = sprintf(
            'INSERT INTO `panel_notification` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`OBJECTTYPE`':
                        $stmt->bindValue($identifier, $this->objecttype, PDO::PARAM_STR);
                        break;
                    case '`OBJECTID`':
                        $stmt->bindValue($identifier, $this->objectid, PDO::PARAM_INT);
                        break;
                    case '`TYPE`':
                        $stmt->bindValue($identifier, $this->type, PDO::PARAM_INT);
                        break;
                    case '`DELIVEREDON`':
                        $stmt->bindValue($identifier, $this->deliveredon, PDO::PARAM_STR);
                        break;
                    case '`MAILADDRESS`':
                        $stmt->bindValue($identifier, $this->mailaddress, PDO::PARAM_STR);
                        break;
                    case '`MAILBODY`':
                        $stmt->bindValue($identifier, $this->mailbody, PDO::PARAM_STR);
                        break;
                    case '`RESULT`':
                        $stmt->bindValue($identifier, $this->result, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = NotificationPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }



            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = NotificationPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getObjecttype();
                break;
            case 2:
                return $this->getObjectid();
                break;
            case 3:
                return $this->getType();
                break;
            case 4:
                return $this->getDeliveredon();
                break;
            case 5:
                return $this->getMailaddress();
                break;
            case 6:
                return $this->getMailbody();
                break;
            case 7:
                return $this->getResult();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array())
    {
        if (isset($alreadyDumpedObjects['Notification'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Notification'][$this->getPrimaryKey()] = true;
        $keys = NotificationPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getObjecttype(),
            $keys[2] => $this->getObjectid(),
            $keys[3] => $this->getType(),
            $keys[4] => $this->getDeliveredon(),
            $keys[5] => $this->getMailaddress(),
            $keys[6] => $this->getMailbody(),
            $keys[7] => $this->getResult(),
        );

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = NotificationPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setObjecttype($value);
                break;
            case 2:
                $this->setObjectid($value);
                break;
            case 3:
                $this->setType($value);
                break;
            case 4:
                $this->setDeliveredon($value);
                break;
            case 5:
                $this->setMailaddress($value);
                break;
            case 6:
                $this->setMailbody($value);
                break;
            case 7:
                $this->setResult($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = NotificationPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setObjecttype($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setObjectid($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setType($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setDeliveredon($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setMailaddress($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setMailbody($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setResult($arr[$keys[7]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(NotificationPeer::DATABASE_NAME);

        if ($this->isColumnModified(NotificationPeer::ID)) $criteria->add(NotificationPeer::ID, $this->id);
        if ($this->isColumnModified(NotificationPeer::OBJECTTYPE)) $criteria->add(NotificationPeer::OBJECTTYPE, $this->objecttype);
        if ($this->isColumnModified(NotificationPeer::OBJECTID)) $criteria->add(NotificationPeer::OBJECTID, $this->objectid);
        if ($this->isColumnModified(NotificationPeer::TYPE)) $criteria->add(NotificationPeer::TYPE, $this->type);
        if ($this->isColumnModified(NotificationPeer::DELIVEREDON)) $criteria->add(NotificationPeer::DELIVEREDON, $this->deliveredon);
        if ($this->isColumnModified(NotificationPeer::MAILADDRESS)) $criteria->add(NotificationPeer::MAILADDRESS, $this->mailaddress);
        if ($this->isColumnModified(NotificationPeer::MAILBODY)) $criteria->add(NotificationPeer::MAILBODY, $this->mailbody);
        if ($this->isColumnModified(NotificationPeer::RESULT)) $criteria->add(NotificationPeer::RESULT, $this->result);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(NotificationPeer::DATABASE_NAME);
        $criteria->add(NotificationPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Notification (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setObjecttype($this->getObjecttype());
        $copyObj->setObjectid($this->getObjectid());
        $copyObj->setType($this->getType());
        $copyObj->setDeliveredon($this->getDeliveredon());
        $copyObj->setMailaddress($this->getMailaddress());
        $copyObj->setMailbody($this->getMailbody());
        $copyObj->setResult($this->getResult());
        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Notification Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return NotificationPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new NotificationPeer();
        }

        return self::$peer;
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->objecttype = null;
        $this->objectid = null;
        $this->type = null;
        $this->deliveredon = null;
        $this->mailaddress = null;
        $this->mailbody = null;
        $this->result = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(NotificationPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
