<?php


/**
 * Base class that represents a query for the 'panel_guarantee' table.
 *
 * Base de Garantias
 *
 * @method GuaranteeQuery orderById($order = Criteria::ASC) Order by the id column
 * @method GuaranteeQuery orderByCode($order = Criteria::ASC) Order by the code column
 * @method GuaranteeQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method GuaranteeQuery orderByProjectid($order = Criteria::ASC) Order by the projectId column
 * @method GuaranteeQuery orderByContractorid($order = Criteria::ASC) Order by the contractorId column
 * @method GuaranteeQuery orderByIssuer($order = Criteria::ASC) Order by the issuer column
 * @method GuaranteeQuery orderByCurrency($order = Criteria::ASC) Order by the currency column
 * @method GuaranteeQuery orderByAmmount($order = Criteria::ASC) Order by the ammount column
 * @method GuaranteeQuery orderByIssuedate($order = Criteria::ASC) Order by the issueDate column
 * @method GuaranteeQuery orderByExpirationtype($order = Criteria::ASC) Order by the expirationType column
 * @method GuaranteeQuery orderByExpirationdate($order = Criteria::ASC) Order by the expirationDate column
 * @method GuaranteeQuery orderByExpirationterms($order = Criteria::ASC) Order by the expirationTerms column
 * @method GuaranteeQuery orderByReturned($order = Criteria::ASC) Order by the returned column
 * @method GuaranteeQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method GuaranteeQuery groupById() Group by the id column
 * @method GuaranteeQuery groupByCode() Group by the code column
 * @method GuaranteeQuery groupByType() Group by the type column
 * @method GuaranteeQuery groupByProjectid() Group by the projectId column
 * @method GuaranteeQuery groupByContractorid() Group by the contractorId column
 * @method GuaranteeQuery groupByIssuer() Group by the issuer column
 * @method GuaranteeQuery groupByCurrency() Group by the currency column
 * @method GuaranteeQuery groupByAmmount() Group by the ammount column
 * @method GuaranteeQuery groupByIssuedate() Group by the issueDate column
 * @method GuaranteeQuery groupByExpirationtype() Group by the expirationType column
 * @method GuaranteeQuery groupByExpirationdate() Group by the expirationDate column
 * @method GuaranteeQuery groupByExpirationterms() Group by the expirationTerms column
 * @method GuaranteeQuery groupByReturned() Group by the returned column
 * @method GuaranteeQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method GuaranteeQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method GuaranteeQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method GuaranteeQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method GuaranteeQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method GuaranteeQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method GuaranteeQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method GuaranteeQuery leftJoinContractor($relationAlias = null) Adds a LEFT JOIN clause to the query using the Contractor relation
 * @method GuaranteeQuery rightJoinContractor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Contractor relation
 * @method GuaranteeQuery innerJoinContractor($relationAlias = null) Adds a INNER JOIN clause to the query using the Contractor relation
 *
 * @method GuaranteeQuery leftJoinGuaranteeDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the GuaranteeDocument relation
 * @method GuaranteeQuery rightJoinGuaranteeDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the GuaranteeDocument relation
 * @method GuaranteeQuery innerJoinGuaranteeDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the GuaranteeDocument relation
 *
 * @method Guarantee findOne(PropelPDO $con = null) Return the first Guarantee matching the query
 * @method Guarantee findOneOrCreate(PropelPDO $con = null) Return the first Guarantee matching the query, or a new Guarantee object populated from the query conditions when no match is found
 *
 * @method Guarantee findOneById(int $id) Return the first Guarantee filtered by the id column
 * @method Guarantee findOneByCode(string $code) Return the first Guarantee filtered by the code column
 * @method Guarantee findOneByType(int $type) Return the first Guarantee filtered by the type column
 * @method Guarantee findOneByProjectid(int $projectId) Return the first Guarantee filtered by the projectId column
 * @method Guarantee findOneByContractorid(int $contractorId) Return the first Guarantee filtered by the contractorId column
 * @method Guarantee findOneByIssuer(string $issuer) Return the first Guarantee filtered by the issuer column
 * @method Guarantee findOneByCurrency(int $currency) Return the first Guarantee filtered by the currency column
 * @method Guarantee findOneByAmmount(string $ammount) Return the first Guarantee filtered by the ammount column
 * @method Guarantee findOneByIssuedate(string $issueDate) Return the first Guarantee filtered by the issueDate column
 * @method Guarantee findOneByExpirationtype(int $expirationType) Return the first Guarantee filtered by the expirationType column
 * @method Guarantee findOneByExpirationdate(string $expirationDate) Return the first Guarantee filtered by the expirationDate column
 * @method Guarantee findOneByExpirationterms(string $expirationTerms) Return the first Guarantee filtered by the expirationTerms column
 * @method Guarantee findOneByReturned(boolean $returned) Return the first Guarantee filtered by the returned column
 * @method Guarantee findOneByDeletedAt(string $deleted_at) Return the first Guarantee filtered by the deleted_at column
 *
 * @method array findById(int $id) Return Guarantee objects filtered by the id column
 * @method array findByCode(string $code) Return Guarantee objects filtered by the code column
 * @method array findByType(int $type) Return Guarantee objects filtered by the type column
 * @method array findByProjectid(int $projectId) Return Guarantee objects filtered by the projectId column
 * @method array findByContractorid(int $contractorId) Return Guarantee objects filtered by the contractorId column
 * @method array findByIssuer(string $issuer) Return Guarantee objects filtered by the issuer column
 * @method array findByCurrency(int $currency) Return Guarantee objects filtered by the currency column
 * @method array findByAmmount(string $ammount) Return Guarantee objects filtered by the ammount column
 * @method array findByIssuedate(string $issueDate) Return Guarantee objects filtered by the issueDate column
 * @method array findByExpirationtype(int $expirationType) Return Guarantee objects filtered by the expirationType column
 * @method array findByExpirationdate(string $expirationDate) Return Guarantee objects filtered by the expirationDate column
 * @method array findByExpirationterms(string $expirationTerms) Return Guarantee objects filtered by the expirationTerms column
 * @method array findByReturned(boolean $returned) Return Guarantee objects filtered by the returned column
 * @method array findByDeletedAt(string $deleted_at) Return Guarantee objects filtered by the deleted_at column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseGuaranteeQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseGuaranteeQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Guarantee', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new GuaranteeQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     GuaranteeQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return GuaranteeQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof GuaranteeQuery) {
            return $criteria;
        }
        $query = new GuaranteeQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Guarantee|Guarantee[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = GuaranteePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(GuaranteePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Guarantee A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `CODE`, `TYPE`, `PROJECTID`, `CONTRACTORID`, `ISSUER`, `CURRENCY`, `AMMOUNT`, `ISSUEDATE`, `EXPIRATIONTYPE`, `EXPIRATIONDATE`, `EXPIRATIONTERMS`, `RETURNED`, `DELETED_AT` FROM `panel_guarantee` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Guarantee();
            $obj->hydrate($row);
            GuaranteePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Guarantee|Guarantee[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Guarantee[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(GuaranteePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(GuaranteePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(GuaranteePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the code column
     *
     * Example usage:
     * <code>
     * $query->filterByCode('fooValue');   // WHERE code = 'fooValue'
     * $query->filterByCode('%fooValue%'); // WHERE code LIKE '%fooValue%'
     * </code>
     *
     * @param     string $code The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByCode($code = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($code)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $code)) {
                $code = str_replace('*', '%', $code);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::CODE, $code, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(GuaranteePeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(GuaranteePeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the projectId column
     *
     * Example usage:
     * <code>
     * $query->filterByProjectid(1234); // WHERE projectId = 1234
     * $query->filterByProjectid(array(12, 34)); // WHERE projectId IN (12, 34)
     * $query->filterByProjectid(array('min' => 12)); // WHERE projectId > 12
     * </code>
     *
     * @see       filterByProject()
     *
     * @param     mixed $projectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByProjectid($projectid = null, $comparison = null)
    {
        if (is_array($projectid)) {
            $useMinMax = false;
            if (isset($projectid['min'])) {
                $this->addUsingAlias(GuaranteePeer::PROJECTID, $projectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($projectid['max'])) {
                $this->addUsingAlias(GuaranteePeer::PROJECTID, $projectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::PROJECTID, $projectid, $comparison);
    }

    /**
     * Filter the query on the contractorId column
     *
     * Example usage:
     * <code>
     * $query->filterByContractorid(1234); // WHERE contractorId = 1234
     * $query->filterByContractorid(array(12, 34)); // WHERE contractorId IN (12, 34)
     * $query->filterByContractorid(array('min' => 12)); // WHERE contractorId > 12
     * </code>
     *
     * @see       filterByContractor()
     *
     * @param     mixed $contractorid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByContractorid($contractorid = null, $comparison = null)
    {
        if (is_array($contractorid)) {
            $useMinMax = false;
            if (isset($contractorid['min'])) {
                $this->addUsingAlias(GuaranteePeer::CONTRACTORID, $contractorid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($contractorid['max'])) {
                $this->addUsingAlias(GuaranteePeer::CONTRACTORID, $contractorid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::CONTRACTORID, $contractorid, $comparison);
    }

    /**
     * Filter the query on the issuer column
     *
     * Example usage:
     * <code>
     * $query->filterByIssuer('fooValue');   // WHERE issuer = 'fooValue'
     * $query->filterByIssuer('%fooValue%'); // WHERE issuer LIKE '%fooValue%'
     * </code>
     *
     * @param     string $issuer The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByIssuer($issuer = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($issuer)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $issuer)) {
                $issuer = str_replace('*', '%', $issuer);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::ISSUER, $issuer, $comparison);
    }

    /**
     * Filter the query on the currency column
     *
     * Example usage:
     * <code>
     * $query->filterByCurrency(1234); // WHERE currency = 1234
     * $query->filterByCurrency(array(12, 34)); // WHERE currency IN (12, 34)
     * $query->filterByCurrency(array('min' => 12)); // WHERE currency > 12
     * </code>
     *
     * @param     mixed $currency The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByCurrency($currency = null, $comparison = null)
    {
        if (is_array($currency)) {
            $useMinMax = false;
            if (isset($currency['min'])) {
                $this->addUsingAlias(GuaranteePeer::CURRENCY, $currency['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($currency['max'])) {
                $this->addUsingAlias(GuaranteePeer::CURRENCY, $currency['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::CURRENCY, $currency, $comparison);
    }

    /**
     * Filter the query on the ammount column
     *
     * Example usage:
     * <code>
     * $query->filterByAmmount(1234); // WHERE ammount = 1234
     * $query->filterByAmmount(array(12, 34)); // WHERE ammount IN (12, 34)
     * $query->filterByAmmount(array('min' => 12)); // WHERE ammount > 12
     * </code>
     *
     * @param     mixed $ammount The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByAmmount($ammount = null, $comparison = null)
    {
        if (is_array($ammount)) {
            $useMinMax = false;
            if (isset($ammount['min'])) {
                $this->addUsingAlias(GuaranteePeer::AMMOUNT, $ammount['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($ammount['max'])) {
                $this->addUsingAlias(GuaranteePeer::AMMOUNT, $ammount['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::AMMOUNT, $ammount, $comparison);
    }

    /**
     * Filter the query on the issueDate column
     *
     * Example usage:
     * <code>
     * $query->filterByIssuedate('2011-03-14'); // WHERE issueDate = '2011-03-14'
     * $query->filterByIssuedate('now'); // WHERE issueDate = '2011-03-14'
     * $query->filterByIssuedate(array('max' => 'yesterday')); // WHERE issueDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $issuedate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByIssuedate($issuedate = null, $comparison = null)
    {
        if (is_array($issuedate)) {
            $useMinMax = false;
            if (isset($issuedate['min'])) {
                $this->addUsingAlias(GuaranteePeer::ISSUEDATE, $issuedate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($issuedate['max'])) {
                $this->addUsingAlias(GuaranteePeer::ISSUEDATE, $issuedate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::ISSUEDATE, $issuedate, $comparison);
    }

    /**
     * Filter the query on the expirationType column
     *
     * Example usage:
     * <code>
     * $query->filterByExpirationtype(1234); // WHERE expirationType = 1234
     * $query->filterByExpirationtype(array(12, 34)); // WHERE expirationType IN (12, 34)
     * $query->filterByExpirationtype(array('min' => 12)); // WHERE expirationType > 12
     * </code>
     *
     * @param     mixed $expirationtype The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByExpirationtype($expirationtype = null, $comparison = null)
    {
        if (is_array($expirationtype)) {
            $useMinMax = false;
            if (isset($expirationtype['min'])) {
                $this->addUsingAlias(GuaranteePeer::EXPIRATIONTYPE, $expirationtype['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($expirationtype['max'])) {
                $this->addUsingAlias(GuaranteePeer::EXPIRATIONTYPE, $expirationtype['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::EXPIRATIONTYPE, $expirationtype, $comparison);
    }

    /**
     * Filter the query on the expirationDate column
     *
     * Example usage:
     * <code>
     * $query->filterByExpirationdate('2011-03-14'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate('now'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate(array('max' => 'yesterday')); // WHERE expirationDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $expirationdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByExpirationdate($expirationdate = null, $comparison = null)
    {
        if (is_array($expirationdate)) {
            $useMinMax = false;
            if (isset($expirationdate['min'])) {
                $this->addUsingAlias(GuaranteePeer::EXPIRATIONDATE, $expirationdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($expirationdate['max'])) {
                $this->addUsingAlias(GuaranteePeer::EXPIRATIONDATE, $expirationdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::EXPIRATIONDATE, $expirationdate, $comparison);
    }

    /**
     * Filter the query on the expirationTerms column
     *
     * Example usage:
     * <code>
     * $query->filterByExpirationterms('fooValue');   // WHERE expirationTerms = 'fooValue'
     * $query->filterByExpirationterms('%fooValue%'); // WHERE expirationTerms LIKE '%fooValue%'
     * </code>
     *
     * @param     string $expirationterms The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByExpirationterms($expirationterms = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($expirationterms)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $expirationterms)) {
                $expirationterms = str_replace('*', '%', $expirationterms);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::EXPIRATIONTERMS, $expirationterms, $comparison);
    }

    /**
     * Filter the query on the returned column
     *
     * Example usage:
     * <code>
     * $query->filterByReturned(true); // WHERE returned = true
     * $query->filterByReturned('yes'); // WHERE returned = true
     * </code>
     *
     * @param     boolean|string $returned The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByReturned($returned = null, $comparison = null)
    {
        if (is_string($returned)) {
            $returned = in_array(strtolower($returned), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(GuaranteePeer::RETURNED, $returned, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(GuaranteePeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(GuaranteePeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GuaranteePeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   GuaranteeQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(GuaranteePeer::PROJECTID, $project->getId(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(GuaranteePeer::PROJECTID, $project->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related Contractor object
     *
     * @param   Contractor|PropelObjectCollection $contractor The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   GuaranteeQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByContractor($contractor, $comparison = null)
    {
        if ($contractor instanceof Contractor) {
            return $this
                ->addUsingAlias(GuaranteePeer::CONTRACTORID, $contractor->getId(), $comparison);
        } elseif ($contractor instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(GuaranteePeer::CONTRACTORID, $contractor->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByContractor() only accepts arguments of type Contractor or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Contractor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function joinContractor($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Contractor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Contractor');
        }

        return $this;
    }

    /**
     * Use the Contractor relation Contractor object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ContractorQuery A secondary query class using the current class as primary query
     */
    public function useContractorQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinContractor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Contractor', 'ContractorQuery');
    }

    /**
     * Filter the query by a related GuaranteeDocument object
     *
     * @param   GuaranteeDocument|PropelObjectCollection $guaranteeDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   GuaranteeQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByGuaranteeDocument($guaranteeDocument, $comparison = null)
    {
        if ($guaranteeDocument instanceof GuaranteeDocument) {
            return $this
                ->addUsingAlias(GuaranteePeer::ID, $guaranteeDocument->getGuaranteeid(), $comparison);
        } elseif ($guaranteeDocument instanceof PropelObjectCollection) {
            return $this
                ->useGuaranteeDocumentQuery()
                ->filterByPrimaryKeys($guaranteeDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByGuaranteeDocument() only accepts arguments of type GuaranteeDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the GuaranteeDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function joinGuaranteeDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('GuaranteeDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'GuaranteeDocument');
        }

        return $this;
    }

    /**
     * Use the GuaranteeDocument relation GuaranteeDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   GuaranteeDocumentQuery A secondary query class using the current class as primary query
     */
    public function useGuaranteeDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinGuaranteeDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'GuaranteeDocument', 'GuaranteeDocumentQuery');
    }

    /**
     * Filter the query by a related Document object
     * using the panel_guaranteeDocument table as cross reference
     *
     * @param   Document $document the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   GuaranteeQuery The current query, for fluid interface
     */
    public function filterByDocument($document, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useGuaranteeDocumentQuery()
            ->filterByDocument($document, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Guarantee $guarantee Object to remove from the list of results
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function prune($guarantee = null)
    {
        if ($guarantee) {
            $this->addUsingAlias(GuaranteePeer::ID, $guarantee->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(GuaranteePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            GuaranteePeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (GuaranteeQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see GuaranteeQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return GuaranteeQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return GuaranteePeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return GuaranteePeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
