<?php


/**
 * Base class that represents a query for the 'panel_administrativeAct' table.
 *
 * Base de Actos Administrativos
 *
 * @method AdministrativeActQuery orderById($order = Criteria::ASC) Order by the id column
 * @method AdministrativeActQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method AdministrativeActQuery orderByObject($order = Criteria::ASC) Order by the object column
 * @method AdministrativeActQuery orderByActdate($order = Criteria::ASC) Order by the actDate column
 * @method AdministrativeActQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method AdministrativeActQuery orderByProjectid($order = Criteria::ASC) Order by the projectId column
 * @method AdministrativeActQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method AdministrativeActQuery groupById() Group by the id column
 * @method AdministrativeActQuery groupByType() Group by the type column
 * @method AdministrativeActQuery groupByObject() Group by the object column
 * @method AdministrativeActQuery groupByActdate() Group by the actDate column
 * @method AdministrativeActQuery groupByDescription() Group by the description column
 * @method AdministrativeActQuery groupByProjectid() Group by the projectId column
 * @method AdministrativeActQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method AdministrativeActQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method AdministrativeActQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method AdministrativeActQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method AdministrativeActQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method AdministrativeActQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method AdministrativeActQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method AdministrativeActQuery leftJoinAdminActParticipant($relationAlias = null) Adds a LEFT JOIN clause to the query using the AdminActParticipant relation
 * @method AdministrativeActQuery rightJoinAdminActParticipant($relationAlias = null) Adds a RIGHT JOIN clause to the query using the AdminActParticipant relation
 * @method AdministrativeActQuery innerJoinAdminActParticipant($relationAlias = null) Adds a INNER JOIN clause to the query using the AdminActParticipant relation
 *
 * @method AdministrativeActQuery leftJoinAdministrativeActDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the AdministrativeActDocument relation
 * @method AdministrativeActQuery rightJoinAdministrativeActDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the AdministrativeActDocument relation
 * @method AdministrativeActQuery innerJoinAdministrativeActDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the AdministrativeActDocument relation
 *
 * @method AdministrativeAct findOne(PropelPDO $con = null) Return the first AdministrativeAct matching the query
 * @method AdministrativeAct findOneOrCreate(PropelPDO $con = null) Return the first AdministrativeAct matching the query, or a new AdministrativeAct object populated from the query conditions when no match is found
 *
 * @method AdministrativeAct findOneById(int $id) Return the first AdministrativeAct filtered by the id column
 * @method AdministrativeAct findOneByType(int $type) Return the first AdministrativeAct filtered by the type column
 * @method AdministrativeAct findOneByObject(string $object) Return the first AdministrativeAct filtered by the object column
 * @method AdministrativeAct findOneByActdate(string $actDate) Return the first AdministrativeAct filtered by the actDate column
 * @method AdministrativeAct findOneByDescription(string $description) Return the first AdministrativeAct filtered by the description column
 * @method AdministrativeAct findOneByProjectid(int $projectId) Return the first AdministrativeAct filtered by the projectId column
 * @method AdministrativeAct findOneByDeletedAt(string $deleted_at) Return the first AdministrativeAct filtered by the deleted_at column
 *
 * @method array findById(int $id) Return AdministrativeAct objects filtered by the id column
 * @method array findByType(int $type) Return AdministrativeAct objects filtered by the type column
 * @method array findByObject(string $object) Return AdministrativeAct objects filtered by the object column
 * @method array findByActdate(string $actDate) Return AdministrativeAct objects filtered by the actDate column
 * @method array findByDescription(string $description) Return AdministrativeAct objects filtered by the description column
 * @method array findByProjectid(int $projectId) Return AdministrativeAct objects filtered by the projectId column
 * @method array findByDeletedAt(string $deleted_at) Return AdministrativeAct objects filtered by the deleted_at column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseAdministrativeActQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseAdministrativeActQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'AdministrativeAct', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new AdministrativeActQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     AdministrativeActQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return AdministrativeActQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof AdministrativeActQuery) {
            return $criteria;
        }
        $query = new AdministrativeActQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   AdministrativeAct|AdministrativeAct[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = AdministrativeActPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(AdministrativeActPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   AdministrativeAct A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `TYPE`, `OBJECT`, `ACTDATE`, `DESCRIPTION`, `PROJECTID`, `DELETED_AT` FROM `panel_administrativeAct` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new AdministrativeAct();
            $obj->hydrate($row);
            AdministrativeActPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return AdministrativeAct|AdministrativeAct[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|AdministrativeAct[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(AdministrativeActPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(AdministrativeActPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(AdministrativeActPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(AdministrativeActPeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(AdministrativeActPeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(AdministrativeActPeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the object column
     *
     * Example usage:
     * <code>
     * $query->filterByObject('fooValue');   // WHERE object = 'fooValue'
     * $query->filterByObject('%fooValue%'); // WHERE object LIKE '%fooValue%'
     * </code>
     *
     * @param     string $object The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function filterByObject($object = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($object)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $object)) {
                $object = str_replace('*', '%', $object);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(AdministrativeActPeer::OBJECT, $object, $comparison);
    }

    /**
     * Filter the query on the actDate column
     *
     * Example usage:
     * <code>
     * $query->filterByActdate('2011-03-14'); // WHERE actDate = '2011-03-14'
     * $query->filterByActdate('now'); // WHERE actDate = '2011-03-14'
     * $query->filterByActdate(array('max' => 'yesterday')); // WHERE actDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $actdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function filterByActdate($actdate = null, $comparison = null)
    {
        if (is_array($actdate)) {
            $useMinMax = false;
            if (isset($actdate['min'])) {
                $this->addUsingAlias(AdministrativeActPeer::ACTDATE, $actdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($actdate['max'])) {
                $this->addUsingAlias(AdministrativeActPeer::ACTDATE, $actdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(AdministrativeActPeer::ACTDATE, $actdate, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(AdministrativeActPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the projectId column
     *
     * Example usage:
     * <code>
     * $query->filterByProjectid(1234); // WHERE projectId = 1234
     * $query->filterByProjectid(array(12, 34)); // WHERE projectId IN (12, 34)
     * $query->filterByProjectid(array('min' => 12)); // WHERE projectId > 12
     * </code>
     *
     * @see       filterByProject()
     *
     * @param     mixed $projectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function filterByProjectid($projectid = null, $comparison = null)
    {
        if (is_array($projectid)) {
            $useMinMax = false;
            if (isset($projectid['min'])) {
                $this->addUsingAlias(AdministrativeActPeer::PROJECTID, $projectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($projectid['max'])) {
                $this->addUsingAlias(AdministrativeActPeer::PROJECTID, $projectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(AdministrativeActPeer::PROJECTID, $projectid, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(AdministrativeActPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(AdministrativeActPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(AdministrativeActPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   AdministrativeActQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(AdministrativeActPeer::PROJECTID, $project->getId(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(AdministrativeActPeer::PROJECTID, $project->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related AdminActParticipant object
     *
     * @param   AdminActParticipant|PropelObjectCollection $adminActParticipant  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   AdministrativeActQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByAdminActParticipant($adminActParticipant, $comparison = null)
    {
        if ($adminActParticipant instanceof AdminActParticipant) {
            return $this
                ->addUsingAlias(AdministrativeActPeer::ID, $adminActParticipant->getAdminactid(), $comparison);
        } elseif ($adminActParticipant instanceof PropelObjectCollection) {
            return $this
                ->useAdminActParticipantQuery()
                ->filterByPrimaryKeys($adminActParticipant->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByAdminActParticipant() only accepts arguments of type AdminActParticipant or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the AdminActParticipant relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function joinAdminActParticipant($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('AdminActParticipant');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'AdminActParticipant');
        }

        return $this;
    }

    /**
     * Use the AdminActParticipant relation AdminActParticipant object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   AdminActParticipantQuery A secondary query class using the current class as primary query
     */
    public function useAdminActParticipantQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinAdminActParticipant($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'AdminActParticipant', 'AdminActParticipantQuery');
    }

    /**
     * Filter the query by a related AdministrativeActDocument object
     *
     * @param   AdministrativeActDocument|PropelObjectCollection $administrativeActDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   AdministrativeActQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByAdministrativeActDocument($administrativeActDocument, $comparison = null)
    {
        if ($administrativeActDocument instanceof AdministrativeActDocument) {
            return $this
                ->addUsingAlias(AdministrativeActPeer::ID, $administrativeActDocument->getAdministrativeactid(), $comparison);
        } elseif ($administrativeActDocument instanceof PropelObjectCollection) {
            return $this
                ->useAdministrativeActDocumentQuery()
                ->filterByPrimaryKeys($administrativeActDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByAdministrativeActDocument() only accepts arguments of type AdministrativeActDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the AdministrativeActDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function joinAdministrativeActDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('AdministrativeActDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'AdministrativeActDocument');
        }

        return $this;
    }

    /**
     * Use the AdministrativeActDocument relation AdministrativeActDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   AdministrativeActDocumentQuery A secondary query class using the current class as primary query
     */
    public function useAdministrativeActDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinAdministrativeActDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'AdministrativeActDocument', 'AdministrativeActDocumentQuery');
    }

    /**
     * Filter the query by a related Document object
     * using the panel_administrativeActDocument table as cross reference
     *
     * @param   Document $document the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   AdministrativeActQuery The current query, for fluid interface
     */
    public function filterByDocument($document, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useAdministrativeActDocumentQuery()
            ->filterByDocument($document, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   AdministrativeAct $administrativeAct Object to remove from the list of results
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function prune($administrativeAct = null)
    {
        if ($administrativeAct) {
            $this->addUsingAlias(AdministrativeActPeer::ID, $administrativeAct->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (AdministrativeActQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(AdministrativeActPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            AdministrativeActPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (AdministrativeActQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see AdministrativeActQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return AdministrativeActQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return AdministrativeActPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return AdministrativeActPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
