<?php



/**
 * This class defines the structure of the 'panel_contractor' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.panel.classes.map
 */
class ContractorTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'panel.classes.map.ContractorTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('panel_contractor');
        $this->setPhpName('Contractor');
        $this->setClassname('Contractor');
        $this->setPackage('panel.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'CHAR', false, 255, null);
        $this->addColumn('CUIT', 'Cuit', 'CHAR', false, 11, null);
        $this->addColumn('ADDRESS', 'Address', 'CHAR', false, 255, null);
        $this->addColumn('PHONE', 'Phone', 'CHAR', false, 120, null);
        $this->addColumn('CONTACT', 'Contact', 'CHAR', false, 120, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Guarantee', 'Guarantee', RelationMap::ONE_TO_MANY, array('id' => 'contractorId', ), 'SET NULL', null, 'Guarantees');
        $this->addRelation('ContractorCategoryRelation', 'ContractorCategoryRelation', RelationMap::ONE_TO_MANY, array('id' => 'contractorId', ), 'CASCADE', null, 'ContractorCategoryRelations');
        $this->addRelation('ProjectContractor', 'ProjectContractor', RelationMap::ONE_TO_MANY, array('id' => 'contractor_id', ), 'CASCADE', null, 'ProjectContractors');
        $this->addRelation('ContractorCategory', 'ContractorCategory', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'ContractorCategorys');
        $this->addRelation('Project', 'Project', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Projects');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
        );
    } // getBehaviors()

} // ContractorTableMap
