<?php

require_once("EmailManagement.php");

class PanelNotificationsResendAction extends BaseAction {

	function PanelNotificationsResendAction() {
		;
	}

	function execute($mapping, $form, &$request, &$response) {

		BaseAction::execute($mapping, $form, $request, $response);

		$this->template->template = "TemplatePlain.tpl";

		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL) {
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";
		}

		$module = "Panel";
		$system = Common::getModuleConfiguration("system");
		
		$notification = NotificationPeer::get($_POST['id']);
				
		// se prepara el mail
		$mailTo = $notification->getMailTo();
			
		$typesTranslated = NotificationPeer::getTypesTranslated();
		$typeTranslated = $typesTranslated[$notification->getType()];

		$subject = "Tablero de Gestión - Reenvío de Alerta";

		$mailFrom = $system["parameters"]["fromEmail"];
		
		$body = $notification->getMailBody();
			
		$manager = new EmailManagement();
//		$manager->setTestMode();                        // hace que los mails se envíen al debugMail.

		$message = $manager->createHTMLMessage($subject,$body);
		
		$result = $manager->sendMessage($mailTo,$mailFrom,$message); // se envía.

		if ($result) {
			$notificationResend = new Notification();
			$notificationResendParams = array(
				'objectType' => $notification->getObjectType(),
				'objectId' => $notification->getObjectId(),
				'mailAddress' => $notification->getMailAddress(),
				'mailBody' => $body,
				'type' => $notification->getType(),
				'result' => $result,
				'deliveredOn' => new DateTime()
			);
			$notificationResend->fromArray($notificationResendParams,BasePeer::TYPE_FIELDNAME);
			$notificationResend->save();
		}
		return $mapping->findForwardConfig('success');
	}
}
