<?php

set_time_limit(720);

require_once 'AlertManager.php';

/**
 * Esta accion esta pensada para ser corrida con cron.
 * Para ello se puede usar las siguientes lineas:
 *
 * cd /ruta/del/main/; php Main.php do=panelSendAlert 1>> alert_log 2>> alert_log;
 *
 * Con eso redireccionamos la salida estandar y la de errores al archivo alert_log.
 *
 * Recordar comentar la linea $manager->setTestMode(); cuando se quiera activar efectivamente.
 */

class PanelAlertDigestsDoSendAction extends BaseAction {

	protected $debugMode = true;

	function exec() {

		$this->debugMode = $_REQUEST['debug'];

		if ( (!$this->debugMode && empty($_POST['do'])) || !Common::getLoggedUser()->isSupervisor()) {
			die('inaccesible');
		}

		if (parent::exec() === false) {
			return false;
		}

		$this->template->template = "TemplatePlain.tpl";

		$alertManager = new AlertManager();

		$alertDigests = AlertDigestQuery::create()
			->useDefaultOrder()
			->find();

		$debugMailsData = [];

		foreach ($alertDigests as $alertDigest) {

			$position = $alertDigest->getPosition();
			$recipients = $alertDigest->getEmailsList();
			if (!$position || empty($recipients))
				continue;

			$digestMail = $alertManager->createAlertDigestMail($position);
			$digestMail->setMailTo($recipients);

			if ($this->debugMode) {
				$debugMailsData[] = [
					'mailTo' => $digestMail->getMailTo(),
					'alertBody' => $digestMail->getBody(),
					'position' => $position
				];
			} else {
				$result = $digestMail->send();
			}
		}

		if ($this->debugMode) {
			$this->smarty->assign('debugMailsData', $debugMailsData);
			$this->smarty->display('PanelAlertDigestsDoSend.tpl');
		}

		die;
	}
}
