<?php



/**
 * This class defines the structure of the 'objectives_strategic' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.objectives.classes.map
 */
class StrategicObjectiveTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'objectives.classes.map.StrategicObjectiveTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('objectives_strategic');
        $this->setPhpName('StrategicObjective');
        $this->setClassname('StrategicObjective');
        $this->setPackage('objectives.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addForeignKey('POLICYGUIDELINEID', 'Policyguidelineid', 'INTEGER', 'objectives_policyGuideline', 'ID', false, null, null);
        $this->addColumn('NAME', 'Name', 'LONGVARCHAR', true, 255, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('DESCRIPTION', 'Description', 'LONGVARCHAR', false, null, null);
        $this->addForeignKey('USERID', 'Userid', 'INTEGER', 'users_user', 'ID', false, null, null);
        $this->addColumn('AFFILIATEID', 'Affiliateid', 'INTEGER', true, null, 0);
        $this->addColumn('USERBYAFFILIATESID', 'Userbyaffiliatesid', 'INTEGER', false, null, null);
        $this->addColumn('UPDATED', 'Updated', 'TIMESTAMP', false, null, null);
        $this->addColumn('CHANGES', 'Changes', 'INTEGER', false, null, null);
        $this->addColumn('OLDID', 'Oldid', 'INTEGER', false, null, null);
        $this->addColumn('STARTINGYEAR', 'Startingyear', 'INTEGER', false, null, null);
        $this->addColumn('ENDINGYEAR', 'Endingyear', 'INTEGER', false, null, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('PolicyGuideline', 'PolicyGuideline', RelationMap::MANY_TO_ONE, array('policyGuidelineId' => 'id', ), null, null);
        $this->addRelation('User', 'User', RelationMap::MANY_TO_ONE, array('userId' => 'id', ), null, null);
        $this->addRelation('Objective', 'Objective', RelationMap::ONE_TO_MANY, array('id' => 'strategicObjectiveId', ), null, null, 'Objectives');
        $this->addRelation('StrategicObjectiveLog', 'StrategicObjectiveLog', RelationMap::ONE_TO_MANY, array('id' => 'strategicId', ), null, null, 'StrategicObjectiveLogs');
        $this->addRelation('ObjectiveLog', 'ObjectiveLog', RelationMap::ONE_TO_MANY, array('id' => 'strategicObjectiveId', ), null, null, 'ObjectiveLogs');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
        );
    } // getBehaviors()

} // StrategicObjectiveTableMap
