<?php

use Egytca\Planning\YearFilter as PlanningYearFilter;

/**
 * Skeleton subclass for performing query and update operations on the 'objectives_objective' table.
 *
 * Objective
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.objectives.classes
 */
class ObjectiveQuery extends BaseObjectiveQuery {

	use PlanningYearFilter;
	
	private $useLoggedUserGroupAutoFilter = false;
	
	public function __construct($dbName = 'application', $modelName = 'Objective', $modelAlias = null) {

		parent::__construct($dbName, $modelName, $modelAlias);

		//$loggedUser = Common::getLoggedUser();
		//if ($loggedUser && !$loggedUser->isSupervisor() && ConfigModule::get('objectives', 'useFilterByUserGroup')) {
		//	$this->useLoggedUserGroupAutoFilter = true;
		//}

		$this->filterByPlanningYears();
	}

	function preSelect() {
		if ($this->useLoggedUserGroupAutoFilter) {
			$this->filterByLoggedUserGroup();
		}
	}

	function setLoggedUserGroupAutoFilter($value) {
		$this->useLoggedUserGroupAutoFilter = $value;
		return $this;
	}
	
	public function filterByPolicyGuidelineId($policyGuidelineId = null, $comparison = null) {
		$this->join('StrategicObjective')
			 ->useQuery('StrategicObjective')
    		 	->filterByPolicyGuidelineId($policyGuidelineId, $comparison)
			 ->endUse();
		return $this;
	}

	function filterByLoggedUserGroup() {
		return $this->usePositionQuery()
				->filterByLoggedUserGroupWithDesc()
			->endUse();
	}

	/**
	 * Devuelve la criteria para filtrar por fecha de finalización planificada a fin de armar un reporte de alertas de actividades.
	 */
	public function filterByPendingEnd($date, $comparison = null) {
		return $this->filterByAchieved(false)
			->filterByExpirationDate($date, $comparison);
	}

	function filterByPlannedStart($date, $comparison = null) {
		return $this->filterByDate($date, $comparison);
	}

	function filterByPlannedEnd($date, $comparison = null) {
		return $this->filterByExpirationDate($date, $comparison);
	}
} // ObjectiveQuery
