<?php


/**
 * Base class that represents a query for the 'medias_audienceRelation' table.
 *
 * Tabla de relaciones de medios y sus audiencias
 *
 * @method MediaAudienceRelationQuery orderByMediaid($order = Criteria::ASC) Order by the mediaId column
 * @method MediaAudienceRelationQuery orderByMediaaudienceid($order = Criteria::ASC) Order by the mediaAudienceId column
 *
 * @method MediaAudienceRelationQuery groupByMediaid() Group by the mediaId column
 * @method MediaAudienceRelationQuery groupByMediaaudienceid() Group by the mediaAudienceId column
 *
 * @method MediaAudienceRelationQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method MediaAudienceRelationQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method MediaAudienceRelationQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method MediaAudienceRelationQuery leftJoinMedia($relationAlias = null) Adds a LEFT JOIN clause to the query using the Media relation
 * @method MediaAudienceRelationQuery rightJoinMedia($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Media relation
 * @method MediaAudienceRelationQuery innerJoinMedia($relationAlias = null) Adds a INNER JOIN clause to the query using the Media relation
 *
 * @method MediaAudienceRelationQuery leftJoinMediaAudience($relationAlias = null) Adds a LEFT JOIN clause to the query using the MediaAudience relation
 * @method MediaAudienceRelationQuery rightJoinMediaAudience($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MediaAudience relation
 * @method MediaAudienceRelationQuery innerJoinMediaAudience($relationAlias = null) Adds a INNER JOIN clause to the query using the MediaAudience relation
 *
 * @method MediaAudienceRelation findOne(PropelPDO $con = null) Return the first MediaAudienceRelation matching the query
 * @method MediaAudienceRelation findOneOrCreate(PropelPDO $con = null) Return the first MediaAudienceRelation matching the query, or a new MediaAudienceRelation object populated from the query conditions when no match is found
 *
 * @method MediaAudienceRelation findOneByMediaid(int $mediaId) Return the first MediaAudienceRelation filtered by the mediaId column
 * @method MediaAudienceRelation findOneByMediaaudienceid(int $mediaAudienceId) Return the first MediaAudienceRelation filtered by the mediaAudienceId column
 *
 * @method array findByMediaid(int $mediaId) Return MediaAudienceRelation objects filtered by the mediaId column
 * @method array findByMediaaudienceid(int $mediaAudienceId) Return MediaAudienceRelation objects filtered by the mediaAudienceId column
 *
 * @package    propel.generator.medias.classes.om
 */
abstract class BaseMediaAudienceRelationQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseMediaAudienceRelationQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'MediaAudienceRelation', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new MediaAudienceRelationQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     MediaAudienceRelationQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return MediaAudienceRelationQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof MediaAudienceRelationQuery) {
            return $criteria;
        }
        $query = new MediaAudienceRelationQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$mediaId, $mediaAudienceId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   MediaAudienceRelation|MediaAudienceRelation[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = MediaAudienceRelationPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(MediaAudienceRelationPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   MediaAudienceRelation A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `MEDIAID`, `MEDIAAUDIENCEID` FROM `medias_audienceRelation` WHERE `MEDIAID` = :p0 AND `MEDIAAUDIENCEID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new MediaAudienceRelation();
            $obj->hydrate($row);
            MediaAudienceRelationPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return MediaAudienceRelation|MediaAudienceRelation[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|MediaAudienceRelation[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return MediaAudienceRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(MediaAudienceRelationPeer::MEDIAID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(MediaAudienceRelationPeer::MEDIAAUDIENCEID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return MediaAudienceRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(MediaAudienceRelationPeer::MEDIAID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(MediaAudienceRelationPeer::MEDIAAUDIENCEID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the mediaId column
     *
     * Example usage:
     * <code>
     * $query->filterByMediaid(1234); // WHERE mediaId = 1234
     * $query->filterByMediaid(array(12, 34)); // WHERE mediaId IN (12, 34)
     * $query->filterByMediaid(array('min' => 12)); // WHERE mediaId > 12
     * </code>
     *
     * @see       filterByMedia()
     *
     * @param     mixed $mediaid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaAudienceRelationQuery The current query, for fluid interface
     */
    public function filterByMediaid($mediaid = null, $comparison = null)
    {
        if (is_array($mediaid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(MediaAudienceRelationPeer::MEDIAID, $mediaid, $comparison);
    }

    /**
     * Filter the query on the mediaAudienceId column
     *
     * Example usage:
     * <code>
     * $query->filterByMediaaudienceid(1234); // WHERE mediaAudienceId = 1234
     * $query->filterByMediaaudienceid(array(12, 34)); // WHERE mediaAudienceId IN (12, 34)
     * $query->filterByMediaaudienceid(array('min' => 12)); // WHERE mediaAudienceId > 12
     * </code>
     *
     * @see       filterByMediaAudience()
     *
     * @param     mixed $mediaaudienceid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MediaAudienceRelationQuery The current query, for fluid interface
     */
    public function filterByMediaaudienceid($mediaaudienceid = null, $comparison = null)
    {
        if (is_array($mediaaudienceid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(MediaAudienceRelationPeer::MEDIAAUDIENCEID, $mediaaudienceid, $comparison);
    }

    /**
     * Filter the query by a related Media object
     *
     * @param   Media|PropelObjectCollection $media The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaAudienceRelationQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMedia($media, $comparison = null)
    {
        if ($media instanceof Media) {
            return $this
                ->addUsingAlias(MediaAudienceRelationPeer::MEDIAID, $media->getId(), $comparison);
        } elseif ($media instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MediaAudienceRelationPeer::MEDIAID, $media->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMedia() only accepts arguments of type Media or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Media relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MediaAudienceRelationQuery The current query, for fluid interface
     */
    public function joinMedia($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Media');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Media');
        }

        return $this;
    }

    /**
     * Use the Media relation Media object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MediaQuery A secondary query class using the current class as primary query
     */
    public function useMediaQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMedia($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Media', 'MediaQuery');
    }

    /**
     * Filter the query by a related MediaAudience object
     *
     * @param   MediaAudience|PropelObjectCollection $mediaAudience The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MediaAudienceRelationQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMediaAudience($mediaAudience, $comparison = null)
    {
        if ($mediaAudience instanceof MediaAudience) {
            return $this
                ->addUsingAlias(MediaAudienceRelationPeer::MEDIAAUDIENCEID, $mediaAudience->getId(), $comparison);
        } elseif ($mediaAudience instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MediaAudienceRelationPeer::MEDIAAUDIENCEID, $mediaAudience->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMediaAudience() only accepts arguments of type MediaAudience or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MediaAudience relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MediaAudienceRelationQuery The current query, for fluid interface
     */
    public function joinMediaAudience($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MediaAudience');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MediaAudience');
        }

        return $this;
    }

    /**
     * Use the MediaAudience relation MediaAudience object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MediaAudienceQuery A secondary query class using the current class as primary query
     */
    public function useMediaAudienceQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMediaAudience($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MediaAudience', 'MediaAudienceQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   MediaAudienceRelation $mediaAudienceRelation Object to remove from the list of results
     *
     * @return MediaAudienceRelationQuery The current query, for fluid interface
     */
    public function prune($mediaAudienceRelation = null)
    {
        if ($mediaAudienceRelation) {
            $this->addCond('pruneCond0', $this->getAliasedColName(MediaAudienceRelationPeer::MEDIAID), $mediaAudienceRelation->getMediaid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(MediaAudienceRelationPeer::MEDIAAUDIENCEID), $mediaAudienceRelation->getMediaaudienceid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
