<?php



/**
 * This class defines the structure of the 'medias_media' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.medias.classes.map
 */
class MediaTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'medias.classes.map.MediaTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('medias_media');
        $this->setPhpName('Media');
        $this->setClassname('Media');
        $this->setPackage('medias.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'VARCHAR', true, 200, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('ADDRESS', 'Address', 'VARCHAR', true, 200, null);
        $this->addColumn('PHONE', 'Phone', 'VARCHAR', true, 200, null);
        $this->addColumn('URL', 'Url', 'VARCHAR', true, 200, null);
        $this->addColumn('MEDIAKITURL', 'Mediakiturl', 'VARCHAR', true, 200, null);
        $this->addColumn('FAX', 'Fax', 'VARCHAR', true, 200, null);
        $this->addColumn('EMAIL', 'Email', 'VARCHAR', true, 200, null);
        $this->addColumn('RECEPTIONIST', 'Receptionist', 'VARCHAR', true, 200, null);
        $this->addColumn('DESCRIPTION', 'Description', 'LONGVARCHAR', false, null, null);
        $this->addForeignKey('TYPEID', 'Typeid', 'INTEGER', 'medias_type', 'ID', false, null, null);
        $this->addForeignKey('GROUPID', 'Groupid', 'INTEGER', 'medias_media', 'ID', false, null, null);
        $this->addColumn('IMPORTANCE', 'Importance', 'TINYINT', false, null, null);
        $this->addColumn('BIAS', 'Bias', 'TINYINT', false, null, null);
        $this->addForeignKey('ALIASOF', 'Aliasof', 'INTEGER', 'medias_media', 'ID', false, null, null);
        $this->addColumn('CREATED_AT', 'CreatedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('UPDATED_AT', 'UpdatedAt', 'TIMESTAMP', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('MediaType', 'MediaType', RelationMap::MANY_TO_ONE, array('typeId' => 'id', ), 'CASCADE', null);
        $this->addRelation('MediaRelatedByGroupid', 'Media', RelationMap::MANY_TO_ONE, array('groupId' => 'id', ), 'CASCADE', null);
        $this->addRelation('MediaRelatedByAliasof', 'Media', RelationMap::MANY_TO_ONE, array('aliasOf' => 'id', ), 'CASCADE', null);
        $this->addRelation('Headline', 'Headline', RelationMap::ONE_TO_MANY, array('id' => 'mediaId', ), 'CASCADE', null, 'Headlines');
        $this->addRelation('MediaRelatedById0', 'Media', RelationMap::ONE_TO_MANY, array('id' => 'groupId', ), 'CASCADE', null, 'MediasRelatedById0');
        $this->addRelation('MediaRelatedById1', 'Media', RelationMap::ONE_TO_MANY, array('id' => 'aliasOf', ), 'CASCADE', null, 'MediasRelatedById1');
        $this->addRelation('MediaMarketRelation', 'MediaMarketRelation', RelationMap::ONE_TO_MANY, array('id' => 'mediaId', ), 'CASCADE', null, 'MediaMarketRelations');
        $this->addRelation('MediaAudienceRelation', 'MediaAudienceRelation', RelationMap::ONE_TO_MANY, array('id' => 'mediaId', ), 'CASCADE', null, 'MediaAudienceRelations');
        $this->addRelation('MediaMarket', 'MediaMarket', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'MediaMarkets');
        $this->addRelation('MediaAudience', 'MediaAudience', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'MediaAudiences');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'timestampable' => array('create_column' => 'created_at', 'update_column' => 'updated_at', 'disable_updated_at' => 'false', ),
        );
    } // getBehaviors()

} // MediaTableMap
