<?php


/**
 * Base class that represents a query for the 'issues_issuesCategory' table.
 *
 * Relacion Issuees y Categorias
 *
 * @method IssueCategoryRelationQuery orderByIssueid($order = Criteria::ASC) Order by the issueId column
 * @method IssueCategoryRelationQuery orderByCategoryid($order = Criteria::ASC) Order by the categoryId column
 *
 * @method IssueCategoryRelationQuery groupByIssueid() Group by the issueId column
 * @method IssueCategoryRelationQuery groupByCategoryid() Group by the categoryId column
 *
 * @method IssueCategoryRelationQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method IssueCategoryRelationQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method IssueCategoryRelationQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method IssueCategoryRelationQuery leftJoinIssue($relationAlias = null) Adds a LEFT JOIN clause to the query using the Issue relation
 * @method IssueCategoryRelationQuery rightJoinIssue($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Issue relation
 * @method IssueCategoryRelationQuery innerJoinIssue($relationAlias = null) Adds a INNER JOIN clause to the query using the Issue relation
 *
 * @method IssueCategoryRelationQuery leftJoinIssueCategory($relationAlias = null) Adds a LEFT JOIN clause to the query using the IssueCategory relation
 * @method IssueCategoryRelationQuery rightJoinIssueCategory($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IssueCategory relation
 * @method IssueCategoryRelationQuery innerJoinIssueCategory($relationAlias = null) Adds a INNER JOIN clause to the query using the IssueCategory relation
 *
 * @method IssueCategoryRelation findOne(PropelPDO $con = null) Return the first IssueCategoryRelation matching the query
 * @method IssueCategoryRelation findOneOrCreate(PropelPDO $con = null) Return the first IssueCategoryRelation matching the query, or a new IssueCategoryRelation object populated from the query conditions when no match is found
 *
 * @method IssueCategoryRelation findOneByIssueid(int $issueId) Return the first IssueCategoryRelation filtered by the issueId column
 * @method IssueCategoryRelation findOneByCategoryid(int $categoryId) Return the first IssueCategoryRelation filtered by the categoryId column
 *
 * @method array findByIssueid(int $issueId) Return IssueCategoryRelation objects filtered by the issueId column
 * @method array findByCategoryid(int $categoryId) Return IssueCategoryRelation objects filtered by the categoryId column
 *
 * @package    propel.generator.issues.classes.om
 */
abstract class BaseIssueCategoryRelationQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseIssueCategoryRelationQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'IssueCategoryRelation', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new IssueCategoryRelationQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     IssueCategoryRelationQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return IssueCategoryRelationQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof IssueCategoryRelationQuery) {
            return $criteria;
        }
        $query = new IssueCategoryRelationQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$issueId, $categoryId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   IssueCategoryRelation|IssueCategoryRelation[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = IssueCategoryRelationPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(IssueCategoryRelationPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   IssueCategoryRelation A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ISSUEID`, `CATEGORYID` FROM `issues_issuesCategory` WHERE `ISSUEID` = :p0 AND `CATEGORYID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new IssueCategoryRelation();
            $obj->hydrate($row);
            IssueCategoryRelationPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return IssueCategoryRelation|IssueCategoryRelation[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|IssueCategoryRelation[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return IssueCategoryRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(IssueCategoryRelationPeer::ISSUEID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(IssueCategoryRelationPeer::CATEGORYID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return IssueCategoryRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(IssueCategoryRelationPeer::ISSUEID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(IssueCategoryRelationPeer::CATEGORYID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the issueId column
     *
     * Example usage:
     * <code>
     * $query->filterByIssueid(1234); // WHERE issueId = 1234
     * $query->filterByIssueid(array(12, 34)); // WHERE issueId IN (12, 34)
     * $query->filterByIssueid(array('min' => 12)); // WHERE issueId > 12
     * </code>
     *
     * @see       filterByIssue()
     *
     * @param     mixed $issueid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueCategoryRelationQuery The current query, for fluid interface
     */
    public function filterByIssueid($issueid = null, $comparison = null)
    {
        if (is_array($issueid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IssueCategoryRelationPeer::ISSUEID, $issueid, $comparison);
    }

    /**
     * Filter the query on the categoryId column
     *
     * Example usage:
     * <code>
     * $query->filterByCategoryid(1234); // WHERE categoryId = 1234
     * $query->filterByCategoryid(array(12, 34)); // WHERE categoryId IN (12, 34)
     * $query->filterByCategoryid(array('min' => 12)); // WHERE categoryId > 12
     * </code>
     *
     * @see       filterByIssueCategory()
     *
     * @param     mixed $categoryid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueCategoryRelationQuery The current query, for fluid interface
     */
    public function filterByCategoryid($categoryid = null, $comparison = null)
    {
        if (is_array($categoryid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IssueCategoryRelationPeer::CATEGORYID, $categoryid, $comparison);
    }

    /**
     * Filter the query by a related Issue object
     *
     * @param   Issue|PropelObjectCollection $issue The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueCategoryRelationQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIssue($issue, $comparison = null)
    {
        if ($issue instanceof Issue) {
            return $this
                ->addUsingAlias(IssueCategoryRelationPeer::ISSUEID, $issue->getId(), $comparison);
        } elseif ($issue instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(IssueCategoryRelationPeer::ISSUEID, $issue->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByIssue() only accepts arguments of type Issue or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Issue relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IssueCategoryRelationQuery The current query, for fluid interface
     */
    public function joinIssue($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Issue');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Issue');
        }

        return $this;
    }

    /**
     * Use the Issue relation Issue object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IssueQuery A secondary query class using the current class as primary query
     */
    public function useIssueQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIssue($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Issue', 'IssueQuery');
    }

    /**
     * Filter the query by a related IssueCategory object
     *
     * @param   IssueCategory|PropelObjectCollection $issueCategory The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueCategoryRelationQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIssueCategory($issueCategory, $comparison = null)
    {
        if ($issueCategory instanceof IssueCategory) {
            return $this
                ->addUsingAlias(IssueCategoryRelationPeer::CATEGORYID, $issueCategory->getId(), $comparison);
        } elseif ($issueCategory instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(IssueCategoryRelationPeer::CATEGORYID, $issueCategory->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByIssueCategory() only accepts arguments of type IssueCategory or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IssueCategory relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IssueCategoryRelationQuery The current query, for fluid interface
     */
    public function joinIssueCategory($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IssueCategory');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IssueCategory');
        }

        return $this;
    }

    /**
     * Use the IssueCategory relation IssueCategory object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IssueCategoryQuery A secondary query class using the current class as primary query
     */
    public function useIssueCategoryQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIssueCategory($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IssueCategory', 'IssueCategoryQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   IssueCategoryRelation $issueCategoryRelation Object to remove from the list of results
     *
     * @return IssueCategoryRelationQuery The current query, for fluid interface
     */
    public function prune($issueCategoryRelation = null)
    {
        if ($issueCategoryRelation) {
            $this->addCond('pruneCond0', $this->getAliasedColName(IssueCategoryRelationPeer::ISSUEID), $issueCategoryRelation->getIssueid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(IssueCategoryRelationPeer::CATEGORYID), $issueCategoryRelation->getCategoryid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
