<?php


/**
 * Base class that represents a query for the 'issues_category' table.
 *
 * Categorias de Issues
 *
 * @method IssueCategoryQuery orderById($order = Criteria::ASC) Order by the id column
 * @method IssueCategoryQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method IssueCategoryQuery orderByTreeLeft($order = Criteria::ASC) Order by the tree_left column
 * @method IssueCategoryQuery orderByTreeRight($order = Criteria::ASC) Order by the tree_right column
 * @method IssueCategoryQuery orderByTreeLevel($order = Criteria::ASC) Order by the tree_level column
 * @method IssueCategoryQuery orderByScope($order = Criteria::ASC) Order by the scope column
 *
 * @method IssueCategoryQuery groupById() Group by the id column
 * @method IssueCategoryQuery groupByName() Group by the name column
 * @method IssueCategoryQuery groupByTreeLeft() Group by the tree_left column
 * @method IssueCategoryQuery groupByTreeRight() Group by the tree_right column
 * @method IssueCategoryQuery groupByTreeLevel() Group by the tree_level column
 * @method IssueCategoryQuery groupByScope() Group by the scope column
 *
 * @method IssueCategoryQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method IssueCategoryQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method IssueCategoryQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method IssueCategoryQuery leftJoinIssueCategoryRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the IssueCategoryRelation relation
 * @method IssueCategoryQuery rightJoinIssueCategoryRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IssueCategoryRelation relation
 * @method IssueCategoryQuery innerJoinIssueCategoryRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the IssueCategoryRelation relation
 *
 * @method IssueCategory findOne(PropelPDO $con = null) Return the first IssueCategory matching the query
 * @method IssueCategory findOneOrCreate(PropelPDO $con = null) Return the first IssueCategory matching the query, or a new IssueCategory object populated from the query conditions when no match is found
 *
 * @method IssueCategory findOneById(int $id) Return the first IssueCategory filtered by the id column
 * @method IssueCategory findOneByName(string $name) Return the first IssueCategory filtered by the name column
 * @method IssueCategory findOneByTreeLeft(int $tree_left) Return the first IssueCategory filtered by the tree_left column
 * @method IssueCategory findOneByTreeRight(int $tree_right) Return the first IssueCategory filtered by the tree_right column
 * @method IssueCategory findOneByTreeLevel(int $tree_level) Return the first IssueCategory filtered by the tree_level column
 * @method IssueCategory findOneByScope(int $scope) Return the first IssueCategory filtered by the scope column
 *
 * @method array findById(int $id) Return IssueCategory objects filtered by the id column
 * @method array findByName(string $name) Return IssueCategory objects filtered by the name column
 * @method array findByTreeLeft(int $tree_left) Return IssueCategory objects filtered by the tree_left column
 * @method array findByTreeRight(int $tree_right) Return IssueCategory objects filtered by the tree_right column
 * @method array findByTreeLevel(int $tree_level) Return IssueCategory objects filtered by the tree_level column
 * @method array findByScope(int $scope) Return IssueCategory objects filtered by the scope column
 *
 * @package    propel.generator.issues.classes.om
 */
abstract class BaseIssueCategoryQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseIssueCategoryQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'IssueCategory', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new IssueCategoryQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     IssueCategoryQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return IssueCategoryQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof IssueCategoryQuery) {
            return $criteria;
        }
        $query = new IssueCategoryQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   IssueCategory|IssueCategory[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = IssueCategoryPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(IssueCategoryPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   IssueCategory A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `TREE_LEFT`, `TREE_RIGHT`, `TREE_LEVEL`, `SCOPE` FROM `issues_category` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new IssueCategory();
            $obj->hydrate($row);
            IssueCategoryPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return IssueCategory|IssueCategory[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|IssueCategory[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return IssueCategoryQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(IssueCategoryPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return IssueCategoryQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(IssueCategoryPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueCategoryQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IssueCategoryPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueCategoryQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IssueCategoryPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the tree_left column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLeft(1234); // WHERE tree_left = 1234
     * $query->filterByTreeLeft(array(12, 34)); // WHERE tree_left IN (12, 34)
     * $query->filterByTreeLeft(array('min' => 12)); // WHERE tree_left > 12
     * </code>
     *
     * @param     mixed $treeLeft The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueCategoryQuery The current query, for fluid interface
     */
    public function filterByTreeLeft($treeLeft = null, $comparison = null)
    {
        if (is_array($treeLeft)) {
            $useMinMax = false;
            if (isset($treeLeft['min'])) {
                $this->addUsingAlias(IssueCategoryPeer::TREE_LEFT, $treeLeft['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLeft['max'])) {
                $this->addUsingAlias(IssueCategoryPeer::TREE_LEFT, $treeLeft['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueCategoryPeer::TREE_LEFT, $treeLeft, $comparison);
    }

    /**
     * Filter the query on the tree_right column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeRight(1234); // WHERE tree_right = 1234
     * $query->filterByTreeRight(array(12, 34)); // WHERE tree_right IN (12, 34)
     * $query->filterByTreeRight(array('min' => 12)); // WHERE tree_right > 12
     * </code>
     *
     * @param     mixed $treeRight The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueCategoryQuery The current query, for fluid interface
     */
    public function filterByTreeRight($treeRight = null, $comparison = null)
    {
        if (is_array($treeRight)) {
            $useMinMax = false;
            if (isset($treeRight['min'])) {
                $this->addUsingAlias(IssueCategoryPeer::TREE_RIGHT, $treeRight['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeRight['max'])) {
                $this->addUsingAlias(IssueCategoryPeer::TREE_RIGHT, $treeRight['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueCategoryPeer::TREE_RIGHT, $treeRight, $comparison);
    }

    /**
     * Filter the query on the tree_level column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLevel(1234); // WHERE tree_level = 1234
     * $query->filterByTreeLevel(array(12, 34)); // WHERE tree_level IN (12, 34)
     * $query->filterByTreeLevel(array('min' => 12)); // WHERE tree_level > 12
     * </code>
     *
     * @param     mixed $treeLevel The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueCategoryQuery The current query, for fluid interface
     */
    public function filterByTreeLevel($treeLevel = null, $comparison = null)
    {
        if (is_array($treeLevel)) {
            $useMinMax = false;
            if (isset($treeLevel['min'])) {
                $this->addUsingAlias(IssueCategoryPeer::TREE_LEVEL, $treeLevel['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLevel['max'])) {
                $this->addUsingAlias(IssueCategoryPeer::TREE_LEVEL, $treeLevel['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueCategoryPeer::TREE_LEVEL, $treeLevel, $comparison);
    }

    /**
     * Filter the query on the scope column
     *
     * Example usage:
     * <code>
     * $query->filterByScope(1234); // WHERE scope = 1234
     * $query->filterByScope(array(12, 34)); // WHERE scope IN (12, 34)
     * $query->filterByScope(array('min' => 12)); // WHERE scope > 12
     * </code>
     *
     * @param     mixed $scope The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IssueCategoryQuery The current query, for fluid interface
     */
    public function filterByScope($scope = null, $comparison = null)
    {
        if (is_array($scope)) {
            $useMinMax = false;
            if (isset($scope['min'])) {
                $this->addUsingAlias(IssueCategoryPeer::SCOPE, $scope['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($scope['max'])) {
                $this->addUsingAlias(IssueCategoryPeer::SCOPE, $scope['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IssueCategoryPeer::SCOPE, $scope, $comparison);
    }

    /**
     * Filter the query by a related IssueCategoryRelation object
     *
     * @param   IssueCategoryRelation|PropelObjectCollection $issueCategoryRelation  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueCategoryQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIssueCategoryRelation($issueCategoryRelation, $comparison = null)
    {
        if ($issueCategoryRelation instanceof IssueCategoryRelation) {
            return $this
                ->addUsingAlias(IssueCategoryPeer::ID, $issueCategoryRelation->getCategoryid(), $comparison);
        } elseif ($issueCategoryRelation instanceof PropelObjectCollection) {
            return $this
                ->useIssueCategoryRelationQuery()
                ->filterByPrimaryKeys($issueCategoryRelation->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByIssueCategoryRelation() only accepts arguments of type IssueCategoryRelation or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IssueCategoryRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IssueCategoryQuery The current query, for fluid interface
     */
    public function joinIssueCategoryRelation($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IssueCategoryRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IssueCategoryRelation');
        }

        return $this;
    }

    /**
     * Use the IssueCategoryRelation relation IssueCategoryRelation object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IssueCategoryRelationQuery A secondary query class using the current class as primary query
     */
    public function useIssueCategoryRelationQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIssueCategoryRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IssueCategoryRelation', 'IssueCategoryRelationQuery');
    }

    /**
     * Filter the query by a related Issue object
     * using the issues_issuesCategory table as cross reference
     *
     * @param   Issue $issue the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IssueCategoryQuery The current query, for fluid interface
     */
    public function filterByIssue($issue, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useIssueCategoryRelationQuery()
            ->filterByIssue($issue, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   IssueCategory $issueCategory Object to remove from the list of results
     *
     * @return IssueCategoryQuery The current query, for fluid interface
     */
    public function prune($issueCategory = null)
    {
        if ($issueCategory) {
            $this->addUsingAlias(IssueCategoryPeer::ID, $issueCategory->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    // nested_set behavior

    /**
     * Filter the query to restrict the result to root objects
     *
     * @return    IssueCategoryQuery The current query, for fluid interface
     */
    public function treeRoots()
    {
        return $this->addUsingAlias(IssueCategoryPeer::LEFT_COL, 1, Criteria::EQUAL);
    }

    /**
     * Returns the objects in a certain tree, from the tree scope
     *
     * @param     int $scope		Scope to determine which objects node to return
     *
     * @return    IssueCategoryQuery The current query, for fluid interface
     */
    public function inTree($scope = null)
    {
        return $this->addUsingAlias(IssueCategoryPeer::SCOPE_COL, $scope, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to descendants of an object
     *
     * @param     IssueCategory $issueCategory The object to use for descendant search
     *
     * @return    IssueCategoryQuery The current query, for fluid interface
     */
    public function descendantsOf($issueCategory)
    {
        return $this
            ->inTree($issueCategory->getScopeValue())
            ->addUsingAlias(IssueCategoryPeer::LEFT_COL, $issueCategory->getLeftValue(), Criteria::GREATER_THAN)
            ->addUsingAlias(IssueCategoryPeer::LEFT_COL, $issueCategory->getRightValue(), Criteria::LESS_THAN);
    }

    /**
     * Filter the query to restrict the result to the branch of an object.
     * Same as descendantsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     IssueCategory $issueCategory The object to use for branch search
     *
     * @return    IssueCategoryQuery The current query, for fluid interface
     */
    public function branchOf($issueCategory)
    {
        return $this
            ->inTree($issueCategory->getScopeValue())
            ->addUsingAlias(IssueCategoryPeer::LEFT_COL, $issueCategory->getLeftValue(), Criteria::GREATER_EQUAL)
            ->addUsingAlias(IssueCategoryPeer::LEFT_COL, $issueCategory->getRightValue(), Criteria::LESS_EQUAL);
    }

    /**
     * Filter the query to restrict the result to children of an object
     *
     * @param     IssueCategory $issueCategory The object to use for child search
     *
     * @return    IssueCategoryQuery The current query, for fluid interface
     */
    public function childrenOf($issueCategory)
    {
        return $this
            ->descendantsOf($issueCategory)
            ->addUsingAlias(IssueCategoryPeer::LEVEL_COL, $issueCategory->getLevel() + 1, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to siblings of an object.
     * The result does not include the object passed as parameter.
     *
     * @param     IssueCategory $issueCategory The object to use for sibling search
     * @param      PropelPDO $con Connection to use.
     *
     * @return    IssueCategoryQuery The current query, for fluid interface
     */
    public function siblingsOf($issueCategory, PropelPDO $con = null)
    {
        if ($issueCategory->isRoot()) {
            return $this->
                add(IssueCategoryPeer::LEVEL_COL, '1<>1', Criteria::CUSTOM);
        } else {
            return $this
                ->childrenOf($issueCategory->getParent($con))
                ->prune($issueCategory);
        }
    }

    /**
     * Filter the query to restrict the result to ancestors of an object
     *
     * @param     IssueCategory $issueCategory The object to use for ancestors search
     *
     * @return    IssueCategoryQuery The current query, for fluid interface
     */
    public function ancestorsOf($issueCategory)
    {
        return $this
            ->inTree($issueCategory->getScopeValue())
            ->addUsingAlias(IssueCategoryPeer::LEFT_COL, $issueCategory->getLeftValue(), Criteria::LESS_THAN)
            ->addUsingAlias(IssueCategoryPeer::RIGHT_COL, $issueCategory->getRightValue(), Criteria::GREATER_THAN);
    }

    /**
     * Filter the query to restrict the result to roots of an object.
     * Same as ancestorsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     IssueCategory $issueCategory The object to use for roots search
     *
     * @return    IssueCategoryQuery The current query, for fluid interface
     */
    public function rootsOf($issueCategory)
    {
        return $this
            ->inTree($issueCategory->getScopeValue())
            ->addUsingAlias(IssueCategoryPeer::LEFT_COL, $issueCategory->getLeftValue(), Criteria::LESS_EQUAL)
            ->addUsingAlias(IssueCategoryPeer::RIGHT_COL, $issueCategory->getRightValue(), Criteria::GREATER_EQUAL);
    }

    /**
     * Order the result by branch, i.e. natural tree order
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    IssueCategoryQuery The current query, for fluid interface
     */
    public function orderByBranch($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addDescendingOrderByColumn(IssueCategoryPeer::LEFT_COL);
        } else {
            return $this
                ->addAscendingOrderByColumn(IssueCategoryPeer::LEFT_COL);
        }
    }

    /**
     * Order the result by level, the closer to the root first
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    IssueCategoryQuery The current query, for fluid interface
     */
    public function orderByLevel($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addAscendingOrderByColumn(IssueCategoryPeer::RIGHT_COL);
        } else {
            return $this
                ->addDescendingOrderByColumn(IssueCategoryPeer::RIGHT_COL);
        }
    }

    /**
     * Returns a root node for the tree
     *
     * @param      int $scope		Scope to determine which root node to return
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     IssueCategory The tree root object
     */
    public function findRoot($scope = null, $con = null)
    {
        return $this
            ->addUsingAlias(IssueCategoryPeer::LEFT_COL, 1, Criteria::EQUAL)
            ->inTree($scope)
            ->findOne($con);
    }

    /**
     * Returns the root objects for all trees.
     *
     * @param      PropelPDO $con	Connection to use.
     *
     * @return    mixed the list of results, formatted by the current formatter
     */
    public function findRoots($con = null)
    {
        return $this
            ->treeRoots()
            ->find($con);
    }

    /**
     * Returns a tree of objects
     *
     * @param      int $scope		Scope to determine which tree node to return
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     mixed the list of results, formatted by the current formatter
     */
    public function findTree($scope = null, $con = null)
    {
        return $this
            ->inTree($scope)
            ->orderByBranch()
            ->find($con);
    }

}
