<?php



/**
 * This class defines the structure of the 'issues_issue' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.issues.classes.map
 */
class IssueTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'issues.classes.map.IssueTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('issues_issue');
        $this->setPhpName('Issue');
        $this->setClassname('Issue');
        $this->setPackage('issues.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'VARCHAR', true, 100, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('PARENTID', 'Parentid', 'INTEGER', false, null, null);
        $this->addColumn('DESCRIPTION', 'Description', 'LONGVARCHAR', false, null, null);
        $this->addColumn('IMPACT', 'Impact', 'INTEGER', false, 5, null);
        $this->addColumn('VALORATION', 'Valoration', 'INTEGER', false, 5, null);
        $this->addColumn('EVOLUTION', 'Evolution', 'INTEGER', false, 5, null);
        $this->addColumn('OBJECTTYPE', 'Objecttype', 'VARCHAR', false, 20, null);
        $this->addColumn('OBJECTID', 'Objectid', 'INTEGER', false, 5, null);
        $this->addColumn('CREATED_AT', 'CreatedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('UPDATED_AT', 'UpdatedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('VERSION', 'Version', 'INTEGER', false, null, 0);
        $this->addColumn('VERSION_CREATED_BY', 'VersionCreatedBy', 'VARCHAR', false, 100, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('HeadlineIssue', 'HeadlineIssue', RelationMap::ONE_TO_MANY, array('id' => 'issueId', ), 'CASCADE', null, 'HeadlineIssues');
        $this->addRelation('IssueCategoryRelation', 'IssueCategoryRelation', RelationMap::ONE_TO_MANY, array('id' => 'issueId', ), 'CASCADE', null, 'IssueCategoryRelations');
        $this->addRelation('IssueActor', 'IssueActor', RelationMap::ONE_TO_MANY, array('id' => 'issueId', ), 'CASCADE', null, 'IssueActors');
        $this->addRelation('IssueVersion', 'IssueVersion', RelationMap::ONE_TO_MANY, array('id' => 'id', ), 'CASCADE', null, 'IssueVersions');
        $this->addRelation('Headline', 'Headline', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Headlines');
        $this->addRelation('IssueCategory', 'IssueCategory', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'IssueCategorys');
        $this->addRelation('Actor', 'Actor', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Actors');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'versionable' => array('version_column' => 'version', 'version_table' => 'issues_issueLog', 'log_created_at' => 'false', 'log_created_by' => 'true', 'log_comment' => 'false', 'version_created_at_column' => 'version_created_at', 'version_created_by_column' => 'version_created_by', 'version_comment_column' => 'version_comment', ),
            'timestampable' => array('create_column' => 'created_at', 'update_column' => 'updated_at', 'disable_updated_at' => 'false', ),
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
        );
    } // getBehaviors()

} // IssueTableMap
