<?php



/**
 * Skeleton subclass for performing query and update operations on the 'issues_issue' table.
 *
 * Asuntos
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.issues.classes
 */
class IssuePeer extends BaseIssuePeer {

	/** the default item name for this class */
	const ITEM_NAME = 'Issues';

	private $searchString;
	private $categoryId;
	private $impact;
	private $valoration;
	private $evolution;
	private $limit;
  private $headlineId;
  private $candidates;

	//mapea las condiciones del filtro
	var $filterConditions = array(
					"searchString"=>"setSearchString",
					"perPage"=>"setPerPage",
					"limit" => "setLimit",
					"categoryId"=>"setCategoryId",
					"impact"=>"setImpact",
					"valoration"=>"setValoration",
					"evolution"=>"setEvolution",
          "headlineId" => "setHeadlineId",
          "getCandidates" => "setCandidates"
				);

 /**
	 * Especifica una cadena de busqueda.
	 * @param searchString cadena de busqueda.
	 */
	function setSearchString($searchString){
		$this->searchString = $searchString;
	}

 /**
	 * Especifica cantidad de resultados por pagina.
	 * @param perPage integer cantidad de resultados por pagina.
	 */
	function setPerPage($perPage){
		$this->perPage = $perPage;
	}

 	/**
	 * Especifica una cantidad maxima de registros.
	 * @param limit cantidad maxima de registros.
	 */
	function setLimit($limit){
		$this->limit = $limit;
	}

 	/**
	 * Especifica una categoria de busqueda.
	 * @param categoryId categoria de busqueda
	 */
	function setCategoryId($categoryId){
		$this->categoryId = $categoryId;
	}

 	/**
	 * Especifica una valoration de busqueda.
	 * @param valoration valoration de busqueda
	 */
	function setValoration($valoration){
		$this->valoration = $valoration;
	}

 	/**
	 * Especifica una categoria de busqueda.
	 * @param impact impact de busqueda
	 */
	function setImpact($impact){
		$this->impact = $impact;
	}

 	/**
	 * Especifica una evolution de busqueda.
	 * @param evolution evolution de busqueda
	 */
	function setEvolution($evolution){
		$this->evolution = $evolution;
	}
        
        /**
	 * Especifica un headline cuyos actores no deben aparecer en la busqueda.
	 * @param int headlineId, id del headline.
	 */
	function setCandidates($candidates){
		$this->candidates = $candidates;
	}
        
        /**
	 * Especifica un headline cuyos asuntos no deben aparecer en la busqueda.
	 * @param int headlineId, id del headline.
	 */
	function setHeadlineId($headlineId){
		$this->headlineId = $headlineId;
	}

	/**
	* Obtiene un issue.
	*
	* @param int $id id del issue
	* @return boolean true si se actualizo la informacion correctamente, false sino
	*/
	function get($id){
		$issue = IssueQuery::create()->findPk($id);
		return $issue;
	}

 /**
	* Crea un issue nuevo.
	*
	* @param array $params con los datos del proyecto
	* @return boolean true si se creo el issue correctamente, false sino
	*/
	function create($params,$con = null) {
		$issue = new Issue();
		$issue = Common::setObjectFromParams($issue,$params);
		try {
			$issue->save($con);
			return true;
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}

	/**
	* Actualiza la informacion de un issue.
	*
	* @param int $id id del issue
	* @param array $params datos del issue
	* @return boolean true si se actualizo la informacion correctamente, false sino
	*/
	function update($id,$params){
		$issue = IssueQuery::create()->findPk($id);
		$issue = Common::setObjectFromParams($issue,$params);
		try {
			$issue->save($con);
			return true;
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}

 /**
	* Elimina un issue a partir de los valores de la clave.
	*
	* @param int $id id del issue
	*	@return boolean true si se elimino correctamente el project, false sino
	*/
	function delete($id){
		$issue = IssuePeer::retrieveByPK($id);
		try {
			$issue->delete();
			return true;
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}

	/**
	* Elimina definitivamente un issue a partir del id.
	*
	* @param int $id Id del issue
	* @return boolean true
	*/
  function hardDelete($id) {
		IssuePeer::disableSoftDelete();
		$issue = IssuePeer::retrieveByPk($id);
		try {
			$issue->forceDelete();
			return true;
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}

 /**
	* Obtiene todos los issue desactivados.
	*
	*	@return array Informacion sobre los issue
	*/
	function getSoftDeleted() {
		$criteria = new Criteria();
		$criteria->add(IssuePeer::DELETED_AT, null, Criteria::ISNOTNULL);
		IssuePeer::disableSoftDelete();
		$issues = IssuePeer::doSelect($criteria);
		return $issues;
  }

	/**
	* Recupera del softdelete un issue
	*
	* @param int $id Id del issue
	* @return boolean true
	*/
  function recoverDeleted($id) {
		IssuePeer::disableSoftDelete();
		$issue = IssuePeer::retrieveByPk($id);
		try {
			$issue->unDelete();
			return true;
		}
		catch (PropelException $exp) {
			if (ConfigModule::get("global","showPropelExceptions"))
				print_r($exp->getMessage());
			return false;
		}
	}

 /**
	 * Retorna el criteria generado a partir de los par?metros de b?squeda
	 *
	 * @return criteria $criteria Criteria con par?metros de b?squeda
	 */
	private function getSearchCriteria(){
		$criteria = new IssueQuery();
		$criteria->setLimit($this->limit);
		$criteria->addAscendingOrderByColumn(IssuePeer::ID);

		if ($this->categoryId) {
			$categoryIds = array();
			array_push($categoryIds, $this->categoryId);

			$category = IssueCategoryPeer::get($this->categoryId);
			if ($category->hasChildren()){
				$descendants = $category->getDescendants();
				foreach ($descendants as $descendant)
					array_push($categoryIds, $descendant->getId());
			}
			$issuesOnCategory = IssueCategoryRelationQuery::create()->select('Issueid')->add(IssueCategoryRelationPeer::CATEGORYID,$categoryIds,Criteria::IN)->find()->toArray();
			$criteria->add(IssuePeer::ID,$issuesOnCategory,Criteria::IN);
		}

		if ($this->evolution)
			$criteria->add(IssuePeer::EVOLUTION,$this->evolution);

		if ($this->valoration)
			$criteria->add(IssuePeer::VALORATION,$this->valoration);

		if ($this->impact)
			$criteria->add(IssuePeer::IMPACT,$this->impact);

		if ($this->searchString){
			$criteria->setIgnoreCase(true);
			$criteria->add(IssuePeer::NAME,"%" . $this->searchString . "%",Criteria::LIKE);
			$criterionDescription = $criteria->getNewCriterion(IssuePeer::DESCRIPTION,"%" . $this->searchString . "%",Criteria::LIKE);
			$criteria->addOr($criterionDescription);
		}

		if (!empty($this->headlineId)) {
			$headline = HeadlineQuery::create()->findPk($this->headlineId);
			$headlineIssuesIds = $headline->getAssignedIssuesArray();
			if (!empty($this->candidates))
				$criteria->add(IssuePeer::ID, $headlineIssuesIds,Criteria::NOT_IN);
			else
				$criteria->filterByHeadlineId($this->headlineId);
		}

		return $criteria;

	}

	/**
	* Obtiene la cantidad de filas por pagina por defecto en los listado paginados.
	*
	* @return int Cantidad de filas por pagina
	*/
	function getRowsPerPage() {
		if (!isset($this->perPage))
			$this->perPage = Common::getRowsPerPage();
		return $this->perPage;
	}

 /**
	* Obtiene todos los issue paginados segun la condicion de busqueda ingresada.
	*
	* @param int $page [optional] Numero de pagina actual
	* @param int $perPage [optional] Cantidad de filas por pagina
	* @return array Informacion sobre todos los issues
	*/
	function getAllPaginatedFiltered($page=1,$perPage=-1)	{
		if ($perPage == -1)
			$perPage = $this->getRowsPerPage();
		if (empty($page))
			$page = 1;
		$criteria = $this->getSearchCriteria();
		$pager = new PropelPager($criteria,"IssuePeer", "doSelect",$page,$perPage);
		return $pager;
	}

	/**
	* Obtiene todos los issue existentes filtrados por la condicion $this->getSearchCriteria()
	* @return PropelObjectCollection Todos los issue
	*/
	function getAll()	{
    $criteria = $this->getSearchCriteria();    
		return IssuePeer::doSelect($criteria);
	}


} // IssuePeer
