<?php



/**
 * Skeleton subclass for representing a row from the 'issues_issue' table.
 *
 * Asuntos
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.issues.classes
 */
class Issue extends BaseIssue {

 /** the default item name for this class */
	const ITEM_NAME = 'Issue';

	//Tipos de impacto
	const IMPACT_LOW          = 1;
	const IMPACT_MED          = 5;
	const IMPACT_HIGH         = 9;

	protected static $issueImpactTypes = array(
						Issue::IMPACT_LOW          => 'Low',
						Issue::IMPACT_MED          => 'Medium',
						Issue::IMPACT_HIGH         => 'High'
					);

	//Estados de asuntos
	const EVOLUTION_EMERGENT            = 1;
	const EVOLUTION_GROWING             = 2;
	const EVOLUTION_STABLE              = 3;
	const EVOLUTION_PLATEAU             = 4;
	const EVOLUTION_DECLINING           = 5;
	const EVOLUTION_CLOSED              = 6;

	protected static $issueEvolutionStages = array(
						Issue::EVOLUTION_EMERGENT      => 'Emergent',
						Issue::EVOLUTION_GROWING       => 'Growing',
						Issue::EVOLUTION_STABLE        => 'Stable',
						Issue::EVOLUTION_PLATEAU       => 'Plateau',
						Issue::EVOLUTION_DECLINING     => 'Declining',
						Issue::EVOLUTION_CLOSED        => 'Closed'
					);

	//Tipos de impacto
	const VALORATION_HIGHLY_POSITIVE     = 1;
	const VALORATION_POSITIVE            = 2;
	const VALORATION_NEUTRAL             = 3;
	const VALORATION_NEGATIVE            = 4;
	const VALORATION_HIGHLY_NEGATIVE     = 5;

	protected static $issueValorationTypes = array(
						Issue::VALORATION_HIGHLY_POSITIVE     => 'Higly positive',
						Issue::VALORATION_POSITIVE            => 'Positive',
						Issue::VALORATION_NEUTRAL             => 'Neutral',
						Issue::VALORATION_NEGATIVE            => 'Negative',
						Issue::VALORATION_HIGHLY_NEGATIVE     => 'Highly negative'
					);

 /**
	* Devuelve los tipos de Impacto
	*/
	public static function getIssueImpactTypes() {
		return self::$issueImpactTypes;
	}

 /**
	* Devuelve los tipos de Impacto
	*/
	public static function getIssueEvolutionStages() {
		return self::$issueEvolutionStages;
	}

 /**
	* Devuelve los tipos de Impacto
	*/
	public static function getIssueValorationTypes() {
		return self::$issueValorationTypes;
	}

 /**
	* Obtiene el id de todas las categorias asignadas.
	*
	*	@return array Id de todos los actor category asignados
	*/
	function getAssignedCategoriesArray(){
		return IssueCategoryRelationQuery::create()->filterByIssue($this)->select('Categoryid')->find()->toArray();
	}

 /**
	* Determina la existencia de una relacion con un determindo actor.
	* @param $actor Object
	* @param $type Object[optional]
	*/
	public function hasActor($actor, $type = null) {
		$issueActorQuery = IssueActorQuery::create()->filterByIssue($this)
															 ->filterByActor($actor);
		if ($type !== null)
			$issueActorQuery->filterByType($type);

		return ($issueActorQuery->count() > 0);
	}

 /**
	* Obtiene el id de todas las categorias asignadas.
	*
	*	@return array Id de todos los actor category asignados
	*/
	function getAssignedActorsArray(){
		return IssueActorQuery::create()->filterByIssue($this)->select('Actorid')->find()->toArray();
	}

 /**
	* Obtiene el nombre del objeto que modifico el issue
	*
	*	@return string con nombre de quien modifico el issue
	*/
	function changedBy(){
		if ($this->getObjectType() != "") {
			$objectQueryName = ucfirst($this->getObjectType() . 'Query');
			if (class_exists($objectQueryName)) {
				$query = call_user_func(array($objectQueryName, 'create'));
				return $query->findPK($this->getObjectid());
			}
		}
	}

 /**
	* Obtiene el nombre traducido del tipo de impacto.
	*
	* @return array tipos de region
	*/
	function getImpactTypeTranslated() {
		$issueImpactTypes = Common::getTranslatedArray(Issue::getIssueImpactTypes(),'issues');
		return $issueImpactTypes[$this->getImpact()];
	}

 /**
	* Obtiene el nombre traducido del tipo de impacto.
	*
	* @return array tipos de region
	*/
	function getValorationTypeTranslated() {
		$issueValorationTypes = Common::getTranslatedArray(Issue::getIssueValorationTypes(),'issues');
		return $issueValorationTypes[$this->getValoration()];
	}

 /**
	* Obtiene el nombre traducido del tipo de impacto.
	*
	* @return array tipos de region
	*/
	function getEvolutionStageTranslated() {
		$issueEvolutionStages = Common::getTranslatedArray(Issue::getIssueEvolutionStages(),'issues');
		return $issueEvolutionStages[$this->getEvolution()];
	}

 /**
	* Devuelve las versiones para el asunto ordenadas en por fecha de creación y paginadas.
	* @param string $orderType forma en que se ordena, Criteria::ASC = ascendente Criteria::DESC = descendente.
	* @param int $page numero de pagina.
	* @param int $maxPerPage cantidad maxima de elementos por pagina.
	* @return array Versions para el proyecto ordenados en forma decreciente por fecha de creación.
	*/
	public function getVersionsOrderedByUpdatedPaginated($orderType = Criteria::ASC, $page=1, $maxPerPage=5) {
		$issueVersionPeer = new IssueVersionPeer();
//		return $issueVersionPeer->getAllByIssueIdOrderedByUpdatedPaginated($this->getId(), $orderType, $page, $maxPerPage);
		return IssueVersionQuery::create()->filterByIssue($this)->orderByUpdatedAt($orderType)->paginate($page, $perPage);
	}

 /**
	* Obtiene el issue padre.
	*
	*	@return issue padre.
	*/
	function getParentIssue(){
		return IssueQuery::create()->findOneById($this->getParentId());
	}

 /**
	* Obtiene los hijos de un issue.
	*
	*	@return array de Issues hijos, o null si no tiene.
	*/
	function getChildIssues() {
		return IssueQuery::create()->filterByParentid($this->getId())->find();
	}

 /**
	* Obtiene los hijos de un issue.
	*
	*	@return Coleccion de Issues hijos
	*/
	function getBrood() {
		return IssueQuery::create()->filterByParentId($this->getId())->find();
	}

 /**
	* Obtiene los hijos de un issue.
	*
	*	@return Coleccion de Issues hijos
	*/
	function getThisAndBrood() {
		return IssueQuery::create()->filterByParentId($this->getId())->_or()->filterById($this->getId())->find();
	}

 /**
	* Obtiene los hijos de un issue.
	*
	*	@return Coleccion de Issues hijos
	*/
	function getBroodIds() {
		return IssueQuery::create()->select('Id')->filterByParentId($this->getId())->toArray();
	}

 /**
	* Devuelve el string para ser usado en el historico de operaciones
	*	@return string con el texto a guardar en el historico de operaciones
	*/
	public function getLogData(){
		return substr($this->__toString(), 0, 50);
	}

} // Issue
