<link rel="stylesheet" href="css/bootstrapValidator.css">
<script type="text/javascript" src="scripts/bootstrapValidator.js"></script>

<div class="col-xs-6 col-xs-offset-2">
	<form class="form-validation" onsubmit="alert('submit'); return false;">

		<div class="form-group">
			<label>Objetivo</label>
			<input name="params[objectiveId]" class="form-control">
		</div>
		<div class="form-group">
			<label>Nombre</label>
			<input name="params[name]" class="form-control" data-egytca-validation="not-empty">
		</div>
		<div class="form-group">
			<label>Descripción</label>
			<textarea name="params[description]" class="form-control"></textarea>
		</div><div class="form-group">
			<label>E-mail</label>
			<input name="params[email]" class="form-control" data-egytca-validation="email-address not-empty">
		</div>
		<div class="form-group">
			<label>Tipo</label>
			<select name="params[classKey]" class="form-control">
				<option>-- Elija una opción --</option>
				<option value="|-$classKeyMap.numericIndicator-|" |-$classKeyMap.numericIndicator|selected:$indicator->getClassKey()-|>Numérico</option>
				<option value="|-$classKeyMap.booleanIndicator-|" |-$classKeyMap.booleanIndicator|selected:$indicator->getClassKey()-|>Booleano</option>
			</select>
		</div>

		<div class="form-group">
			<input type="submit" class="btn btn-primary" value="Guardar">
			<input type="button" class="btn btn-default" value="Cancelar" onclick="alert('cancelar');">
		</div>

	</form>
</div>

<!-- script-1.js -->
<script>
	var egytcaValidate = function(form) {

		$(form).bootstrapValidator({
			message: 'El valor no es válido',
			submitButtons: 'input[type="submit"]',
			fields: createFieldsOptions(form)
		});
	};

	var createFieldsOptions = function(form) {

		var fieldsOptions = {};

		var fields = $(form).find('[data-egytca-validation]');

		fields.each(function() {
			fieldsOptions[this.name] = {
				validators: createFieldValidators(this)
			};
		});

		return fieldsOptions;
	};

	var createFieldValidators = function(field) {

		var fieldValidators = {};

		var validators = field.dataset.egytcaValidation.split(' ');

		validators.forEach(function(validator) {

			if ( ! (validator in validatorPresets) )
				throw 'validator "' + validator + '" does not exist';

			var validatorPreset = validatorPresets[validator];
			fieldValidators[validatorPreset.name] = validatorPreset.options;
		});

		return fieldValidators;
	};

	var validatorPresets = {
		'not-empty': {
			name: 'notEmpty',
			options: {
				message: 'El campo es obligatorio y no puede estar vacío'
			}
		},
		'email-address': {
			name: 'emailAddress',
			options: {
				message: 'No es una dirección de email válida'
			}
		}
	};

</script>
<!-- end script-1.js -->

<!-- script-2.js -->
<script>
$(function() {
	$('.form-validation').each(function() {
		egytcaValidate(this); // convertir a plugin de jQuery
	});
});
</script>
<!-- end script-1.js -->