<?php


/**
 * Base class that represents a query for the 'indicators_graphSerie' table.
 *
 * Relacion Graficos y series
 *
 * @method IndicatorGraphSerieQuery orderByGraphid($order = Criteria::ASC) Order by the graphId column
 * @method IndicatorGraphSerieQuery orderByIndicatorid($order = Criteria::ASC) Order by the indicatorId column
 *
 * @method IndicatorGraphSerieQuery groupByGraphid() Group by the graphId column
 * @method IndicatorGraphSerieQuery groupByIndicatorid() Group by the indicatorId column
 *
 * @method IndicatorGraphSerieQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method IndicatorGraphSerieQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method IndicatorGraphSerieQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method IndicatorGraphSerieQuery leftJoinIndicator($relationAlias = null) Adds a LEFT JOIN clause to the query using the Indicator relation
 * @method IndicatorGraphSerieQuery rightJoinIndicator($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Indicator relation
 * @method IndicatorGraphSerieQuery innerJoinIndicator($relationAlias = null) Adds a INNER JOIN clause to the query using the Indicator relation
 *
 * @method IndicatorGraphSerieQuery leftJoinIndicatorGraph($relationAlias = null) Adds a LEFT JOIN clause to the query using the IndicatorGraph relation
 * @method IndicatorGraphSerieQuery rightJoinIndicatorGraph($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IndicatorGraph relation
 * @method IndicatorGraphSerieQuery innerJoinIndicatorGraph($relationAlias = null) Adds a INNER JOIN clause to the query using the IndicatorGraph relation
 *
 * @method IndicatorGraphSerie findOne(PropelPDO $con = null) Return the first IndicatorGraphSerie matching the query
 * @method IndicatorGraphSerie findOneOrCreate(PropelPDO $con = null) Return the first IndicatorGraphSerie matching the query, or a new IndicatorGraphSerie object populated from the query conditions when no match is found
 *
 * @method IndicatorGraphSerie findOneByGraphid(int $graphId) Return the first IndicatorGraphSerie filtered by the graphId column
 * @method IndicatorGraphSerie findOneByIndicatorid(int $indicatorId) Return the first IndicatorGraphSerie filtered by the indicatorId column
 *
 * @method array findByGraphid(int $graphId) Return IndicatorGraphSerie objects filtered by the graphId column
 * @method array findByIndicatorid(int $indicatorId) Return IndicatorGraphSerie objects filtered by the indicatorId column
 *
 * @package    propel.generator.indicators.classes.om
 */
abstract class BaseIndicatorGraphSerieQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseIndicatorGraphSerieQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'IndicatorGraphSerie', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new IndicatorGraphSerieQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     IndicatorGraphSerieQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return IndicatorGraphSerieQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof IndicatorGraphSerieQuery) {
            return $criteria;
        }
        $query = new IndicatorGraphSerieQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$graphId, $indicatorId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   IndicatorGraphSerie|IndicatorGraphSerie[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = IndicatorGraphSeriePeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphSeriePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   IndicatorGraphSerie A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `GRAPHID`, `INDICATORID` FROM `indicators_graphSerie` WHERE `GRAPHID` = :p0 AND `INDICATORID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new IndicatorGraphSerie();
            $obj->hydrate($row);
            IndicatorGraphSeriePeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return IndicatorGraphSerie|IndicatorGraphSerie[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|IndicatorGraphSerie[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return IndicatorGraphSerieQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(IndicatorGraphSeriePeer::GRAPHID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(IndicatorGraphSeriePeer::INDICATORID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return IndicatorGraphSerieQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(IndicatorGraphSeriePeer::GRAPHID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(IndicatorGraphSeriePeer::INDICATORID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the graphId column
     *
     * Example usage:
     * <code>
     * $query->filterByGraphid(1234); // WHERE graphId = 1234
     * $query->filterByGraphid(array(12, 34)); // WHERE graphId IN (12, 34)
     * $query->filterByGraphid(array('min' => 12)); // WHERE graphId > 12
     * </code>
     *
     * @see       filterByIndicatorGraph()
     *
     * @param     mixed $graphid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphSerieQuery The current query, for fluid interface
     */
    public function filterByGraphid($graphid = null, $comparison = null)
    {
        if (is_array($graphid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IndicatorGraphSeriePeer::GRAPHID, $graphid, $comparison);
    }

    /**
     * Filter the query on the indicatorId column
     *
     * Example usage:
     * <code>
     * $query->filterByIndicatorid(1234); // WHERE indicatorId = 1234
     * $query->filterByIndicatorid(array(12, 34)); // WHERE indicatorId IN (12, 34)
     * $query->filterByIndicatorid(array('min' => 12)); // WHERE indicatorId > 12
     * </code>
     *
     * @see       filterByIndicator()
     *
     * @param     mixed $indicatorid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphSerieQuery The current query, for fluid interface
     */
    public function filterByIndicatorid($indicatorid = null, $comparison = null)
    {
        if (is_array($indicatorid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IndicatorGraphSeriePeer::INDICATORID, $indicatorid, $comparison);
    }

    /**
     * Filter the query by a related Indicator object
     *
     * @param   Indicator|PropelObjectCollection $indicator The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorGraphSerieQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicator($indicator, $comparison = null)
    {
        if ($indicator instanceof Indicator) {
            return $this
                ->addUsingAlias(IndicatorGraphSeriePeer::INDICATORID, $indicator->getId(), $comparison);
        } elseif ($indicator instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(IndicatorGraphSeriePeer::INDICATORID, $indicator->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByIndicator() only accepts arguments of type Indicator or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Indicator relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorGraphSerieQuery The current query, for fluid interface
     */
    public function joinIndicator($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Indicator');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Indicator');
        }

        return $this;
    }

    /**
     * Use the Indicator relation Indicator object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIndicator($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Indicator', 'IndicatorQuery');
    }

    /**
     * Filter the query by a related IndicatorGraph object
     *
     * @param   IndicatorGraph|PropelObjectCollection $indicatorGraph The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorGraphSerieQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicatorGraph($indicatorGraph, $comparison = null)
    {
        if ($indicatorGraph instanceof IndicatorGraph) {
            return $this
                ->addUsingAlias(IndicatorGraphSeriePeer::GRAPHID, $indicatorGraph->getId(), $comparison);
        } elseif ($indicatorGraph instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(IndicatorGraphSeriePeer::GRAPHID, $indicatorGraph->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByIndicatorGraph() only accepts arguments of type IndicatorGraph or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IndicatorGraph relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorGraphSerieQuery The current query, for fluid interface
     */
    public function joinIndicatorGraph($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IndicatorGraph');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IndicatorGraph');
        }

        return $this;
    }

    /**
     * Use the IndicatorGraph relation IndicatorGraph object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorGraphQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorGraphQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIndicatorGraph($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IndicatorGraph', 'IndicatorGraphQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   IndicatorGraphSerie $indicatorGraphSerie Object to remove from the list of results
     *
     * @return IndicatorGraphSerieQuery The current query, for fluid interface
     */
    public function prune($indicatorGraphSerie = null)
    {
        if ($indicatorGraphSerie) {
            $this->addCond('pruneCond0', $this->getAliasedColName(IndicatorGraphSeriePeer::GRAPHID), $indicatorGraphSerie->getGraphid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(IndicatorGraphSeriePeer::INDICATORID), $indicatorGraphSerie->getIndicatorid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
