<?php


/**
 * Base class that represents a query for the 'indicators_graphComment' table.
 *
 * Comentaros de graficos
 *
 * @method IndicatorGraphCommentQuery orderById($order = Criteria::ASC) Order by the id column
 * @method IndicatorGraphCommentQuery orderByGraphid($order = Criteria::ASC) Order by the graphId column
 * @method IndicatorGraphCommentQuery orderByCommentdate($order = Criteria::ASC) Order by the commentDate column
 * @method IndicatorGraphCommentQuery orderByComment($order = Criteria::ASC) Order by the comment column
 *
 * @method IndicatorGraphCommentQuery groupById() Group by the id column
 * @method IndicatorGraphCommentQuery groupByGraphid() Group by the graphId column
 * @method IndicatorGraphCommentQuery groupByCommentdate() Group by the commentDate column
 * @method IndicatorGraphCommentQuery groupByComment() Group by the comment column
 *
 * @method IndicatorGraphCommentQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method IndicatorGraphCommentQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method IndicatorGraphCommentQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method IndicatorGraphCommentQuery leftJoinIndicatorGraph($relationAlias = null) Adds a LEFT JOIN clause to the query using the IndicatorGraph relation
 * @method IndicatorGraphCommentQuery rightJoinIndicatorGraph($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IndicatorGraph relation
 * @method IndicatorGraphCommentQuery innerJoinIndicatorGraph($relationAlias = null) Adds a INNER JOIN clause to the query using the IndicatorGraph relation
 *
 * @method IndicatorGraphComment findOne(PropelPDO $con = null) Return the first IndicatorGraphComment matching the query
 * @method IndicatorGraphComment findOneOrCreate(PropelPDO $con = null) Return the first IndicatorGraphComment matching the query, or a new IndicatorGraphComment object populated from the query conditions when no match is found
 *
 * @method IndicatorGraphComment findOneById(int $id) Return the first IndicatorGraphComment filtered by the id column
 * @method IndicatorGraphComment findOneByGraphid(int $graphId) Return the first IndicatorGraphComment filtered by the graphId column
 * @method IndicatorGraphComment findOneByCommentdate(string $commentDate) Return the first IndicatorGraphComment filtered by the commentDate column
 * @method IndicatorGraphComment findOneByComment(string $comment) Return the first IndicatorGraphComment filtered by the comment column
 *
 * @method array findById(int $id) Return IndicatorGraphComment objects filtered by the id column
 * @method array findByGraphid(int $graphId) Return IndicatorGraphComment objects filtered by the graphId column
 * @method array findByCommentdate(string $commentDate) Return IndicatorGraphComment objects filtered by the commentDate column
 * @method array findByComment(string $comment) Return IndicatorGraphComment objects filtered by the comment column
 *
 * @package    propel.generator.indicators.classes.om
 */
abstract class BaseIndicatorGraphCommentQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseIndicatorGraphCommentQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'IndicatorGraphComment', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new IndicatorGraphCommentQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     IndicatorGraphCommentQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return IndicatorGraphCommentQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof IndicatorGraphCommentQuery) {
            return $criteria;
        }
        $query = new IndicatorGraphCommentQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$id, $graphId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   IndicatorGraphComment|IndicatorGraphComment[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = IndicatorGraphCommentPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphCommentPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   IndicatorGraphComment A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `GRAPHID`, `COMMENTDATE`, `COMMENT` FROM `indicators_graphComment` WHERE `ID` = :p0 AND `GRAPHID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new IndicatorGraphComment();
            $obj->hydrate($row);
            IndicatorGraphCommentPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return IndicatorGraphComment|IndicatorGraphComment[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|IndicatorGraphComment[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return IndicatorGraphCommentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(IndicatorGraphCommentPeer::ID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(IndicatorGraphCommentPeer::GRAPHID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return IndicatorGraphCommentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(IndicatorGraphCommentPeer::ID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(IndicatorGraphCommentPeer::GRAPHID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphCommentQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IndicatorGraphCommentPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the graphId column
     *
     * Example usage:
     * <code>
     * $query->filterByGraphid(1234); // WHERE graphId = 1234
     * $query->filterByGraphid(array(12, 34)); // WHERE graphId IN (12, 34)
     * $query->filterByGraphid(array('min' => 12)); // WHERE graphId > 12
     * </code>
     *
     * @see       filterByIndicatorGraph()
     *
     * @param     mixed $graphid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphCommentQuery The current query, for fluid interface
     */
    public function filterByGraphid($graphid = null, $comparison = null)
    {
        if (is_array($graphid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IndicatorGraphCommentPeer::GRAPHID, $graphid, $comparison);
    }

    /**
     * Filter the query on the commentDate column
     *
     * Example usage:
     * <code>
     * $query->filterByCommentdate('2011-03-14'); // WHERE commentDate = '2011-03-14'
     * $query->filterByCommentdate('now'); // WHERE commentDate = '2011-03-14'
     * $query->filterByCommentdate(array('max' => 'yesterday')); // WHERE commentDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $commentdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphCommentQuery The current query, for fluid interface
     */
    public function filterByCommentdate($commentdate = null, $comparison = null)
    {
        if (is_array($commentdate)) {
            $useMinMax = false;
            if (isset($commentdate['min'])) {
                $this->addUsingAlias(IndicatorGraphCommentPeer::COMMENTDATE, $commentdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($commentdate['max'])) {
                $this->addUsingAlias(IndicatorGraphCommentPeer::COMMENTDATE, $commentdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphCommentPeer::COMMENTDATE, $commentdate, $comparison);
    }

    /**
     * Filter the query on the comment column
     *
     * Example usage:
     * <code>
     * $query->filterByComment('fooValue');   // WHERE comment = 'fooValue'
     * $query->filterByComment('%fooValue%'); // WHERE comment LIKE '%fooValue%'
     * </code>
     *
     * @param     string $comment The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphCommentQuery The current query, for fluid interface
     */
    public function filterByComment($comment = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($comment)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $comment)) {
                $comment = str_replace('*', '%', $comment);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IndicatorGraphCommentPeer::COMMENT, $comment, $comparison);
    }

    /**
     * Filter the query by a related IndicatorGraph object
     *
     * @param   IndicatorGraph|PropelObjectCollection $indicatorGraph The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorGraphCommentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicatorGraph($indicatorGraph, $comparison = null)
    {
        if ($indicatorGraph instanceof IndicatorGraph) {
            return $this
                ->addUsingAlias(IndicatorGraphCommentPeer::GRAPHID, $indicatorGraph->getId(), $comparison);
        } elseif ($indicatorGraph instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(IndicatorGraphCommentPeer::GRAPHID, $indicatorGraph->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByIndicatorGraph() only accepts arguments of type IndicatorGraph or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IndicatorGraph relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorGraphCommentQuery The current query, for fluid interface
     */
    public function joinIndicatorGraph($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IndicatorGraph');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IndicatorGraph');
        }

        return $this;
    }

    /**
     * Use the IndicatorGraph relation IndicatorGraph object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorGraphQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorGraphQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIndicatorGraph($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IndicatorGraph', 'IndicatorGraphQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   IndicatorGraphComment $indicatorGraphComment Object to remove from the list of results
     *
     * @return IndicatorGraphCommentQuery The current query, for fluid interface
     */
    public function prune($indicatorGraphComment = null)
    {
        if ($indicatorGraphComment) {
            $this->addCond('pruneCond0', $this->getAliasedColName(IndicatorGraphCommentPeer::ID), $indicatorGraphComment->getId(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(IndicatorGraphCommentPeer::GRAPHID), $indicatorGraphComment->getGraphid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
