<?php


/**
 * Base class that represents a row from the 'headlines_headline' table.
 *
 * Headline
 *
 * @package    propel.generator.headlines.classes.om
 */
abstract class BaseHeadline extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'HeadlinePeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        HeadlinePeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the content field.
     * @var        string
     */
    protected $content;

    /**
     * The value for the datepublished field.
     * @var        string
     */
    protected $datepublished;

    /**
     * The value for the headlinedate field.
     * @var        string
     */
    protected $headlinedate;

    /**
     * The value for the url field.
     * @var        string
     */
    protected $url;

    /**
     * The value for the twitts field.
     * @var        int
     */
    protected $twitts;

    /**
     * The value for the fcb field.
     * @var        int
     */
    protected $fcb;

    /**
     * The value for the gplus field.
     * @var        int
     */
    protected $gplus;

    /**
     * The value for the comment field.
     * @var        int
     */
    protected $comment;

    /**
     * The value for the picture field.
     * @var        boolean
     */
    protected $picture;

    /**
     * The value for the campaignid field.
     * @var        int
     */
    protected $campaignid;

    /**
     * The value for the mediaid field.
     * @var        int
     */
    protected $mediaid;

    /**
     * The value for the value field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $value;

    /**
     * The value for the relevance field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $relevance;

    /**
     * The value for the internalid field.
     * @var        string
     */
    protected $internalid;

    /**
     * The value for the page field.
     * @var        int
     */
    protected $page;

    /**
     * The value for the section field.
     * @var        string
     */
    protected $section;

    /**
     * The value for the author field.
     * @var        string
     */
    protected $author;

    /**
     * The value for the source field.
     * @var        string
     */
    protected $source;

    /**
     * The value for the summary field.
     * @var        string
     */
    protected $summary;

    /**
     * The value for the caption field.
     * @var        string
     */
    protected $caption;

    /**
     * The value for the program field.
     * @var        string
     */
    protected $program;

    /**
     * The value for the strategy field.
     * @var        string
     */
    protected $strategy;

    /**
     * The value for the length field.
     * @var        int
     */
    protected $length;

    /**
     * The value for the agenda field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $agenda;

    /**
     * The value for the headlinescope field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $headlinescope;

    /**
     * The value for the processed field.
     * Note: this column has a database default value of: false
     * @var        boolean
     */
    protected $processed;

    /**
     * The value for the class_key field.
     * @var        int
     */
    protected $class_key;

    /**
     * The value for the created_at field.
     * @var        string
     */
    protected $created_at;

    /**
     * The value for the updated_at field.
     * @var        string
     */
    protected $updated_at;

    /**
     * The value for the issuescount field.
     * @var        int
     */
    protected $issuescount;

    /**
     * @var        Media
     */
    protected $aMedia;

    /**
     * @var        PropelObjectCollection|HeadlineActor[] Collection to store aggregation of HeadlineActor objects.
     */
    protected $collHeadlineActors;
    protected $collHeadlineActorsPartial;

    /**
     * @var        PropelObjectCollection|HeadlineIssue[] Collection to store aggregation of HeadlineIssue objects.
     */
    protected $collHeadlineIssues;
    protected $collHeadlineIssuesPartial;

    /**
     * @var        PropelObjectCollection|HeadlineDocument[] Collection to store aggregation of HeadlineDocument objects.
     */
    protected $collHeadlineDocuments;
    protected $collHeadlineDocumentsPartial;

    /**
     * @var        PropelObjectCollection|HeadlineTagRelation[] Collection to store aggregation of HeadlineTagRelation objects.
     */
    protected $collHeadlineTagRelations;
    protected $collHeadlineTagRelationsPartial;

    /**
     * @var        PropelObjectCollection|Actor[] Collection to store aggregation of Actor objects.
     */
    protected $collActors;

    /**
     * @var        PropelObjectCollection|Issue[] Collection to store aggregation of Issue objects.
     */
    protected $collIssues;

    /**
     * @var        PropelObjectCollection|Document[] Collection to store aggregation of Document objects.
     */
    protected $collDocuments;

    /**
     * @var        PropelObjectCollection|HeadlineTag[] Collection to store aggregation of HeadlineTag objects.
     */
    protected $collHeadlineTags;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $actorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $issuesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $documentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlineTagsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlineActorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlineIssuesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlineDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlineTagRelationsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->value = 0;
        $this->relevance = 0;
        $this->agenda = 0;
        $this->headlinescope = 0;
        $this->processed = false;
    }

    /**
     * Initializes internal state of BaseHeadline object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     * Headline Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Headline
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [content] column value.
     * Headline content
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Get the [optionally formatted] temporal [datepublished] column value.
     * Fecha de publicacion
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDatepublished($format = 'Y-m-d H:i:s')
    {
        if ($this->datepublished === null) {
            return null;
        }

        if ($this->datepublished === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->datepublished);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->datepublished, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [headlinedate] column value.
     * Fecha del titular
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getHeadlinedate($format = 'Y-m-d H:i:s')
    {
        if ($this->headlinedate === null) {
            return null;
        }

        if ($this->headlinedate === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->headlinedate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->headlinedate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [url] column value.
     * Url del titular
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Get the [twitts] column value.
     * Twitts del titular
     * @return int
     */
    public function getTwitts()
    {
        return $this->twitts;
    }

    /**
     * Get the [fcb] column value.
     * Fcb del titular
     * @return int
     */
    public function getFcb()
    {
        return $this->fcb;
    }

    /**
     * Get the [gplus] column value.
     * G+ del titular
     * @return int
     */
    public function getGplus()
    {
        return $this->gplus;
    }

    /**
     * Get the [comment] column value.
     * Comentario del titular
     * @return int
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * Get the [picture] column value.
     * Foto del titular
     * @return boolean
     */
    public function getPicture()
    {
        return $this->picture;
    }

    /**
     * Get the [campaignid] column value.
     * Campaign ID
     * @return int
     */
    public function getCampaignid()
    {
        return $this->campaignid;
    }

    /**
     * Get the [mediaid] column value.
     * Media ID
     * @return int
     */
    public function getMediaid()
    {
        return $this->mediaid;
    }

    /**
     * Get the [value] column value.
     * Valoracion de la noticia
     * @return int
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Get the [relevance] column value.
     * Valoracion del medio
     * @return int
     */
    public function getRelevance()
    {
        return $this->relevance;
    }

    /**
     * Get the [internalid] column value.
     * Headline internal Id
     * @return string
     */
    public function getInternalid()
    {
        return $this->internalid;
    }

    /**
     * Get the [page] column value.
     * Pagina
     * @return int
     */
    public function getPage()
    {
        return $this->page;
    }

    /**
     * Get the [section] column value.
     * Seccion
     * @return string
     */
    public function getSection()
    {
        return $this->section;
    }

    /**
     * Get the [author] column value.
     * Autor
     * @return string
     */
    public function getAuthor()
    {
        return $this->author;
    }

    /**
     * Get the [source] column value.
     * Fuente
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * Get the [summary] column value.
     * Resumen
     * @return string
     */
    public function getSummary()
    {
        return $this->summary;
    }

    /**
     * Get the [caption] column value.
     *
     * @return string
     */
    public function getCaption()
    {
        return $this->caption;
    }

    /**
     * Get the [program] column value.
     *
     * @return string
     */
    public function getProgram()
    {
        return $this->program;
    }

    /**
     * Get the [strategy] column value.
     * Estrategia que parseo el titular
     * @return string
     */
    public function getStrategy()
    {
        return $this->strategy;
    }

    /**
     * Get the [length] column value.
     * Duracion en segs o superficie en mm2
     * @return int
     */
    public function getLength()
    {
        return $this->length;
    }

    /**
     * Get the [agenda] column value.
     * Tipo de agenda
     * @return int
     */
    public function getAgenda()
    {
        return $this->agenda;
    }

    /**
     * Get the [headlinescope] column value.
     * Ambito
     * @return int
     */
    public function getHeadlinescope()
    {
        return $this->headlinescope;
    }

    /**
     * Get the [processed] column value.
     * Indica si esta procesado
     * @return boolean
     */
    public function getProcessed()
    {
        return $this->processed;
    }

    /**
     * Get the [class_key] column value.
     *
     * @return int
     */
    public function getClassKey()
    {
        return $this->class_key;
    }

    /**
     * Get the [optionally formatted] temporal [created_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getCreatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->created_at === null) {
            return null;
        }

        if ($this->created_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->created_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->created_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [updated_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdatedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->updated_at === null) {
            return null;
        }

        if ($this->updated_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [issuescount] column value.
     *
     * @return int
     */
    public function getIssuescount()
    {
        return $this->issuescount;
    }

    /**
     * Set the value of [id] column.
     * Headline Id
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = HeadlinePeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Headline
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = HeadlinePeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [content] column.
     * Headline content
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setContent($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->content !== $v) {
            $this->content = $v;
            $this->modifiedColumns[] = HeadlinePeer::CONTENT;
        }


        return $this;
    } // setContent()

    /**
     * Sets the value of [datepublished] column to a normalized version of the date/time value specified.
     * Fecha de publicacion
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Headline The current object (for fluent API support)
     */
    public function setDatepublished($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->datepublished !== null || $dt !== null) {
            $currentDateAsString = ($this->datepublished !== null && $tmpDt = new DateTime($this->datepublished)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->datepublished = $newDateAsString;
                $this->modifiedColumns[] = HeadlinePeer::DATEPUBLISHED;
            }
        } // if either are not null


        return $this;
    } // setDatepublished()

    /**
     * Sets the value of [headlinedate] column to a normalized version of the date/time value specified.
     * Fecha del titular
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Headline The current object (for fluent API support)
     */
    public function setHeadlinedate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->headlinedate !== null || $dt !== null) {
            $currentDateAsString = ($this->headlinedate !== null && $tmpDt = new DateTime($this->headlinedate)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->headlinedate = $newDateAsString;
                $this->modifiedColumns[] = HeadlinePeer::HEADLINEDATE;
            }
        } // if either are not null


        return $this;
    } // setHeadlinedate()

    /**
     * Set the value of [url] column.
     * Url del titular
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setUrl($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->url !== $v) {
            $this->url = $v;
            $this->modifiedColumns[] = HeadlinePeer::URL;
        }


        return $this;
    } // setUrl()

    /**
     * Set the value of [twitts] column.
     * Twitts del titular
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setTwitts($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->twitts !== $v) {
            $this->twitts = $v;
            $this->modifiedColumns[] = HeadlinePeer::TWITTS;
        }


        return $this;
    } // setTwitts()

    /**
     * Set the value of [fcb] column.
     * Fcb del titular
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setFcb($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->fcb !== $v) {
            $this->fcb = $v;
            $this->modifiedColumns[] = HeadlinePeer::FCB;
        }


        return $this;
    } // setFcb()

    /**
     * Set the value of [gplus] column.
     * G+ del titular
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setGplus($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->gplus !== $v) {
            $this->gplus = $v;
            $this->modifiedColumns[] = HeadlinePeer::GPLUS;
        }


        return $this;
    } // setGplus()

    /**
     * Set the value of [comment] column.
     * Comentario del titular
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setComment($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->comment !== $v) {
            $this->comment = $v;
            $this->modifiedColumns[] = HeadlinePeer::COMMENT;
        }


        return $this;
    } // setComment()

    /**
     * Sets the value of the [picture] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Foto del titular
     * @param boolean|integer|string $v The new value
     * @return Headline The current object (for fluent API support)
     */
    public function setPicture($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->picture !== $v) {
            $this->picture = $v;
            $this->modifiedColumns[] = HeadlinePeer::PICTURE;
        }


        return $this;
    } // setPicture()

    /**
     * Set the value of [campaignid] column.
     * Campaign ID
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setCampaignid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->campaignid !== $v) {
            $this->campaignid = $v;
            $this->modifiedColumns[] = HeadlinePeer::CAMPAIGNID;
        }


        return $this;
    } // setCampaignid()

    /**
     * Set the value of [mediaid] column.
     * Media ID
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setMediaid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->mediaid !== $v) {
            $this->mediaid = $v;
            $this->modifiedColumns[] = HeadlinePeer::MEDIAID;
        }

        if ($this->aMedia !== null && $this->aMedia->getId() !== $v) {
            $this->aMedia = null;
        }


        return $this;
    } // setMediaid()

    /**
     * Set the value of [value] column.
     * Valoracion de la noticia
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setValue($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->value !== $v) {
            $this->value = $v;
            $this->modifiedColumns[] = HeadlinePeer::VALUE;
        }


        return $this;
    } // setValue()

    /**
     * Set the value of [relevance] column.
     * Valoracion del medio
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setRelevance($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->relevance !== $v) {
            $this->relevance = $v;
            $this->modifiedColumns[] = HeadlinePeer::RELEVANCE;
        }


        return $this;
    } // setRelevance()

    /**
     * Set the value of [internalid] column.
     * Headline internal Id
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setInternalid($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->internalid !== $v) {
            $this->internalid = $v;
            $this->modifiedColumns[] = HeadlinePeer::INTERNALID;
        }


        return $this;
    } // setInternalid()

    /**
     * Set the value of [page] column.
     * Pagina
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setPage($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->page !== $v) {
            $this->page = $v;
            $this->modifiedColumns[] = HeadlinePeer::PAGE;
        }


        return $this;
    } // setPage()

    /**
     * Set the value of [section] column.
     * Seccion
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setSection($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->section !== $v) {
            $this->section = $v;
            $this->modifiedColumns[] = HeadlinePeer::SECTION;
        }


        return $this;
    } // setSection()

    /**
     * Set the value of [author] column.
     * Autor
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setAuthor($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->author !== $v) {
            $this->author = $v;
            $this->modifiedColumns[] = HeadlinePeer::AUTHOR;
        }


        return $this;
    } // setAuthor()

    /**
     * Set the value of [source] column.
     * Fuente
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setSource($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->source !== $v) {
            $this->source = $v;
            $this->modifiedColumns[] = HeadlinePeer::SOURCE;
        }


        return $this;
    } // setSource()

    /**
     * Set the value of [summary] column.
     * Resumen
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setSummary($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->summary !== $v) {
            $this->summary = $v;
            $this->modifiedColumns[] = HeadlinePeer::SUMMARY;
        }


        return $this;
    } // setSummary()

    /**
     * Set the value of [caption] column.
     *
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setCaption($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->caption !== $v) {
            $this->caption = $v;
            $this->modifiedColumns[] = HeadlinePeer::CAPTION;
        }


        return $this;
    } // setCaption()

    /**
     * Set the value of [program] column.
     *
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setProgram($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->program !== $v) {
            $this->program = $v;
            $this->modifiedColumns[] = HeadlinePeer::PROGRAM;
        }


        return $this;
    } // setProgram()

    /**
     * Set the value of [strategy] column.
     * Estrategia que parseo el titular
     * @param string $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setStrategy($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->strategy !== $v) {
            $this->strategy = $v;
            $this->modifiedColumns[] = HeadlinePeer::STRATEGY;
        }


        return $this;
    } // setStrategy()

    /**
     * Set the value of [length] column.
     * Duracion en segs o superficie en mm2
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setLength($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->length !== $v) {
            $this->length = $v;
            $this->modifiedColumns[] = HeadlinePeer::LENGTH;
        }


        return $this;
    } // setLength()

    /**
     * Set the value of [agenda] column.
     * Tipo de agenda
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setAgenda($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->agenda !== $v) {
            $this->agenda = $v;
            $this->modifiedColumns[] = HeadlinePeer::AGENDA;
        }


        return $this;
    } // setAgenda()

    /**
     * Set the value of [headlinescope] column.
     * Ambito
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setHeadlinescope($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->headlinescope !== $v) {
            $this->headlinescope = $v;
            $this->modifiedColumns[] = HeadlinePeer::HEADLINESCOPE;
        }


        return $this;
    } // setHeadlinescope()

    /**
     * Sets the value of the [processed] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Indica si esta procesado
     * @param boolean|integer|string $v The new value
     * @return Headline The current object (for fluent API support)
     */
    public function setProcessed($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->processed !== $v) {
            $this->processed = $v;
            $this->modifiedColumns[] = HeadlinePeer::PROCESSED;
        }


        return $this;
    } // setProcessed()

    /**
     * Set the value of [class_key] column.
     *
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setClassKey($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->class_key !== $v) {
            $this->class_key = $v;
            $this->modifiedColumns[] = HeadlinePeer::CLASS_KEY;
        }


        return $this;
    } // setClassKey()

    /**
     * Sets the value of [created_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Headline The current object (for fluent API support)
     */
    public function setCreatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->created_at !== null || $dt !== null) {
            $currentDateAsString = ($this->created_at !== null && $tmpDt = new DateTime($this->created_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->created_at = $newDateAsString;
                $this->modifiedColumns[] = HeadlinePeer::CREATED_AT;
            }
        } // if either are not null


        return $this;
    } // setCreatedAt()

    /**
     * Sets the value of [updated_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Headline The current object (for fluent API support)
     */
    public function setUpdatedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated_at !== null || $dt !== null) {
            $currentDateAsString = ($this->updated_at !== null && $tmpDt = new DateTime($this->updated_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated_at = $newDateAsString;
                $this->modifiedColumns[] = HeadlinePeer::UPDATED_AT;
            }
        } // if either are not null


        return $this;
    } // setUpdatedAt()

    /**
     * Set the value of [issuescount] column.
     *
     * @param int $v new value
     * @return Headline The current object (for fluent API support)
     */
    public function setIssuescount($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->issuescount !== $v) {
            $this->issuescount = $v;
            $this->modifiedColumns[] = HeadlinePeer::ISSUESCOUNT;
        }


        return $this;
    } // setIssuescount()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->value !== 0) {
                return false;
            }

            if ($this->relevance !== 0) {
                return false;
            }

            if ($this->agenda !== 0) {
                return false;
            }

            if ($this->headlinescope !== 0) {
                return false;
            }

            if ($this->processed !== false) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->content = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->datepublished = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->headlinedate = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->url = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->twitts = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
            $this->fcb = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
            $this->gplus = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->comment = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
            $this->picture = ($row[$startcol + 10] !== null) ? (boolean) $row[$startcol + 10] : null;
            $this->campaignid = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->mediaid = ($row[$startcol + 12] !== null) ? (int) $row[$startcol + 12] : null;
            $this->value = ($row[$startcol + 13] !== null) ? (int) $row[$startcol + 13] : null;
            $this->relevance = ($row[$startcol + 14] !== null) ? (int) $row[$startcol + 14] : null;
            $this->internalid = ($row[$startcol + 15] !== null) ? (string) $row[$startcol + 15] : null;
            $this->page = ($row[$startcol + 16] !== null) ? (int) $row[$startcol + 16] : null;
            $this->section = ($row[$startcol + 17] !== null) ? (string) $row[$startcol + 17] : null;
            $this->author = ($row[$startcol + 18] !== null) ? (string) $row[$startcol + 18] : null;
            $this->source = ($row[$startcol + 19] !== null) ? (string) $row[$startcol + 19] : null;
            $this->summary = ($row[$startcol + 20] !== null) ? (string) $row[$startcol + 20] : null;
            $this->caption = ($row[$startcol + 21] !== null) ? (string) $row[$startcol + 21] : null;
            $this->program = ($row[$startcol + 22] !== null) ? (string) $row[$startcol + 22] : null;
            $this->strategy = ($row[$startcol + 23] !== null) ? (string) $row[$startcol + 23] : null;
            $this->length = ($row[$startcol + 24] !== null) ? (int) $row[$startcol + 24] : null;
            $this->agenda = ($row[$startcol + 25] !== null) ? (int) $row[$startcol + 25] : null;
            $this->headlinescope = ($row[$startcol + 26] !== null) ? (int) $row[$startcol + 26] : null;
            $this->processed = ($row[$startcol + 27] !== null) ? (boolean) $row[$startcol + 27] : null;
            $this->class_key = ($row[$startcol + 28] !== null) ? (int) $row[$startcol + 28] : null;
            $this->created_at = ($row[$startcol + 29] !== null) ? (string) $row[$startcol + 29] : null;
            $this->updated_at = ($row[$startcol + 30] !== null) ? (string) $row[$startcol + 30] : null;
            $this->issuescount = ($row[$startcol + 31] !== null) ? (int) $row[$startcol + 31] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 32; // 32 = HeadlinePeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Headline object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aMedia !== null && $this->mediaid !== $this->aMedia->getId()) {
            $this->aMedia = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = HeadlinePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aMedia = null;
            $this->collHeadlineActors = null;

            $this->collHeadlineIssues = null;

            $this->collHeadlineDocuments = null;

            $this->collHeadlineTagRelations = null;

            $this->collActors = null;
            $this->collIssues = null;
            $this->collDocuments = null;
            $this->collHeadlineTags = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = HeadlineQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
                // timestampable behavior
                if (!$this->isColumnModified(HeadlinePeer::CREATED_AT)) {
                    $this->setCreatedAt(time());
                }
                if (!$this->isColumnModified(HeadlinePeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            } else {
                $ret = $ret && $this->preUpdate($con);
                // timestampable behavior
                if ($this->isModified() && !$this->isColumnModified(HeadlinePeer::UPDATED_AT)) {
                    $this->setUpdatedAt(time());
                }
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                // aggregate_column behavior
                if (null !== $this->collHeadlineIssues) {
                    $this->setIssuescount($this->computeIssuescount($con));
                    if ($this->isModified()) {
                        $this->save($con);
                    }
                }
                HeadlinePeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aMedia !== null) {
                if ($this->aMedia->isModified() || $this->aMedia->isNew()) {
                    $affectedRows += $this->aMedia->save($con);
                }
                $this->setMedia($this->aMedia);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->actorsScheduledForDeletion !== null) {
                if (!$this->actorsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->actorsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    HeadlineActorQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->actorsScheduledForDeletion = null;
                }

                foreach ($this->getActors() as $actor) {
                    if ($actor->isModified()) {
                        $actor->save($con);
                    }
                }
            }

            if ($this->issuesScheduledForDeletion !== null) {
                if (!$this->issuesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->issuesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    HeadlineIssueQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->issuesScheduledForDeletion = null;
                }

                foreach ($this->getIssues() as $issue) {
                    if ($issue->isModified()) {
                        $issue->save($con);
                    }
                }
            }

            if ($this->documentsScheduledForDeletion !== null) {
                if (!$this->documentsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->documentsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    HeadlineDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->documentsScheduledForDeletion = null;
                }

                foreach ($this->getDocuments() as $document) {
                    if ($document->isModified()) {
                        $document->save($con);
                    }
                }
            }

            if ($this->headlineTagsScheduledForDeletion !== null) {
                if (!$this->headlineTagsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->headlineTagsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    HeadlineTagRelationQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->headlineTagsScheduledForDeletion = null;
                }

                foreach ($this->getHeadlineTags() as $headlineTag) {
                    if ($headlineTag->isModified()) {
                        $headlineTag->save($con);
                    }
                }
            }

            if ($this->headlineActorsScheduledForDeletion !== null) {
                if (!$this->headlineActorsScheduledForDeletion->isEmpty()) {
                    HeadlineActorQuery::create()
                        ->filterByPrimaryKeys($this->headlineActorsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->headlineActorsScheduledForDeletion = null;
                }
            }

            if ($this->collHeadlineActors !== null) {
                foreach ($this->collHeadlineActors as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->headlineIssuesScheduledForDeletion !== null) {
                if (!$this->headlineIssuesScheduledForDeletion->isEmpty()) {
                    HeadlineIssueQuery::create()
                        ->filterByPrimaryKeys($this->headlineIssuesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->headlineIssuesScheduledForDeletion = null;
                }
            }

            if ($this->collHeadlineIssues !== null) {
                foreach ($this->collHeadlineIssues as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->headlineDocumentsScheduledForDeletion !== null) {
                if (!$this->headlineDocumentsScheduledForDeletion->isEmpty()) {
                    HeadlineDocumentQuery::create()
                        ->filterByPrimaryKeys($this->headlineDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->headlineDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collHeadlineDocuments !== null) {
                foreach ($this->collHeadlineDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->headlineTagRelationsScheduledForDeletion !== null) {
                if (!$this->headlineTagRelationsScheduledForDeletion->isEmpty()) {
                    HeadlineTagRelationQuery::create()
                        ->filterByPrimaryKeys($this->headlineTagRelationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->headlineTagRelationsScheduledForDeletion = null;
                }
            }

            if ($this->collHeadlineTagRelations !== null) {
                foreach ($this->collHeadlineTagRelations as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = HeadlinePeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . HeadlinePeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(HeadlinePeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(HeadlinePeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(HeadlinePeer::CONTENT)) {
            $modifiedColumns[':p' . $index++]  = '`CONTENT`';
        }
        if ($this->isColumnModified(HeadlinePeer::DATEPUBLISHED)) {
            $modifiedColumns[':p' . $index++]  = '`DATEPUBLISHED`';
        }
        if ($this->isColumnModified(HeadlinePeer::HEADLINEDATE)) {
            $modifiedColumns[':p' . $index++]  = '`HEADLINEDATE`';
        }
        if ($this->isColumnModified(HeadlinePeer::URL)) {
            $modifiedColumns[':p' . $index++]  = '`URL`';
        }
        if ($this->isColumnModified(HeadlinePeer::TWITTS)) {
            $modifiedColumns[':p' . $index++]  = '`TWITTS`';
        }
        if ($this->isColumnModified(HeadlinePeer::FCB)) {
            $modifiedColumns[':p' . $index++]  = '`FCB`';
        }
        if ($this->isColumnModified(HeadlinePeer::GPLUS)) {
            $modifiedColumns[':p' . $index++]  = '`GPLUS`';
        }
        if ($this->isColumnModified(HeadlinePeer::COMMENT)) {
            $modifiedColumns[':p' . $index++]  = '`COMMENT`';
        }
        if ($this->isColumnModified(HeadlinePeer::PICTURE)) {
            $modifiedColumns[':p' . $index++]  = '`PICTURE`';
        }
        if ($this->isColumnModified(HeadlinePeer::CAMPAIGNID)) {
            $modifiedColumns[':p' . $index++]  = '`CAMPAIGNID`';
        }
        if ($this->isColumnModified(HeadlinePeer::MEDIAID)) {
            $modifiedColumns[':p' . $index++]  = '`MEDIAID`';
        }
        if ($this->isColumnModified(HeadlinePeer::VALUE)) {
            $modifiedColumns[':p' . $index++]  = '`VALUE`';
        }
        if ($this->isColumnModified(HeadlinePeer::RELEVANCE)) {
            $modifiedColumns[':p' . $index++]  = '`RELEVANCE`';
        }
        if ($this->isColumnModified(HeadlinePeer::INTERNALID)) {
            $modifiedColumns[':p' . $index++]  = '`INTERNALID`';
        }
        if ($this->isColumnModified(HeadlinePeer::PAGE)) {
            $modifiedColumns[':p' . $index++]  = '`PAGE`';
        }
        if ($this->isColumnModified(HeadlinePeer::SECTION)) {
            $modifiedColumns[':p' . $index++]  = '`SECTION`';
        }
        if ($this->isColumnModified(HeadlinePeer::AUTHOR)) {
            $modifiedColumns[':p' . $index++]  = '`AUTHOR`';
        }
        if ($this->isColumnModified(HeadlinePeer::SOURCE)) {
            $modifiedColumns[':p' . $index++]  = '`SOURCE`';
        }
        if ($this->isColumnModified(HeadlinePeer::SUMMARY)) {
            $modifiedColumns[':p' . $index++]  = '`SUMMARY`';
        }
        if ($this->isColumnModified(HeadlinePeer::CAPTION)) {
            $modifiedColumns[':p' . $index++]  = '`CAPTION`';
        }
        if ($this->isColumnModified(HeadlinePeer::PROGRAM)) {
            $modifiedColumns[':p' . $index++]  = '`PROGRAM`';
        }
        if ($this->isColumnModified(HeadlinePeer::STRATEGY)) {
            $modifiedColumns[':p' . $index++]  = '`STRATEGY`';
        }
        if ($this->isColumnModified(HeadlinePeer::LENGTH)) {
            $modifiedColumns[':p' . $index++]  = '`LENGTH`';
        }
        if ($this->isColumnModified(HeadlinePeer::AGENDA)) {
            $modifiedColumns[':p' . $index++]  = '`AGENDA`';
        }
        if ($this->isColumnModified(HeadlinePeer::HEADLINESCOPE)) {
            $modifiedColumns[':p' . $index++]  = '`HEADLINESCOPE`';
        }
        if ($this->isColumnModified(HeadlinePeer::PROCESSED)) {
            $modifiedColumns[':p' . $index++]  = '`PROCESSED`';
        }
        if ($this->isColumnModified(HeadlinePeer::CLASS_KEY)) {
            $modifiedColumns[':p' . $index++]  = '`CLASS_KEY`';
        }
        if ($this->isColumnModified(HeadlinePeer::CREATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`CREATED_AT`';
        }
        if ($this->isColumnModified(HeadlinePeer::UPDATED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED_AT`';
        }
        if ($this->isColumnModified(HeadlinePeer::ISSUESCOUNT)) {
            $modifiedColumns[':p' . $index++]  = '`ISSUESCOUNT`';
        }

        $sql = sprintf(
            'INSERT INTO `headlines_headline` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`CONTENT`':
                        $stmt->bindValue($identifier, $this->content, PDO::PARAM_STR);
                        break;
                    case '`DATEPUBLISHED`':
                        $stmt->bindValue($identifier, $this->datepublished, PDO::PARAM_STR);
                        break;
                    case '`HEADLINEDATE`':
                        $stmt->bindValue($identifier, $this->headlinedate, PDO::PARAM_STR);
                        break;
                    case '`URL`':
                        $stmt->bindValue($identifier, $this->url, PDO::PARAM_STR);
                        break;
                    case '`TWITTS`':
                        $stmt->bindValue($identifier, $this->twitts, PDO::PARAM_INT);
                        break;
                    case '`FCB`':
                        $stmt->bindValue($identifier, $this->fcb, PDO::PARAM_INT);
                        break;
                    case '`GPLUS`':
                        $stmt->bindValue($identifier, $this->gplus, PDO::PARAM_INT);
                        break;
                    case '`COMMENT`':
                        $stmt->bindValue($identifier, $this->comment, PDO::PARAM_INT);
                        break;
                    case '`PICTURE`':
                        $stmt->bindValue($identifier, (int) $this->picture, PDO::PARAM_INT);
                        break;
                    case '`CAMPAIGNID`':
                        $stmt->bindValue($identifier, $this->campaignid, PDO::PARAM_INT);
                        break;
                    case '`MEDIAID`':
                        $stmt->bindValue($identifier, $this->mediaid, PDO::PARAM_INT);
                        break;
                    case '`VALUE`':
                        $stmt->bindValue($identifier, $this->value, PDO::PARAM_INT);
                        break;
                    case '`RELEVANCE`':
                        $stmt->bindValue($identifier, $this->relevance, PDO::PARAM_INT);
                        break;
                    case '`INTERNALID`':
                        $stmt->bindValue($identifier, $this->internalid, PDO::PARAM_STR);
                        break;
                    case '`PAGE`':
                        $stmt->bindValue($identifier, $this->page, PDO::PARAM_INT);
                        break;
                    case '`SECTION`':
                        $stmt->bindValue($identifier, $this->section, PDO::PARAM_STR);
                        break;
                    case '`AUTHOR`':
                        $stmt->bindValue($identifier, $this->author, PDO::PARAM_STR);
                        break;
                    case '`SOURCE`':
                        $stmt->bindValue($identifier, $this->source, PDO::PARAM_STR);
                        break;
                    case '`SUMMARY`':
                        $stmt->bindValue($identifier, $this->summary, PDO::PARAM_STR);
                        break;
                    case '`CAPTION`':
                        $stmt->bindValue($identifier, $this->caption, PDO::PARAM_STR);
                        break;
                    case '`PROGRAM`':
                        $stmt->bindValue($identifier, $this->program, PDO::PARAM_STR);
                        break;
                    case '`STRATEGY`':
                        $stmt->bindValue($identifier, $this->strategy, PDO::PARAM_STR);
                        break;
                    case '`LENGTH`':
                        $stmt->bindValue($identifier, $this->length, PDO::PARAM_INT);
                        break;
                    case '`AGENDA`':
                        $stmt->bindValue($identifier, $this->agenda, PDO::PARAM_INT);
                        break;
                    case '`HEADLINESCOPE`':
                        $stmt->bindValue($identifier, $this->headlinescope, PDO::PARAM_INT);
                        break;
                    case '`PROCESSED`':
                        $stmt->bindValue($identifier, (int) $this->processed, PDO::PARAM_INT);
                        break;
                    case '`CLASS_KEY`':
                        $stmt->bindValue($identifier, $this->class_key, PDO::PARAM_INT);
                        break;
                    case '`CREATED_AT`':
                        $stmt->bindValue($identifier, $this->created_at, PDO::PARAM_STR);
                        break;
                    case '`UPDATED_AT`':
                        $stmt->bindValue($identifier, $this->updated_at, PDO::PARAM_STR);
                        break;
                    case '`ISSUESCOUNT`':
                        $stmt->bindValue($identifier, $this->issuescount, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aMedia !== null) {
                if (!$this->aMedia->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aMedia->getValidationFailures());
                }
            }


            if (($retval = HeadlinePeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collHeadlineActors !== null) {
                    foreach ($this->collHeadlineActors as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collHeadlineIssues !== null) {
                    foreach ($this->collHeadlineIssues as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collHeadlineDocuments !== null) {
                    foreach ($this->collHeadlineDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collHeadlineTagRelations !== null) {
                    foreach ($this->collHeadlineTagRelations as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = HeadlinePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getContent();
                break;
            case 3:
                return $this->getDatepublished();
                break;
            case 4:
                return $this->getHeadlinedate();
                break;
            case 5:
                return $this->getUrl();
                break;
            case 6:
                return $this->getTwitts();
                break;
            case 7:
                return $this->getFcb();
                break;
            case 8:
                return $this->getGplus();
                break;
            case 9:
                return $this->getComment();
                break;
            case 10:
                return $this->getPicture();
                break;
            case 11:
                return $this->getCampaignid();
                break;
            case 12:
                return $this->getMediaid();
                break;
            case 13:
                return $this->getValue();
                break;
            case 14:
                return $this->getRelevance();
                break;
            case 15:
                return $this->getInternalid();
                break;
            case 16:
                return $this->getPage();
                break;
            case 17:
                return $this->getSection();
                break;
            case 18:
                return $this->getAuthor();
                break;
            case 19:
                return $this->getSource();
                break;
            case 20:
                return $this->getSummary();
                break;
            case 21:
                return $this->getCaption();
                break;
            case 22:
                return $this->getProgram();
                break;
            case 23:
                return $this->getStrategy();
                break;
            case 24:
                return $this->getLength();
                break;
            case 25:
                return $this->getAgenda();
                break;
            case 26:
                return $this->getHeadlinescope();
                break;
            case 27:
                return $this->getProcessed();
                break;
            case 28:
                return $this->getClassKey();
                break;
            case 29:
                return $this->getCreatedAt();
                break;
            case 30:
                return $this->getUpdatedAt();
                break;
            case 31:
                return $this->getIssuescount();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Headline'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Headline'][$this->getPrimaryKey()] = true;
        $keys = HeadlinePeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getContent(),
            $keys[3] => $this->getDatepublished(),
            $keys[4] => $this->getHeadlinedate(),
            $keys[5] => $this->getUrl(),
            $keys[6] => $this->getTwitts(),
            $keys[7] => $this->getFcb(),
            $keys[8] => $this->getGplus(),
            $keys[9] => $this->getComment(),
            $keys[10] => $this->getPicture(),
            $keys[11] => $this->getCampaignid(),
            $keys[12] => $this->getMediaid(),
            $keys[13] => $this->getValue(),
            $keys[14] => $this->getRelevance(),
            $keys[15] => $this->getInternalid(),
            $keys[16] => $this->getPage(),
            $keys[17] => $this->getSection(),
            $keys[18] => $this->getAuthor(),
            $keys[19] => $this->getSource(),
            $keys[20] => $this->getSummary(),
            $keys[21] => $this->getCaption(),
            $keys[22] => $this->getProgram(),
            $keys[23] => $this->getStrategy(),
            $keys[24] => $this->getLength(),
            $keys[25] => $this->getAgenda(),
            $keys[26] => $this->getHeadlinescope(),
            $keys[27] => $this->getProcessed(),
            $keys[28] => $this->getClassKey(),
            $keys[29] => $this->getCreatedAt(),
            $keys[30] => $this->getUpdatedAt(),
            $keys[31] => $this->getIssuescount(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aMedia) {
                $result['Media'] = $this->aMedia->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collHeadlineActors) {
                $result['HeadlineActors'] = $this->collHeadlineActors->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collHeadlineIssues) {
                $result['HeadlineIssues'] = $this->collHeadlineIssues->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collHeadlineDocuments) {
                $result['HeadlineDocuments'] = $this->collHeadlineDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collHeadlineTagRelations) {
                $result['HeadlineTagRelations'] = $this->collHeadlineTagRelations->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = HeadlinePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setContent($value);
                break;
            case 3:
                $this->setDatepublished($value);
                break;
            case 4:
                $this->setHeadlinedate($value);
                break;
            case 5:
                $this->setUrl($value);
                break;
            case 6:
                $this->setTwitts($value);
                break;
            case 7:
                $this->setFcb($value);
                break;
            case 8:
                $this->setGplus($value);
                break;
            case 9:
                $this->setComment($value);
                break;
            case 10:
                $this->setPicture($value);
                break;
            case 11:
                $this->setCampaignid($value);
                break;
            case 12:
                $this->setMediaid($value);
                break;
            case 13:
                $this->setValue($value);
                break;
            case 14:
                $this->setRelevance($value);
                break;
            case 15:
                $this->setInternalid($value);
                break;
            case 16:
                $this->setPage($value);
                break;
            case 17:
                $this->setSection($value);
                break;
            case 18:
                $this->setAuthor($value);
                break;
            case 19:
                $this->setSource($value);
                break;
            case 20:
                $this->setSummary($value);
                break;
            case 21:
                $this->setCaption($value);
                break;
            case 22:
                $this->setProgram($value);
                break;
            case 23:
                $this->setStrategy($value);
                break;
            case 24:
                $this->setLength($value);
                break;
            case 25:
                $this->setAgenda($value);
                break;
            case 26:
                $this->setHeadlinescope($value);
                break;
            case 27:
                $this->setProcessed($value);
                break;
            case 28:
                $this->setClassKey($value);
                break;
            case 29:
                $this->setCreatedAt($value);
                break;
            case 30:
                $this->setUpdatedAt($value);
                break;
            case 31:
                $this->setIssuescount($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = HeadlinePeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setContent($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setDatepublished($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setHeadlinedate($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setUrl($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setTwitts($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setFcb($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setGplus($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setComment($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setPicture($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setCampaignid($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setMediaid($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setValue($arr[$keys[13]]);
        if (array_key_exists($keys[14], $arr)) $this->setRelevance($arr[$keys[14]]);
        if (array_key_exists($keys[15], $arr)) $this->setInternalid($arr[$keys[15]]);
        if (array_key_exists($keys[16], $arr)) $this->setPage($arr[$keys[16]]);
        if (array_key_exists($keys[17], $arr)) $this->setSection($arr[$keys[17]]);
        if (array_key_exists($keys[18], $arr)) $this->setAuthor($arr[$keys[18]]);
        if (array_key_exists($keys[19], $arr)) $this->setSource($arr[$keys[19]]);
        if (array_key_exists($keys[20], $arr)) $this->setSummary($arr[$keys[20]]);
        if (array_key_exists($keys[21], $arr)) $this->setCaption($arr[$keys[21]]);
        if (array_key_exists($keys[22], $arr)) $this->setProgram($arr[$keys[22]]);
        if (array_key_exists($keys[23], $arr)) $this->setStrategy($arr[$keys[23]]);
        if (array_key_exists($keys[24], $arr)) $this->setLength($arr[$keys[24]]);
        if (array_key_exists($keys[25], $arr)) $this->setAgenda($arr[$keys[25]]);
        if (array_key_exists($keys[26], $arr)) $this->setHeadlinescope($arr[$keys[26]]);
        if (array_key_exists($keys[27], $arr)) $this->setProcessed($arr[$keys[27]]);
        if (array_key_exists($keys[28], $arr)) $this->setClassKey($arr[$keys[28]]);
        if (array_key_exists($keys[29], $arr)) $this->setCreatedAt($arr[$keys[29]]);
        if (array_key_exists($keys[30], $arr)) $this->setUpdatedAt($arr[$keys[30]]);
        if (array_key_exists($keys[31], $arr)) $this->setIssuescount($arr[$keys[31]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(HeadlinePeer::DATABASE_NAME);

        if ($this->isColumnModified(HeadlinePeer::ID)) $criteria->add(HeadlinePeer::ID, $this->id);
        if ($this->isColumnModified(HeadlinePeer::NAME)) $criteria->add(HeadlinePeer::NAME, $this->name);
        if ($this->isColumnModified(HeadlinePeer::CONTENT)) $criteria->add(HeadlinePeer::CONTENT, $this->content);
        if ($this->isColumnModified(HeadlinePeer::DATEPUBLISHED)) $criteria->add(HeadlinePeer::DATEPUBLISHED, $this->datepublished);
        if ($this->isColumnModified(HeadlinePeer::HEADLINEDATE)) $criteria->add(HeadlinePeer::HEADLINEDATE, $this->headlinedate);
        if ($this->isColumnModified(HeadlinePeer::URL)) $criteria->add(HeadlinePeer::URL, $this->url);
        if ($this->isColumnModified(HeadlinePeer::TWITTS)) $criteria->add(HeadlinePeer::TWITTS, $this->twitts);
        if ($this->isColumnModified(HeadlinePeer::FCB)) $criteria->add(HeadlinePeer::FCB, $this->fcb);
        if ($this->isColumnModified(HeadlinePeer::GPLUS)) $criteria->add(HeadlinePeer::GPLUS, $this->gplus);
        if ($this->isColumnModified(HeadlinePeer::COMMENT)) $criteria->add(HeadlinePeer::COMMENT, $this->comment);
        if ($this->isColumnModified(HeadlinePeer::PICTURE)) $criteria->add(HeadlinePeer::PICTURE, $this->picture);
        if ($this->isColumnModified(HeadlinePeer::CAMPAIGNID)) $criteria->add(HeadlinePeer::CAMPAIGNID, $this->campaignid);
        if ($this->isColumnModified(HeadlinePeer::MEDIAID)) $criteria->add(HeadlinePeer::MEDIAID, $this->mediaid);
        if ($this->isColumnModified(HeadlinePeer::VALUE)) $criteria->add(HeadlinePeer::VALUE, $this->value);
        if ($this->isColumnModified(HeadlinePeer::RELEVANCE)) $criteria->add(HeadlinePeer::RELEVANCE, $this->relevance);
        if ($this->isColumnModified(HeadlinePeer::INTERNALID)) $criteria->add(HeadlinePeer::INTERNALID, $this->internalid);
        if ($this->isColumnModified(HeadlinePeer::PAGE)) $criteria->add(HeadlinePeer::PAGE, $this->page);
        if ($this->isColumnModified(HeadlinePeer::SECTION)) $criteria->add(HeadlinePeer::SECTION, $this->section);
        if ($this->isColumnModified(HeadlinePeer::AUTHOR)) $criteria->add(HeadlinePeer::AUTHOR, $this->author);
        if ($this->isColumnModified(HeadlinePeer::SOURCE)) $criteria->add(HeadlinePeer::SOURCE, $this->source);
        if ($this->isColumnModified(HeadlinePeer::SUMMARY)) $criteria->add(HeadlinePeer::SUMMARY, $this->summary);
        if ($this->isColumnModified(HeadlinePeer::CAPTION)) $criteria->add(HeadlinePeer::CAPTION, $this->caption);
        if ($this->isColumnModified(HeadlinePeer::PROGRAM)) $criteria->add(HeadlinePeer::PROGRAM, $this->program);
        if ($this->isColumnModified(HeadlinePeer::STRATEGY)) $criteria->add(HeadlinePeer::STRATEGY, $this->strategy);
        if ($this->isColumnModified(HeadlinePeer::LENGTH)) $criteria->add(HeadlinePeer::LENGTH, $this->length);
        if ($this->isColumnModified(HeadlinePeer::AGENDA)) $criteria->add(HeadlinePeer::AGENDA, $this->agenda);
        if ($this->isColumnModified(HeadlinePeer::HEADLINESCOPE)) $criteria->add(HeadlinePeer::HEADLINESCOPE, $this->headlinescope);
        if ($this->isColumnModified(HeadlinePeer::PROCESSED)) $criteria->add(HeadlinePeer::PROCESSED, $this->processed);
        if ($this->isColumnModified(HeadlinePeer::CLASS_KEY)) $criteria->add(HeadlinePeer::CLASS_KEY, $this->class_key);
        if ($this->isColumnModified(HeadlinePeer::CREATED_AT)) $criteria->add(HeadlinePeer::CREATED_AT, $this->created_at);
        if ($this->isColumnModified(HeadlinePeer::UPDATED_AT)) $criteria->add(HeadlinePeer::UPDATED_AT, $this->updated_at);
        if ($this->isColumnModified(HeadlinePeer::ISSUESCOUNT)) $criteria->add(HeadlinePeer::ISSUESCOUNT, $this->issuescount);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(HeadlinePeer::DATABASE_NAME);
        $criteria->add(HeadlinePeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Headline (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setContent($this->getContent());
        $copyObj->setDatepublished($this->getDatepublished());
        $copyObj->setHeadlinedate($this->getHeadlinedate());
        $copyObj->setUrl($this->getUrl());
        $copyObj->setTwitts($this->getTwitts());
        $copyObj->setFcb($this->getFcb());
        $copyObj->setGplus($this->getGplus());
        $copyObj->setComment($this->getComment());
        $copyObj->setPicture($this->getPicture());
        $copyObj->setCampaignid($this->getCampaignid());
        $copyObj->setMediaid($this->getMediaid());
        $copyObj->setValue($this->getValue());
        $copyObj->setRelevance($this->getRelevance());
        $copyObj->setInternalid($this->getInternalid());
        $copyObj->setPage($this->getPage());
        $copyObj->setSection($this->getSection());
        $copyObj->setAuthor($this->getAuthor());
        $copyObj->setSource($this->getSource());
        $copyObj->setSummary($this->getSummary());
        $copyObj->setCaption($this->getCaption());
        $copyObj->setProgram($this->getProgram());
        $copyObj->setStrategy($this->getStrategy());
        $copyObj->setLength($this->getLength());
        $copyObj->setAgenda($this->getAgenda());
        $copyObj->setHeadlinescope($this->getHeadlinescope());
        $copyObj->setProcessed($this->getProcessed());
        $copyObj->setClassKey($this->getClassKey());
        $copyObj->setCreatedAt($this->getCreatedAt());
        $copyObj->setUpdatedAt($this->getUpdatedAt());
        $copyObj->setIssuescount($this->getIssuescount());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getHeadlineActors() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addHeadlineActor($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getHeadlineIssues() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addHeadlineIssue($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getHeadlineDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addHeadlineDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getHeadlineTagRelations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addHeadlineTagRelation($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Headline Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return HeadlinePeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new HeadlinePeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Media object.
     *
     * @param             Media $v
     * @return Headline The current object (for fluent API support)
     * @throws PropelException
     */
    public function setMedia(Media $v = null)
    {
        if ($v === null) {
            $this->setMediaid(NULL);
        } else {
            $this->setMediaid($v->getId());
        }

        $this->aMedia = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Media object, it will not be re-added.
        if ($v !== null) {
            $v->addHeadline($this);
        }


        return $this;
    }


    /**
     * Get the associated Media object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Media The associated Media object.
     * @throws PropelException
     */
    public function getMedia(PropelPDO $con = null)
    {
        if ($this->aMedia === null && ($this->mediaid !== null)) {
            $this->aMedia = MediaQuery::create()->findPk($this->mediaid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aMedia->addHeadlines($this);
             */
        }

        return $this->aMedia;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('HeadlineActor' == $relationName) {
            $this->initHeadlineActors();
        }
        if ('HeadlineIssue' == $relationName) {
            $this->initHeadlineIssues();
        }
        if ('HeadlineDocument' == $relationName) {
            $this->initHeadlineDocuments();
        }
        if ('HeadlineTagRelation' == $relationName) {
            $this->initHeadlineTagRelations();
        }
    }

    /**
     * Clears out the collHeadlineActors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlineActors()
     */
    public function clearHeadlineActors()
    {
        $this->collHeadlineActors = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlineActorsPartial = null;
    }

    /**
     * reset is the collHeadlineActors collection loaded partially
     *
     * @return void
     */
    public function resetPartialHeadlineActors($v = true)
    {
        $this->collHeadlineActorsPartial = $v;
    }

    /**
     * Initializes the collHeadlineActors collection.
     *
     * By default this just sets the collHeadlineActors collection to an empty array (like clearcollHeadlineActors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initHeadlineActors($overrideExisting = true)
    {
        if (null !== $this->collHeadlineActors && !$overrideExisting) {
            return;
        }
        $this->collHeadlineActors = new PropelObjectCollection();
        $this->collHeadlineActors->setModel('HeadlineActor');
    }

    /**
     * Gets an array of HeadlineActor objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Headline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|HeadlineActor[] List of HeadlineActor objects
     * @throws PropelException
     */
    public function getHeadlineActors($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineActorsPartial && !$this->isNew();
        if (null === $this->collHeadlineActors || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collHeadlineActors) {
                // return empty collection
                $this->initHeadlineActors();
            } else {
                $collHeadlineActors = HeadlineActorQuery::create(null, $criteria)
                    ->filterByHeadline($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collHeadlineActorsPartial && count($collHeadlineActors)) {
                      $this->initHeadlineActors(false);

                      foreach($collHeadlineActors as $obj) {
                        if (false == $this->collHeadlineActors->contains($obj)) {
                          $this->collHeadlineActors->append($obj);
                        }
                      }

                      $this->collHeadlineActorsPartial = true;
                    }

                    return $collHeadlineActors;
                }

                if($partial && $this->collHeadlineActors) {
                    foreach($this->collHeadlineActors as $obj) {
                        if($obj->isNew()) {
                            $collHeadlineActors[] = $obj;
                        }
                    }
                }

                $this->collHeadlineActors = $collHeadlineActors;
                $this->collHeadlineActorsPartial = false;
            }
        }

        return $this->collHeadlineActors;
    }

    /**
     * Sets a collection of HeadlineActor objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlineActors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlineActors(PropelCollection $headlineActors, PropelPDO $con = null)
    {
        $this->headlineActorsScheduledForDeletion = $this->getHeadlineActors(new Criteria(), $con)->diff($headlineActors);

        foreach ($this->headlineActorsScheduledForDeletion as $headlineActorRemoved) {
            $headlineActorRemoved->setHeadline(null);
        }

        $this->collHeadlineActors = null;
        foreach ($headlineActors as $headlineActor) {
            $this->addHeadlineActor($headlineActor);
        }

        $this->collHeadlineActors = $headlineActors;
        $this->collHeadlineActorsPartial = false;
    }

    /**
     * Returns the number of related HeadlineActor objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related HeadlineActor objects.
     * @throws PropelException
     */
    public function countHeadlineActors(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineActorsPartial && !$this->isNew();
        if (null === $this->collHeadlineActors || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collHeadlineActors) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getHeadlineActors());
                }
                $query = HeadlineActorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByHeadline($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlineActors);
        }
    }

    /**
     * Method called to associate a HeadlineActor object to this object
     * through the HeadlineActor foreign key attribute.
     *
     * @param    HeadlineActor $l HeadlineActor
     * @return Headline The current object (for fluent API support)
     */
    public function addHeadlineActor(HeadlineActor $l)
    {
        if ($this->collHeadlineActors === null) {
            $this->initHeadlineActors();
            $this->collHeadlineActorsPartial = true;
        }
        if (!$this->collHeadlineActors->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddHeadlineActor($l);
        }

        return $this;
    }

    /**
     * @param	HeadlineActor $headlineActor The headlineActor object to add.
     */
    protected function doAddHeadlineActor($headlineActor)
    {
        $this->collHeadlineActors[]= $headlineActor;
        $headlineActor->setHeadline($this);
    }

    /**
     * @param	HeadlineActor $headlineActor The headlineActor object to remove.
     */
    public function removeHeadlineActor($headlineActor)
    {
        if ($this->getHeadlineActors()->contains($headlineActor)) {
            $this->collHeadlineActors->remove($this->collHeadlineActors->search($headlineActor));
            if (null === $this->headlineActorsScheduledForDeletion) {
                $this->headlineActorsScheduledForDeletion = clone $this->collHeadlineActors;
                $this->headlineActorsScheduledForDeletion->clear();
            }
            $this->headlineActorsScheduledForDeletion[]= $headlineActor;
            $headlineActor->setHeadline(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Headline is new, it will return
     * an empty collection; or if this Headline has previously
     * been saved, it will retrieve related HeadlineActors from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Headline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|HeadlineActor[] List of HeadlineActor objects
     */
    public function getHeadlineActorsJoinActor($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = HeadlineActorQuery::create(null, $criteria);
        $query->joinWith('Actor', $join_behavior);

        return $this->getHeadlineActors($query, $con);
    }

    /**
     * Clears out the collHeadlineIssues collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlineIssues()
     */
    public function clearHeadlineIssues()
    {
        $this->collHeadlineIssues = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlineIssuesPartial = null;
    }

    /**
     * reset is the collHeadlineIssues collection loaded partially
     *
     * @return void
     */
    public function resetPartialHeadlineIssues($v = true)
    {
        $this->collHeadlineIssuesPartial = $v;
    }

    /**
     * Initializes the collHeadlineIssues collection.
     *
     * By default this just sets the collHeadlineIssues collection to an empty array (like clearcollHeadlineIssues());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initHeadlineIssues($overrideExisting = true)
    {
        if (null !== $this->collHeadlineIssues && !$overrideExisting) {
            return;
        }
        $this->collHeadlineIssues = new PropelObjectCollection();
        $this->collHeadlineIssues->setModel('HeadlineIssue');
    }

    /**
     * Gets an array of HeadlineIssue objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Headline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|HeadlineIssue[] List of HeadlineIssue objects
     * @throws PropelException
     */
    public function getHeadlineIssues($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineIssuesPartial && !$this->isNew();
        if (null === $this->collHeadlineIssues || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collHeadlineIssues) {
                // return empty collection
                $this->initHeadlineIssues();
            } else {
                $collHeadlineIssues = HeadlineIssueQuery::create(null, $criteria)
                    ->filterByHeadline($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collHeadlineIssuesPartial && count($collHeadlineIssues)) {
                      $this->initHeadlineIssues(false);

                      foreach($collHeadlineIssues as $obj) {
                        if (false == $this->collHeadlineIssues->contains($obj)) {
                          $this->collHeadlineIssues->append($obj);
                        }
                      }

                      $this->collHeadlineIssuesPartial = true;
                    }

                    return $collHeadlineIssues;
                }

                if($partial && $this->collHeadlineIssues) {
                    foreach($this->collHeadlineIssues as $obj) {
                        if($obj->isNew()) {
                            $collHeadlineIssues[] = $obj;
                        }
                    }
                }

                $this->collHeadlineIssues = $collHeadlineIssues;
                $this->collHeadlineIssuesPartial = false;
            }
        }

        return $this->collHeadlineIssues;
    }

    /**
     * Sets a collection of HeadlineIssue objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlineIssues A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlineIssues(PropelCollection $headlineIssues, PropelPDO $con = null)
    {
        $this->headlineIssuesScheduledForDeletion = $this->getHeadlineIssues(new Criteria(), $con)->diff($headlineIssues);

        foreach ($this->headlineIssuesScheduledForDeletion as $headlineIssueRemoved) {
            $headlineIssueRemoved->setHeadline(null);
        }

        $this->collHeadlineIssues = null;
        foreach ($headlineIssues as $headlineIssue) {
            $this->addHeadlineIssue($headlineIssue);
        }

        $this->collHeadlineIssues = $headlineIssues;
        $this->collHeadlineIssuesPartial = false;
    }

    /**
     * Returns the number of related HeadlineIssue objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related HeadlineIssue objects.
     * @throws PropelException
     */
    public function countHeadlineIssues(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineIssuesPartial && !$this->isNew();
        if (null === $this->collHeadlineIssues || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collHeadlineIssues) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getHeadlineIssues());
                }
                $query = HeadlineIssueQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByHeadline($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlineIssues);
        }
    }

    /**
     * Method called to associate a HeadlineIssue object to this object
     * through the HeadlineIssue foreign key attribute.
     *
     * @param    HeadlineIssue $l HeadlineIssue
     * @return Headline The current object (for fluent API support)
     */
    public function addHeadlineIssue(HeadlineIssue $l)
    {
        if ($this->collHeadlineIssues === null) {
            $this->initHeadlineIssues();
            $this->collHeadlineIssuesPartial = true;
        }
        if (!$this->collHeadlineIssues->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddHeadlineIssue($l);
        }

        return $this;
    }

    /**
     * @param	HeadlineIssue $headlineIssue The headlineIssue object to add.
     */
    protected function doAddHeadlineIssue($headlineIssue)
    {
        $this->collHeadlineIssues[]= $headlineIssue;
        $headlineIssue->setHeadline($this);
    }

    /**
     * @param	HeadlineIssue $headlineIssue The headlineIssue object to remove.
     */
    public function removeHeadlineIssue($headlineIssue)
    {
        if ($this->getHeadlineIssues()->contains($headlineIssue)) {
            $this->collHeadlineIssues->remove($this->collHeadlineIssues->search($headlineIssue));
            if (null === $this->headlineIssuesScheduledForDeletion) {
                $this->headlineIssuesScheduledForDeletion = clone $this->collHeadlineIssues;
                $this->headlineIssuesScheduledForDeletion->clear();
            }
            $this->headlineIssuesScheduledForDeletion[]= $headlineIssue;
            $headlineIssue->setHeadline(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Headline is new, it will return
     * an empty collection; or if this Headline has previously
     * been saved, it will retrieve related HeadlineIssues from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Headline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|HeadlineIssue[] List of HeadlineIssue objects
     */
    public function getHeadlineIssuesJoinIssue($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = HeadlineIssueQuery::create(null, $criteria);
        $query->joinWith('Issue', $join_behavior);

        return $this->getHeadlineIssues($query, $con);
    }

    /**
     * Clears out the collHeadlineDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlineDocuments()
     */
    public function clearHeadlineDocuments()
    {
        $this->collHeadlineDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlineDocumentsPartial = null;
    }

    /**
     * reset is the collHeadlineDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialHeadlineDocuments($v = true)
    {
        $this->collHeadlineDocumentsPartial = $v;
    }

    /**
     * Initializes the collHeadlineDocuments collection.
     *
     * By default this just sets the collHeadlineDocuments collection to an empty array (like clearcollHeadlineDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initHeadlineDocuments($overrideExisting = true)
    {
        if (null !== $this->collHeadlineDocuments && !$overrideExisting) {
            return;
        }
        $this->collHeadlineDocuments = new PropelObjectCollection();
        $this->collHeadlineDocuments->setModel('HeadlineDocument');
    }

    /**
     * Gets an array of HeadlineDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Headline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|HeadlineDocument[] List of HeadlineDocument objects
     * @throws PropelException
     */
    public function getHeadlineDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineDocumentsPartial && !$this->isNew();
        if (null === $this->collHeadlineDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collHeadlineDocuments) {
                // return empty collection
                $this->initHeadlineDocuments();
            } else {
                $collHeadlineDocuments = HeadlineDocumentQuery::create(null, $criteria)
                    ->filterByHeadline($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collHeadlineDocumentsPartial && count($collHeadlineDocuments)) {
                      $this->initHeadlineDocuments(false);

                      foreach($collHeadlineDocuments as $obj) {
                        if (false == $this->collHeadlineDocuments->contains($obj)) {
                          $this->collHeadlineDocuments->append($obj);
                        }
                      }

                      $this->collHeadlineDocumentsPartial = true;
                    }

                    return $collHeadlineDocuments;
                }

                if($partial && $this->collHeadlineDocuments) {
                    foreach($this->collHeadlineDocuments as $obj) {
                        if($obj->isNew()) {
                            $collHeadlineDocuments[] = $obj;
                        }
                    }
                }

                $this->collHeadlineDocuments = $collHeadlineDocuments;
                $this->collHeadlineDocumentsPartial = false;
            }
        }

        return $this->collHeadlineDocuments;
    }

    /**
     * Sets a collection of HeadlineDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlineDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlineDocuments(PropelCollection $headlineDocuments, PropelPDO $con = null)
    {
        $this->headlineDocumentsScheduledForDeletion = $this->getHeadlineDocuments(new Criteria(), $con)->diff($headlineDocuments);

        foreach ($this->headlineDocumentsScheduledForDeletion as $headlineDocumentRemoved) {
            $headlineDocumentRemoved->setHeadline(null);
        }

        $this->collHeadlineDocuments = null;
        foreach ($headlineDocuments as $headlineDocument) {
            $this->addHeadlineDocument($headlineDocument);
        }

        $this->collHeadlineDocuments = $headlineDocuments;
        $this->collHeadlineDocumentsPartial = false;
    }

    /**
     * Returns the number of related HeadlineDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related HeadlineDocument objects.
     * @throws PropelException
     */
    public function countHeadlineDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineDocumentsPartial && !$this->isNew();
        if (null === $this->collHeadlineDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collHeadlineDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getHeadlineDocuments());
                }
                $query = HeadlineDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByHeadline($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlineDocuments);
        }
    }

    /**
     * Method called to associate a HeadlineDocument object to this object
     * through the HeadlineDocument foreign key attribute.
     *
     * @param    HeadlineDocument $l HeadlineDocument
     * @return Headline The current object (for fluent API support)
     */
    public function addHeadlineDocument(HeadlineDocument $l)
    {
        if ($this->collHeadlineDocuments === null) {
            $this->initHeadlineDocuments();
            $this->collHeadlineDocumentsPartial = true;
        }
        if (!$this->collHeadlineDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddHeadlineDocument($l);
        }

        return $this;
    }

    /**
     * @param	HeadlineDocument $headlineDocument The headlineDocument object to add.
     */
    protected function doAddHeadlineDocument($headlineDocument)
    {
        $this->collHeadlineDocuments[]= $headlineDocument;
        $headlineDocument->setHeadline($this);
    }

    /**
     * @param	HeadlineDocument $headlineDocument The headlineDocument object to remove.
     */
    public function removeHeadlineDocument($headlineDocument)
    {
        if ($this->getHeadlineDocuments()->contains($headlineDocument)) {
            $this->collHeadlineDocuments->remove($this->collHeadlineDocuments->search($headlineDocument));
            if (null === $this->headlineDocumentsScheduledForDeletion) {
                $this->headlineDocumentsScheduledForDeletion = clone $this->collHeadlineDocuments;
                $this->headlineDocumentsScheduledForDeletion->clear();
            }
            $this->headlineDocumentsScheduledForDeletion[]= $headlineDocument;
            $headlineDocument->setHeadline(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Headline is new, it will return
     * an empty collection; or if this Headline has previously
     * been saved, it will retrieve related HeadlineDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Headline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|HeadlineDocument[] List of HeadlineDocument objects
     */
    public function getHeadlineDocumentsJoinDocument($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = HeadlineDocumentQuery::create(null, $criteria);
        $query->joinWith('Document', $join_behavior);

        return $this->getHeadlineDocuments($query, $con);
    }

    /**
     * Clears out the collHeadlineTagRelations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlineTagRelations()
     */
    public function clearHeadlineTagRelations()
    {
        $this->collHeadlineTagRelations = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlineTagRelationsPartial = null;
    }

    /**
     * reset is the collHeadlineTagRelations collection loaded partially
     *
     * @return void
     */
    public function resetPartialHeadlineTagRelations($v = true)
    {
        $this->collHeadlineTagRelationsPartial = $v;
    }

    /**
     * Initializes the collHeadlineTagRelations collection.
     *
     * By default this just sets the collHeadlineTagRelations collection to an empty array (like clearcollHeadlineTagRelations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initHeadlineTagRelations($overrideExisting = true)
    {
        if (null !== $this->collHeadlineTagRelations && !$overrideExisting) {
            return;
        }
        $this->collHeadlineTagRelations = new PropelObjectCollection();
        $this->collHeadlineTagRelations->setModel('HeadlineTagRelation');
    }

    /**
     * Gets an array of HeadlineTagRelation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Headline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|HeadlineTagRelation[] List of HeadlineTagRelation objects
     * @throws PropelException
     */
    public function getHeadlineTagRelations($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineTagRelationsPartial && !$this->isNew();
        if (null === $this->collHeadlineTagRelations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collHeadlineTagRelations) {
                // return empty collection
                $this->initHeadlineTagRelations();
            } else {
                $collHeadlineTagRelations = HeadlineTagRelationQuery::create(null, $criteria)
                    ->filterByHeadline($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collHeadlineTagRelationsPartial && count($collHeadlineTagRelations)) {
                      $this->initHeadlineTagRelations(false);

                      foreach($collHeadlineTagRelations as $obj) {
                        if (false == $this->collHeadlineTagRelations->contains($obj)) {
                          $this->collHeadlineTagRelations->append($obj);
                        }
                      }

                      $this->collHeadlineTagRelationsPartial = true;
                    }

                    return $collHeadlineTagRelations;
                }

                if($partial && $this->collHeadlineTagRelations) {
                    foreach($this->collHeadlineTagRelations as $obj) {
                        if($obj->isNew()) {
                            $collHeadlineTagRelations[] = $obj;
                        }
                    }
                }

                $this->collHeadlineTagRelations = $collHeadlineTagRelations;
                $this->collHeadlineTagRelationsPartial = false;
            }
        }

        return $this->collHeadlineTagRelations;
    }

    /**
     * Sets a collection of HeadlineTagRelation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlineTagRelations A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlineTagRelations(PropelCollection $headlineTagRelations, PropelPDO $con = null)
    {
        $this->headlineTagRelationsScheduledForDeletion = $this->getHeadlineTagRelations(new Criteria(), $con)->diff($headlineTagRelations);

        foreach ($this->headlineTagRelationsScheduledForDeletion as $headlineTagRelationRemoved) {
            $headlineTagRelationRemoved->setHeadline(null);
        }

        $this->collHeadlineTagRelations = null;
        foreach ($headlineTagRelations as $headlineTagRelation) {
            $this->addHeadlineTagRelation($headlineTagRelation);
        }

        $this->collHeadlineTagRelations = $headlineTagRelations;
        $this->collHeadlineTagRelationsPartial = false;
    }

    /**
     * Returns the number of related HeadlineTagRelation objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related HeadlineTagRelation objects.
     * @throws PropelException
     */
    public function countHeadlineTagRelations(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineTagRelationsPartial && !$this->isNew();
        if (null === $this->collHeadlineTagRelations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collHeadlineTagRelations) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getHeadlineTagRelations());
                }
                $query = HeadlineTagRelationQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByHeadline($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlineTagRelations);
        }
    }

    /**
     * Method called to associate a HeadlineTagRelation object to this object
     * through the HeadlineTagRelation foreign key attribute.
     *
     * @param    HeadlineTagRelation $l HeadlineTagRelation
     * @return Headline The current object (for fluent API support)
     */
    public function addHeadlineTagRelation(HeadlineTagRelation $l)
    {
        if ($this->collHeadlineTagRelations === null) {
            $this->initHeadlineTagRelations();
            $this->collHeadlineTagRelationsPartial = true;
        }
        if (!$this->collHeadlineTagRelations->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddHeadlineTagRelation($l);
        }

        return $this;
    }

    /**
     * @param	HeadlineTagRelation $headlineTagRelation The headlineTagRelation object to add.
     */
    protected function doAddHeadlineTagRelation($headlineTagRelation)
    {
        $this->collHeadlineTagRelations[]= $headlineTagRelation;
        $headlineTagRelation->setHeadline($this);
    }

    /**
     * @param	HeadlineTagRelation $headlineTagRelation The headlineTagRelation object to remove.
     */
    public function removeHeadlineTagRelation($headlineTagRelation)
    {
        if ($this->getHeadlineTagRelations()->contains($headlineTagRelation)) {
            $this->collHeadlineTagRelations->remove($this->collHeadlineTagRelations->search($headlineTagRelation));
            if (null === $this->headlineTagRelationsScheduledForDeletion) {
                $this->headlineTagRelationsScheduledForDeletion = clone $this->collHeadlineTagRelations;
                $this->headlineTagRelationsScheduledForDeletion->clear();
            }
            $this->headlineTagRelationsScheduledForDeletion[]= $headlineTagRelation;
            $headlineTagRelation->setHeadline(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Headline is new, it will return
     * an empty collection; or if this Headline has previously
     * been saved, it will retrieve related HeadlineTagRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Headline.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|HeadlineTagRelation[] List of HeadlineTagRelation objects
     */
    public function getHeadlineTagRelationsJoinHeadlineTag($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = HeadlineTagRelationQuery::create(null, $criteria);
        $query->joinWith('HeadlineTag', $join_behavior);

        return $this->getHeadlineTagRelations($query, $con);
    }

    /**
     * Clears out the collActors collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActors()
     */
    public function clearActors()
    {
        $this->collActors = null; // important to set this to null since that means it is uninitialized
        $this->collActorsPartial = null;
    }

    /**
     * Initializes the collActors collection.
     *
     * By default this just sets the collActors collection to an empty collection (like clearActors());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initActors()
    {
        $this->collActors = new PropelObjectCollection();
        $this->collActors->setModel('Actor');
    }

    /**
     * Gets a collection of Actor objects related by a many-to-many relationship
     * to the current object by way of the headlines_actor cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Headline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Actor[] List of Actor objects
     */
    public function getActors($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collActors || null !== $criteria) {
            if ($this->isNew() && null === $this->collActors) {
                // return empty collection
                $this->initActors();
            } else {
                $collActors = ActorQuery::create(null, $criteria)
                    ->filterByHeadline($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collActors;
                }
                $this->collActors = $collActors;
            }
        }

        return $this->collActors;
    }

    /**
     * Sets a collection of Actor objects related by a many-to-many relationship
     * to the current object by way of the headlines_actor cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $actors A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActors(PropelCollection $actors, PropelPDO $con = null)
    {
        $this->clearActors();
        $currentActors = $this->getActors();

        $this->actorsScheduledForDeletion = $currentActors->diff($actors);

        foreach ($actors as $actor) {
            if (!$currentActors->contains($actor)) {
                $this->doAddActor($actor);
            }
        }

        $this->collActors = $actors;
    }

    /**
     * Gets the number of Actor objects related by a many-to-many relationship
     * to the current object by way of the headlines_actor cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Actor objects
     */
    public function countActors($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collActors || null !== $criteria) {
            if ($this->isNew() && null === $this->collActors) {
                return 0;
            } else {
                $query = ActorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByHeadline($this)
                    ->count($con);
            }
        } else {
            return count($this->collActors);
        }
    }

    /**
     * Associate a Actor object to this object
     * through the headlines_actor cross reference table.
     *
     * @param  Actor $actor The HeadlineActor object to relate
     * @return void
     */
    public function addActor(Actor $actor)
    {
        if ($this->collActors === null) {
            $this->initActors();
        }
        if (!$this->collActors->contains($actor)) { // only add it if the **same** object is not already associated
            $this->doAddActor($actor);

            $this->collActors[]= $actor;
        }
    }

    /**
     * @param	Actor $actor The actor object to add.
     */
    protected function doAddActor($actor)
    {
        $headlineActor = new HeadlineActor();
        $headlineActor->setActor($actor);
        $this->addHeadlineActor($headlineActor);
    }

    /**
     * Remove a Actor object to this object
     * through the headlines_actor cross reference table.
     *
     * @param Actor $actor The HeadlineActor object to relate
     * @return void
     */
    public function removeActor(Actor $actor)
    {
        if ($this->getActors()->contains($actor)) {
            $this->collActors->remove($this->collActors->search($actor));
            if (null === $this->actorsScheduledForDeletion) {
                $this->actorsScheduledForDeletion = clone $this->collActors;
                $this->actorsScheduledForDeletion->clear();
            }
            $this->actorsScheduledForDeletion[]= $actor;
        }
    }

    /**
     * Clears out the collIssues collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIssues()
     */
    public function clearIssues()
    {
        $this->collIssues = null; // important to set this to null since that means it is uninitialized
        $this->collIssuesPartial = null;
    }

    /**
     * Initializes the collIssues collection.
     *
     * By default this just sets the collIssues collection to an empty collection (like clearIssues());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initIssues()
    {
        $this->collIssues = new PropelObjectCollection();
        $this->collIssues->setModel('Issue');
    }

    /**
     * Gets a collection of Issue objects related by a many-to-many relationship
     * to the current object by way of the headlines_issue cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Headline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Issue[] List of Issue objects
     */
    public function getIssues($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collIssues || null !== $criteria) {
            if ($this->isNew() && null === $this->collIssues) {
                // return empty collection
                $this->initIssues();
            } else {
                $collIssues = IssueQuery::create(null, $criteria)
                    ->filterByHeadline($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collIssues;
                }
                $this->collIssues = $collIssues;
            }
        }

        return $this->collIssues;
    }

    /**
     * Sets a collection of Issue objects related by a many-to-many relationship
     * to the current object by way of the headlines_issue cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $issues A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIssues(PropelCollection $issues, PropelPDO $con = null)
    {
        $this->clearIssues();
        $currentIssues = $this->getIssues();

        $this->issuesScheduledForDeletion = $currentIssues->diff($issues);

        foreach ($issues as $issue) {
            if (!$currentIssues->contains($issue)) {
                $this->doAddIssue($issue);
            }
        }

        $this->collIssues = $issues;
    }

    /**
     * Gets the number of Issue objects related by a many-to-many relationship
     * to the current object by way of the headlines_issue cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Issue objects
     */
    public function countIssues($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collIssues || null !== $criteria) {
            if ($this->isNew() && null === $this->collIssues) {
                return 0;
            } else {
                $query = IssueQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByHeadline($this)
                    ->count($con);
            }
        } else {
            return count($this->collIssues);
        }
    }

    /**
     * Associate a Issue object to this object
     * through the headlines_issue cross reference table.
     *
     * @param  Issue $issue The HeadlineIssue object to relate
     * @return void
     */
    public function addIssue(Issue $issue)
    {
        if ($this->collIssues === null) {
            $this->initIssues();
        }
        if (!$this->collIssues->contains($issue)) { // only add it if the **same** object is not already associated
            $this->doAddIssue($issue);

            $this->collIssues[]= $issue;
        }
    }

    /**
     * @param	Issue $issue The issue object to add.
     */
    protected function doAddIssue($issue)
    {
        $headlineIssue = new HeadlineIssue();
        $headlineIssue->setIssue($issue);
        $this->addHeadlineIssue($headlineIssue);
    }

    /**
     * Remove a Issue object to this object
     * through the headlines_issue cross reference table.
     *
     * @param Issue $issue The HeadlineIssue object to relate
     * @return void
     */
    public function removeIssue(Issue $issue)
    {
        if ($this->getIssues()->contains($issue)) {
            $this->collIssues->remove($this->collIssues->search($issue));
            if (null === $this->issuesScheduledForDeletion) {
                $this->issuesScheduledForDeletion = clone $this->collIssues;
                $this->issuesScheduledForDeletion->clear();
            }
            $this->issuesScheduledForDeletion[]= $issue;
        }
    }

    /**
     * Clears out the collDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addDocuments()
     */
    public function clearDocuments()
    {
        $this->collDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collDocumentsPartial = null;
    }

    /**
     * Initializes the collDocuments collection.
     *
     * By default this just sets the collDocuments collection to an empty collection (like clearDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initDocuments()
    {
        $this->collDocuments = new PropelObjectCollection();
        $this->collDocuments->setModel('Document');
    }

    /**
     * Gets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Headline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Document[] List of Document objects
     */
    public function getDocuments($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                // return empty collection
                $this->initDocuments();
            } else {
                $collDocuments = DocumentQuery::create(null, $criteria)
                    ->filterByHeadline($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collDocuments;
                }
                $this->collDocuments = $collDocuments;
            }
        }

        return $this->collDocuments;
    }

    /**
     * Sets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $documents A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setDocuments(PropelCollection $documents, PropelPDO $con = null)
    {
        $this->clearDocuments();
        $currentDocuments = $this->getDocuments();

        $this->documentsScheduledForDeletion = $currentDocuments->diff($documents);

        foreach ($documents as $document) {
            if (!$currentDocuments->contains($document)) {
                $this->doAddDocument($document);
            }
        }

        $this->collDocuments = $documents;
    }

    /**
     * Gets the number of Document objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Document objects
     */
    public function countDocuments($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                return 0;
            } else {
                $query = DocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByHeadline($this)
                    ->count($con);
            }
        } else {
            return count($this->collDocuments);
        }
    }

    /**
     * Associate a Document object to this object
     * through the headlines_headlineDocument cross reference table.
     *
     * @param  Document $document The HeadlineDocument object to relate
     * @return void
     */
    public function addDocument(Document $document)
    {
        if ($this->collDocuments === null) {
            $this->initDocuments();
        }
        if (!$this->collDocuments->contains($document)) { // only add it if the **same** object is not already associated
            $this->doAddDocument($document);

            $this->collDocuments[]= $document;
        }
    }

    /**
     * @param	Document $document The document object to add.
     */
    protected function doAddDocument($document)
    {
        $headlineDocument = new HeadlineDocument();
        $headlineDocument->setDocument($document);
        $this->addHeadlineDocument($headlineDocument);
    }

    /**
     * Remove a Document object to this object
     * through the headlines_headlineDocument cross reference table.
     *
     * @param Document $document The HeadlineDocument object to relate
     * @return void
     */
    public function removeDocument(Document $document)
    {
        if ($this->getDocuments()->contains($document)) {
            $this->collDocuments->remove($this->collDocuments->search($document));
            if (null === $this->documentsScheduledForDeletion) {
                $this->documentsScheduledForDeletion = clone $this->collDocuments;
                $this->documentsScheduledForDeletion->clear();
            }
            $this->documentsScheduledForDeletion[]= $document;
        }
    }

    /**
     * Clears out the collHeadlineTags collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlineTags()
     */
    public function clearHeadlineTags()
    {
        $this->collHeadlineTags = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlineTagsPartial = null;
    }

    /**
     * Initializes the collHeadlineTags collection.
     *
     * By default this just sets the collHeadlineTags collection to an empty collection (like clearHeadlineTags());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initHeadlineTags()
    {
        $this->collHeadlineTags = new PropelObjectCollection();
        $this->collHeadlineTags->setModel('HeadlineTag');
    }

    /**
     * Gets a collection of HeadlineTag objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineTags cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Headline is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|HeadlineTag[] List of HeadlineTag objects
     */
    public function getHeadlineTags($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collHeadlineTags || null !== $criteria) {
            if ($this->isNew() && null === $this->collHeadlineTags) {
                // return empty collection
                $this->initHeadlineTags();
            } else {
                $collHeadlineTags = HeadlineTagQuery::create(null, $criteria)
                    ->filterByHeadline($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collHeadlineTags;
                }
                $this->collHeadlineTags = $collHeadlineTags;
            }
        }

        return $this->collHeadlineTags;
    }

    /**
     * Sets a collection of HeadlineTag objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineTags cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlineTags A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlineTags(PropelCollection $headlineTags, PropelPDO $con = null)
    {
        $this->clearHeadlineTags();
        $currentHeadlineTags = $this->getHeadlineTags();

        $this->headlineTagsScheduledForDeletion = $currentHeadlineTags->diff($headlineTags);

        foreach ($headlineTags as $headlineTag) {
            if (!$currentHeadlineTags->contains($headlineTag)) {
                $this->doAddHeadlineTag($headlineTag);
            }
        }

        $this->collHeadlineTags = $headlineTags;
    }

    /**
     * Gets the number of HeadlineTag objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineTags cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related HeadlineTag objects
     */
    public function countHeadlineTags($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collHeadlineTags || null !== $criteria) {
            if ($this->isNew() && null === $this->collHeadlineTags) {
                return 0;
            } else {
                $query = HeadlineTagQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByHeadline($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlineTags);
        }
    }

    /**
     * Associate a HeadlineTag object to this object
     * through the headlines_headlineTags cross reference table.
     *
     * @param  HeadlineTag $headlineTag The HeadlineTagRelation object to relate
     * @return void
     */
    public function addHeadlineTag(HeadlineTag $headlineTag)
    {
        if ($this->collHeadlineTags === null) {
            $this->initHeadlineTags();
        }
        if (!$this->collHeadlineTags->contains($headlineTag)) { // only add it if the **same** object is not already associated
            $this->doAddHeadlineTag($headlineTag);

            $this->collHeadlineTags[]= $headlineTag;
        }
    }

    /**
     * @param	HeadlineTag $headlineTag The headlineTag object to add.
     */
    protected function doAddHeadlineTag($headlineTag)
    {
        $headlineTagRelation = new HeadlineTagRelation();
        $headlineTagRelation->setHeadlineTag($headlineTag);
        $this->addHeadlineTagRelation($headlineTagRelation);
    }

    /**
     * Remove a HeadlineTag object to this object
     * through the headlines_headlineTags cross reference table.
     *
     * @param HeadlineTag $headlineTag The HeadlineTagRelation object to relate
     * @return void
     */
    public function removeHeadlineTag(HeadlineTag $headlineTag)
    {
        if ($this->getHeadlineTags()->contains($headlineTag)) {
            $this->collHeadlineTags->remove($this->collHeadlineTags->search($headlineTag));
            if (null === $this->headlineTagsScheduledForDeletion) {
                $this->headlineTagsScheduledForDeletion = clone $this->collHeadlineTags;
                $this->headlineTagsScheduledForDeletion->clear();
            }
            $this->headlineTagsScheduledForDeletion[]= $headlineTag;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->content = null;
        $this->datepublished = null;
        $this->headlinedate = null;
        $this->url = null;
        $this->twitts = null;
        $this->fcb = null;
        $this->gplus = null;
        $this->comment = null;
        $this->picture = null;
        $this->campaignid = null;
        $this->mediaid = null;
        $this->value = null;
        $this->relevance = null;
        $this->internalid = null;
        $this->page = null;
        $this->section = null;
        $this->author = null;
        $this->source = null;
        $this->summary = null;
        $this->caption = null;
        $this->program = null;
        $this->strategy = null;
        $this->length = null;
        $this->agenda = null;
        $this->headlinescope = null;
        $this->processed = null;
        $this->class_key = null;
        $this->created_at = null;
        $this->updated_at = null;
        $this->issuescount = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collHeadlineActors) {
                foreach ($this->collHeadlineActors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHeadlineIssues) {
                foreach ($this->collHeadlineIssues as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHeadlineDocuments) {
                foreach ($this->collHeadlineDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHeadlineTagRelations) {
                foreach ($this->collHeadlineTagRelations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActors) {
                foreach ($this->collActors as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collIssues) {
                foreach ($this->collIssues as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDocuments) {
                foreach ($this->collDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHeadlineTags) {
                foreach ($this->collHeadlineTags as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collHeadlineActors instanceof PropelCollection) {
            $this->collHeadlineActors->clearIterator();
        }
        $this->collHeadlineActors = null;
        if ($this->collHeadlineIssues instanceof PropelCollection) {
            $this->collHeadlineIssues->clearIterator();
        }
        $this->collHeadlineIssues = null;
        if ($this->collHeadlineDocuments instanceof PropelCollection) {
            $this->collHeadlineDocuments->clearIterator();
        }
        $this->collHeadlineDocuments = null;
        if ($this->collHeadlineTagRelations instanceof PropelCollection) {
            $this->collHeadlineTagRelations->clearIterator();
        }
        $this->collHeadlineTagRelations = null;
        if ($this->collActors instanceof PropelCollection) {
            $this->collActors->clearIterator();
        }
        $this->collActors = null;
        if ($this->collIssues instanceof PropelCollection) {
            $this->collIssues->clearIterator();
        }
        $this->collIssues = null;
        if ($this->collDocuments instanceof PropelCollection) {
            $this->collDocuments->clearIterator();
        }
        $this->collDocuments = null;
        if ($this->collHeadlineTags instanceof PropelCollection) {
            $this->collHeadlineTags->clearIterator();
        }
        $this->collHeadlineTags = null;
        $this->aMedia = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // timestampable behavior

    /**
     * Mark the current object so that the update date doesn't get updated during next save
     *
     * @return     Headline The current object (for fluent API support)
     */
    public function keepUpdateDateUnchanged()
    {
        $this->modifiedColumns[] = HeadlinePeer::UPDATED_AT;

        return $this;
    }

    // aggregate_column behavior

    /**
     * Computes the value of the aggregate column issuesCount *
     * @param PropelPDO $con A connection object
     *
     * @return mixed The scalar result from the aggregate query
     */
    public function computeIssuescount(PropelPDO $con)
    {
        $stmt = $con->prepare('SELECT COUNT(headlineId) FROM `headlines_issue` WHERE headlines_issue.HEADLINEID = :p1');
        $stmt->bindValue(':p1', $this->getId());
        $stmt->execute();

        return $stmt->fetchColumn();
    }

    /**
     * Updates the aggregate column issuesCount *
     * @param PropelPDO $con A connection object
     */
    public function updateIssuescount(PropelPDO $con)
    {
        $this->setIssuescount($this->computeIssuescount($con));
        $this->save($con);
    }

}
