<?php


/**
 * Skeleton subclass for performing query and update operations on the 'documents_document' table.
 *
 * Documentos del sistema
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.documents.classes
 */
class DocumentQuery extends BaseDocumentQuery {

	/**
	 * Returns a new DocumentQuery object.
	 *
	 * @param     string $modelAlias The alias of a model in the query
	 * @param     Criteria $criteria Optional Criteria to build the query from
	 *
	 * @return    DocumentQuery
	 */
	public static function create($modelAlias = null, $criteria = null)
	{
		if ($criteria instanceof DocumentQuery) {
			return $criteria;
		}
		$query = new self('application', 'Document', $modelAlias);
		if ($criteria instanceof Criteria) {
			$query->mergeWith($criteria);
		}
		return $query;
	}

	/**
	 * Devuelve un array asociativo con los tipos de documentos establecidos en la configuracón local.
	 * @example Array ( [Word] => *.doc;*.docx; [Excel] => *.xls;*.xlsx; )
	 * @return Array $documentTypes, array asociativo con la informacion de los tipos de documentos soportados.
	 */
	 public static function getDocumentsTypesConfig() {
		$documentTypesConfig = ConfigModule::get("documents","documentTypes");
		foreach ($documentTypesConfig as $key => $extensions){
			$explodeExtensions = explode(",",$extensions);
			foreach ($explodeExtensions as $extension){
				$documentTypes[$key] .= "*." . $extension . ";";
			}
		}
		return $documentTypes;
	 }

} // DocumentQuery
