|-$stages = [
	'preliminary' => 'Anteproyecto',
	'contracting' => 'Contratación',
	'execution' => 'Ejecución'
]-|

<h2>Administrador de Obras</h2>
<h1>Lista de Obras</h1>
<p style="width: 100%;">A continuación se muestra el listado de obras disponibles en el sistema, ud. podrá editar o eliminar las existentes. Para crear una obra nueva hágalo desde el proyecto asociado.</p>

	<div id="div_construction">

		|-if $message eq "ok"-|
			<div class="successMessage">Obra guardada correctamente</div>
		|-elseif $message eq "deleted_ok"-|
			<div class="successMessage">Obra eliminada correctamente</div>
		|-/if-|

		<table cellpadding="4" cellspacing="0" class="tableTdBorders" id="tabla-newsarticles">
			<thead>
				<tr>
					<td colspan="7" class="tdSearch">
						|-if "projectsEdit"|security_has_access-|
							<a href="Main.php?do=projectsEdit&isConstruction=1|-include file="FiltersRedirectUrlInclude.tpl" filters=$filters-||-if isset($pager) && ($pager->getPage() ne 1)-|&page=|-$pager->getPage()-||-/if-|" class="addLink rightLink">Agregar Obra</a>
						|-/if-|
						<a href="javascript:void(null);" onClick='switch_vis("divSearch");' class="tdTitSearch" style="clear: left;">Buscar obras</a>
						<div id="divSearch" style="display:|-if $filters|@count gt 0 && !($filters.fromObjectives)-|block|-else-|none|-/if-|;">
							<form action='Main.php' method='get' style="display:inline;">
								<p>
									<label for="filters[searchString]">Texto a buscar</label>
									<input name="filters[searchString]" type="text" value="|-$filters.searchString-|" size="50" />
								</p>
								<p>
									<input type="hidden" name="do" value="constructionsList" />
									<input name="submit" type="submit" value="Aplicar filtros" />
									|-if $filters|@count gt 0-|<input name="removeFilters" type="button" value="Quitar filtros" onclick="location.href='Main.php?do=constructionsList'"/>|-/if-|
								</p>
							</form>
						</div>
					</td>
				</tr>
				<tr>
					<th width="2%">&nbsp;</th>
					<th width="75%">Obra</th>
					<th width="10%">Fecha Fin</th>
					<th width="8%">Etapa</th>
					<th width="5%">&nbsp;</th>
				</tr>
			</thead>
			<tbody>
				|-foreach from=$constructionColl item=construction name=for_calendaEvents-|
					<tr>
						<td>
							<span class="flag|-$construction->tryGetProject()->getStatusColor()|capitalize-|">&nbsp;</span>
						</td>
						<td>|-$construction->getName()-|</td>
						<td>|-$construction->getEndDate()|date_format-|</td>
						<td>|-$stages[$construction->getStage()]-|</td>
						|-*
						|-$dependency = $construction->getProject()-|
						|-if $dependency ne NULL-|
						<td>|-$dependency-|</td>
						|-else-|
						<td> No tiene dependencia </td>
						|-/if-|
						*-|
						<td nowrap align="right">
							|-if $construction->getStage() == 'execution'-|
								<input type='button' onClick='location.href="Main.php?do=constructionsProgressFollowing&id=|-$construction->getId()-|&returnParams=|-$thisReturnParams|urlencode-|"' value='Ver Seguimiento Físico Financiero' title="Ver Seguimiento Físico Financiero" class="icon iconGraph" />
							|-else-|
								|-$dependency = $construction->getProject()-|
								|-if $dependency ne NULL-|
									|-if $dependency->getProjectActivitys()|count gt 0-|
										<input type="button" class="icon iconViewGantt" onClick='location.href = "Main.php?do=projectsViewX4&showGantt=true&id=|-$dependency->getid()-|";' value="Ver Gantt" title="Ver Gantt (abre en ventana nueva)" />
									|-/if-|
								|-/if-|
							|-/if-|
						|-if "constructionsEdit"|security_user_has_access-|
							<form action="Main.php" method="get">
								<!--pasaje de parametros de filtros -->
								|-include file="FiltersRedirectInclude.tpl" filters=$filters-|
								<input type="hidden" name="do" value="projectsEdit" />
								<input type="hidden" name="id" value="|-$construction->tryGetProject()->getId()-|" />
								<input type="hidden" name="isConstruction" value="1" />
								<input type="hidden" name="saveReturn" value="construction-list" />
								<input type="submit" name="submit_go_edit_construction" value="Editar" class="icon iconEdit" />
							</form>
							|-if $construction->isDeletable()-|
								<form action="Main.php" method="post">
									<!--pasaje de parametros de filtros -->
									|-include file="FiltersRedirectInclude.tpl" filters=$filters-|
									<input type="hidden" name="do" value="constructionsDoDelete" />
									<input type="hidden" name="id" value="|-$construction->getid()-|" />
									<input type="submit" name="submit_go_delete_construction" value="Borrar" onclick="return confirm('Seguro que desea eliminar la obra? También se eliminará el proyecto asociado.')" class="icon iconDelete" />
								</form>
							|-/if-|
						|-/if-|
						</td>
					</tr>
				|-/foreach-|
				|-if isset($pager) && $pager->haveToPaginate()-|
					<tr>
						<td colspan="7" class="pages">|-include file="ModelPagerInclude.tpl"-|</td>
					</tr>
				|-/if-|
			</tbody>
		</table>
	</div>
</div>
