<?php


/**
 * Base class that represents a row from the 'constructions_inspection' table.
 *
 * Inspecciones a la obra
 *
 * @package    propel.generator.constructions.classes.om
 */
abstract class BaseInspection extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'InspectionPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        InspectionPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the constructionid field.
     * @var        int
     */
    protected $constructionid;

    /**
     * The value for the inspectorid field.
     * @var        int
     */
    protected $inspectorid;

    /**
     * The value for the visitdate field.
     * @var        string
     */
    protected $visitdate;

    /**
     * The value for the enddate field.
     * @var        string
     */
    protected $enddate;

    /**
     * The value for the enddateministry field.
     * @var        string
     */
    protected $enddateministry;

    /**
     * The value for the workshop field.
     * Note: this column has a database default value of: false
     * @var        boolean
     */
    protected $workshop;

    /**
     * The value for the progressinspector field.
     * @var        int
     */
    protected $progressinspector;

    /**
     * The value for the workingrate field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $workingrate;

    /**
     * The value for the progress field.
     * @var        string
     */
    protected $progress;

    /**
     * The value for the conclusion field.
     * @var        string
     */
    protected $conclusion;

    /**
     * The value for the workers field.
     * @var        int
     */
    protected $workers;

    /**
     * The value for the status field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $status;

    /**
     * The value for the othercomments field.
     * @var        string
     */
    protected $othercomments;

    /**
     * @var        Construction
     */
    protected $aConstruction;

    /**
     * @var        Inspector
     */
    protected $aInspector;

    /**
     * @var        PropelObjectCollection|InspectionPhoto[] Collection to store aggregation of InspectionPhoto objects.
     */
    protected $collInspectionPhotos;
    protected $collInspectionPhotosPartial;

    /**
     * @var        PropelObjectCollection|Resource[] Collection to store aggregation of Resource objects.
     */
    protected $collResources;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $resourcesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $inspectionPhotosScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->workshop = false;
        $this->workingrate = 0;
        $this->status = 0;
    }

    /**
     * Initializes internal state of BaseInspection object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     * Id del relevador
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [constructionid] column value.
     * ID de construccion
     * @return int
     */
    public function getConstructionid()
    {
        return $this->constructionid;
    }

    /**
     * Get the [inspectorid] column value.
     * ID de relevador
     * @return int
     */
    public function getInspectorid()
    {
        return $this->inspectorid;
    }

    /**
     * Get the [optionally formatted] temporal [visitdate] column value.
     * Fecha fin segun visita
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getVisitdate($format = '%Y/%m/%d')
    {
        if ($this->visitdate === null) {
            return null;
        }

        if ($this->visitdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->visitdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->visitdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [enddate] column value.
     * Fecha fin
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getEnddate($format = '%Y/%m/%d')
    {
        if ($this->enddate === null) {
            return null;
        }

        if ($this->enddate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->enddate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->enddate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [enddateministry] column value.
     * Fecha fin segun Ministerio
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getEnddateministry($format = '%Y/%m/%d')
    {
        if ($this->enddateministry === null) {
            return null;
        }

        if ($this->enddateministry === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->enddateministry);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->enddateministry, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [workshop] column value.
     * Obrador presente
     * @return boolean
     */
    public function getWorkshop()
    {
        return $this->workshop;
    }

    /**
     * Get the [progressinspector] column value.
     * Progreso segun relevador
     * @return int
     */
    public function getProgressinspector()
    {
        return $this->progressinspector;
    }

    /**
     * Get the [workingrate] column value.
     * Ritmo de trabajo
     * @return int
     */
    public function getWorkingrate()
    {
        return $this->workingrate;
    }

    /**
     * Get the [progress] column value.
     * Progreso
     * @return string
     */
    public function getProgress()
    {
        return $this->progress;
    }

    /**
     * Get the [conclusion] column value.
     * Conclusion
     * @return string
     */
    public function getConclusion()
    {
        return $this->conclusion;
    }

    /**
     * Get the [workers] column value.
     * Trabajadores
     * @return int
     */
    public function getWorkers()
    {
        return $this->workers;
    }

    /**
     * Get the [status] column value.
     * Semaforo
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Get the [othercomments] column value.
     * Otros comentarios
     * @return string
     */
    public function getOthercomments()
    {
        return $this->othercomments;
    }

    /**
     * Set the value of [id] column.
     * Id del relevador
     * @param int $v new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = InspectionPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [constructionid] column.
     * ID de construccion
     * @param int $v new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setConstructionid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->constructionid !== $v) {
            $this->constructionid = $v;
            $this->modifiedColumns[] = InspectionPeer::CONSTRUCTIONID;
        }

        if ($this->aConstruction !== null && $this->aConstruction->getId() !== $v) {
            $this->aConstruction = null;
        }


        return $this;
    } // setConstructionid()

    /**
     * Set the value of [inspectorid] column.
     * ID de relevador
     * @param int $v new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setInspectorid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->inspectorid !== $v) {
            $this->inspectorid = $v;
            $this->modifiedColumns[] = InspectionPeer::INSPECTORID;
        }

        if ($this->aInspector !== null && $this->aInspector->getId() !== $v) {
            $this->aInspector = null;
        }


        return $this;
    } // setInspectorid()

    /**
     * Sets the value of [visitdate] column to a normalized version of the date/time value specified.
     * Fecha fin segun visita
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Inspection The current object (for fluent API support)
     */
    public function setVisitdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->visitdate !== null || $dt !== null) {
            $currentDateAsString = ($this->visitdate !== null && $tmpDt = new DateTime($this->visitdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->visitdate = $newDateAsString;
                $this->modifiedColumns[] = InspectionPeer::VISITDATE;
            }
        } // if either are not null


        return $this;
    } // setVisitdate()

    /**
     * Sets the value of [enddate] column to a normalized version of the date/time value specified.
     * Fecha fin
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Inspection The current object (for fluent API support)
     */
    public function setEnddate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->enddate !== null || $dt !== null) {
            $currentDateAsString = ($this->enddate !== null && $tmpDt = new DateTime($this->enddate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->enddate = $newDateAsString;
                $this->modifiedColumns[] = InspectionPeer::ENDDATE;
            }
        } // if either are not null


        return $this;
    } // setEnddate()

    /**
     * Sets the value of [enddateministry] column to a normalized version of the date/time value specified.
     * Fecha fin segun Ministerio
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Inspection The current object (for fluent API support)
     */
    public function setEnddateministry($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->enddateministry !== null || $dt !== null) {
            $currentDateAsString = ($this->enddateministry !== null && $tmpDt = new DateTime($this->enddateministry)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->enddateministry = $newDateAsString;
                $this->modifiedColumns[] = InspectionPeer::ENDDATEMINISTRY;
            }
        } // if either are not null


        return $this;
    } // setEnddateministry()

    /**
     * Sets the value of the [workshop] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Obrador presente
     * @param boolean|integer|string $v The new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setWorkshop($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->workshop !== $v) {
            $this->workshop = $v;
            $this->modifiedColumns[] = InspectionPeer::WORKSHOP;
        }


        return $this;
    } // setWorkshop()

    /**
     * Set the value of [progressinspector] column.
     * Progreso segun relevador
     * @param int $v new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setProgressinspector($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->progressinspector !== $v) {
            $this->progressinspector = $v;
            $this->modifiedColumns[] = InspectionPeer::PROGRESSINSPECTOR;
        }


        return $this;
    } // setProgressinspector()

    /**
     * Set the value of [workingrate] column.
     * Ritmo de trabajo
     * @param int $v new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setWorkingrate($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->workingrate !== $v) {
            $this->workingrate = $v;
            $this->modifiedColumns[] = InspectionPeer::WORKINGRATE;
        }


        return $this;
    } // setWorkingrate()

    /**
     * Set the value of [progress] column.
     * Progreso
     * @param string $v new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setProgress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->progress !== $v) {
            $this->progress = $v;
            $this->modifiedColumns[] = InspectionPeer::PROGRESS;
        }


        return $this;
    } // setProgress()

    /**
     * Set the value of [conclusion] column.
     * Conclusion
     * @param string $v new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setConclusion($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->conclusion !== $v) {
            $this->conclusion = $v;
            $this->modifiedColumns[] = InspectionPeer::CONCLUSION;
        }


        return $this;
    } // setConclusion()

    /**
     * Set the value of [workers] column.
     * Trabajadores
     * @param int $v new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setWorkers($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->workers !== $v) {
            $this->workers = $v;
            $this->modifiedColumns[] = InspectionPeer::WORKERS;
        }


        return $this;
    } // setWorkers()

    /**
     * Set the value of [status] column.
     * Semaforo
     * @param int $v new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setStatus($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->status !== $v) {
            $this->status = $v;
            $this->modifiedColumns[] = InspectionPeer::STATUS;
        }


        return $this;
    } // setStatus()

    /**
     * Set the value of [othercomments] column.
     * Otros comentarios
     * @param string $v new value
     * @return Inspection The current object (for fluent API support)
     */
    public function setOthercomments($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->othercomments !== $v) {
            $this->othercomments = $v;
            $this->modifiedColumns[] = InspectionPeer::OTHERCOMMENTS;
        }


        return $this;
    } // setOthercomments()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->workshop !== false) {
                return false;
            }

            if ($this->workingrate !== 0) {
                return false;
            }

            if ($this->status !== 0) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->constructionid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->inspectorid = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->visitdate = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->enddate = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->enddateministry = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->workshop = ($row[$startcol + 6] !== null) ? (boolean) $row[$startcol + 6] : null;
            $this->progressinspector = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
            $this->workingrate = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->progress = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->conclusion = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->workers = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->status = ($row[$startcol + 12] !== null) ? (int) $row[$startcol + 12] : null;
            $this->othercomments = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 14; // 14 = InspectionPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Inspection object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aConstruction !== null && $this->constructionid !== $this->aConstruction->getId()) {
            $this->aConstruction = null;
        }
        if ($this->aInspector !== null && $this->inspectorid !== $this->aInspector->getId()) {
            $this->aInspector = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = InspectionPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aConstruction = null;
            $this->aInspector = null;
            $this->collInspectionPhotos = null;

            $this->collResources = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = InspectionQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(InspectionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                InspectionPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aConstruction !== null) {
                if ($this->aConstruction->isModified() || $this->aConstruction->isNew()) {
                    $affectedRows += $this->aConstruction->save($con);
                }
                $this->setConstruction($this->aConstruction);
            }

            if ($this->aInspector !== null) {
                if ($this->aInspector->isModified() || $this->aInspector->isNew()) {
                    $affectedRows += $this->aInspector->save($con);
                }
                $this->setInspector($this->aInspector);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->resourcesScheduledForDeletion !== null) {
                if (!$this->resourcesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->resourcesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    InspectionPhotoQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->resourcesScheduledForDeletion = null;
                }

                foreach ($this->getResources() as $resource) {
                    if ($resource->isModified()) {
                        $resource->save($con);
                    }
                }
            }

            if ($this->inspectionPhotosScheduledForDeletion !== null) {
                if (!$this->inspectionPhotosScheduledForDeletion->isEmpty()) {
                    InspectionPhotoQuery::create()
                        ->filterByPrimaryKeys($this->inspectionPhotosScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->inspectionPhotosScheduledForDeletion = null;
                }
            }

            if ($this->collInspectionPhotos !== null) {
                foreach ($this->collInspectionPhotos as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = InspectionPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . InspectionPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(InspectionPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(InspectionPeer::CONSTRUCTIONID)) {
            $modifiedColumns[':p' . $index++]  = '`CONSTRUCTIONID`';
        }
        if ($this->isColumnModified(InspectionPeer::INSPECTORID)) {
            $modifiedColumns[':p' . $index++]  = '`INSPECTORID`';
        }
        if ($this->isColumnModified(InspectionPeer::VISITDATE)) {
            $modifiedColumns[':p' . $index++]  = '`VISITDATE`';
        }
        if ($this->isColumnModified(InspectionPeer::ENDDATE)) {
            $modifiedColumns[':p' . $index++]  = '`ENDDATE`';
        }
        if ($this->isColumnModified(InspectionPeer::ENDDATEMINISTRY)) {
            $modifiedColumns[':p' . $index++]  = '`ENDDATEMINISTRY`';
        }
        if ($this->isColumnModified(InspectionPeer::WORKSHOP)) {
            $modifiedColumns[':p' . $index++]  = '`WORKSHOP`';
        }
        if ($this->isColumnModified(InspectionPeer::PROGRESSINSPECTOR)) {
            $modifiedColumns[':p' . $index++]  = '`PROGRESSINSPECTOR`';
        }
        if ($this->isColumnModified(InspectionPeer::WORKINGRATE)) {
            $modifiedColumns[':p' . $index++]  = '`WORKINGRATE`';
        }
        if ($this->isColumnModified(InspectionPeer::PROGRESS)) {
            $modifiedColumns[':p' . $index++]  = '`PROGRESS`';
        }
        if ($this->isColumnModified(InspectionPeer::CONCLUSION)) {
            $modifiedColumns[':p' . $index++]  = '`CONCLUSION`';
        }
        if ($this->isColumnModified(InspectionPeer::WORKERS)) {
            $modifiedColumns[':p' . $index++]  = '`WORKERS`';
        }
        if ($this->isColumnModified(InspectionPeer::STATUS)) {
            $modifiedColumns[':p' . $index++]  = '`STATUS`';
        }
        if ($this->isColumnModified(InspectionPeer::OTHERCOMMENTS)) {
            $modifiedColumns[':p' . $index++]  = '`OTHERCOMMENTS`';
        }

        $sql = sprintf(
            'INSERT INTO `constructions_inspection` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`CONSTRUCTIONID`':
                        $stmt->bindValue($identifier, $this->constructionid, PDO::PARAM_INT);
                        break;
                    case '`INSPECTORID`':
                        $stmt->bindValue($identifier, $this->inspectorid, PDO::PARAM_INT);
                        break;
                    case '`VISITDATE`':
                        $stmt->bindValue($identifier, $this->visitdate, PDO::PARAM_STR);
                        break;
                    case '`ENDDATE`':
                        $stmt->bindValue($identifier, $this->enddate, PDO::PARAM_STR);
                        break;
                    case '`ENDDATEMINISTRY`':
                        $stmt->bindValue($identifier, $this->enddateministry, PDO::PARAM_STR);
                        break;
                    case '`WORKSHOP`':
                        $stmt->bindValue($identifier, (int) $this->workshop, PDO::PARAM_INT);
                        break;
                    case '`PROGRESSINSPECTOR`':
                        $stmt->bindValue($identifier, $this->progressinspector, PDO::PARAM_INT);
                        break;
                    case '`WORKINGRATE`':
                        $stmt->bindValue($identifier, $this->workingrate, PDO::PARAM_INT);
                        break;
                    case '`PROGRESS`':
                        $stmt->bindValue($identifier, $this->progress, PDO::PARAM_STR);
                        break;
                    case '`CONCLUSION`':
                        $stmt->bindValue($identifier, $this->conclusion, PDO::PARAM_STR);
                        break;
                    case '`WORKERS`':
                        $stmt->bindValue($identifier, $this->workers, PDO::PARAM_INT);
                        break;
                    case '`STATUS`':
                        $stmt->bindValue($identifier, $this->status, PDO::PARAM_INT);
                        break;
                    case '`OTHERCOMMENTS`':
                        $stmt->bindValue($identifier, $this->othercomments, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aConstruction !== null) {
                if (!$this->aConstruction->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aConstruction->getValidationFailures());
                }
            }

            if ($this->aInspector !== null) {
                if (!$this->aInspector->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aInspector->getValidationFailures());
                }
            }


            if (($retval = InspectionPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collInspectionPhotos !== null) {
                    foreach ($this->collInspectionPhotos as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = InspectionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getConstructionid();
                break;
            case 2:
                return $this->getInspectorid();
                break;
            case 3:
                return $this->getVisitdate();
                break;
            case 4:
                return $this->getEnddate();
                break;
            case 5:
                return $this->getEnddateministry();
                break;
            case 6:
                return $this->getWorkshop();
                break;
            case 7:
                return $this->getProgressinspector();
                break;
            case 8:
                return $this->getWorkingrate();
                break;
            case 9:
                return $this->getProgress();
                break;
            case 10:
                return $this->getConclusion();
                break;
            case 11:
                return $this->getWorkers();
                break;
            case 12:
                return $this->getStatus();
                break;
            case 13:
                return $this->getOthercomments();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Inspection'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Inspection'][$this->getPrimaryKey()] = true;
        $keys = InspectionPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getConstructionid(),
            $keys[2] => $this->getInspectorid(),
            $keys[3] => $this->getVisitdate(),
            $keys[4] => $this->getEnddate(),
            $keys[5] => $this->getEnddateministry(),
            $keys[6] => $this->getWorkshop(),
            $keys[7] => $this->getProgressinspector(),
            $keys[8] => $this->getWorkingrate(),
            $keys[9] => $this->getProgress(),
            $keys[10] => $this->getConclusion(),
            $keys[11] => $this->getWorkers(),
            $keys[12] => $this->getStatus(),
            $keys[13] => $this->getOthercomments(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aConstruction) {
                $result['Construction'] = $this->aConstruction->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aInspector) {
                $result['Inspector'] = $this->aInspector->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collInspectionPhotos) {
                $result['InspectionPhotos'] = $this->collInspectionPhotos->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = InspectionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setConstructionid($value);
                break;
            case 2:
                $this->setInspectorid($value);
                break;
            case 3:
                $this->setVisitdate($value);
                break;
            case 4:
                $this->setEnddate($value);
                break;
            case 5:
                $this->setEnddateministry($value);
                break;
            case 6:
                $this->setWorkshop($value);
                break;
            case 7:
                $this->setProgressinspector($value);
                break;
            case 8:
                $this->setWorkingrate($value);
                break;
            case 9:
                $this->setProgress($value);
                break;
            case 10:
                $this->setConclusion($value);
                break;
            case 11:
                $this->setWorkers($value);
                break;
            case 12:
                $this->setStatus($value);
                break;
            case 13:
                $this->setOthercomments($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = InspectionPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setConstructionid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setInspectorid($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setVisitdate($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setEnddate($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setEnddateministry($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setWorkshop($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setProgressinspector($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setWorkingrate($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setProgress($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setConclusion($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setWorkers($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setStatus($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setOthercomments($arr[$keys[13]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(InspectionPeer::DATABASE_NAME);

        if ($this->isColumnModified(InspectionPeer::ID)) $criteria->add(InspectionPeer::ID, $this->id);
        if ($this->isColumnModified(InspectionPeer::CONSTRUCTIONID)) $criteria->add(InspectionPeer::CONSTRUCTIONID, $this->constructionid);
        if ($this->isColumnModified(InspectionPeer::INSPECTORID)) $criteria->add(InspectionPeer::INSPECTORID, $this->inspectorid);
        if ($this->isColumnModified(InspectionPeer::VISITDATE)) $criteria->add(InspectionPeer::VISITDATE, $this->visitdate);
        if ($this->isColumnModified(InspectionPeer::ENDDATE)) $criteria->add(InspectionPeer::ENDDATE, $this->enddate);
        if ($this->isColumnModified(InspectionPeer::ENDDATEMINISTRY)) $criteria->add(InspectionPeer::ENDDATEMINISTRY, $this->enddateministry);
        if ($this->isColumnModified(InspectionPeer::WORKSHOP)) $criteria->add(InspectionPeer::WORKSHOP, $this->workshop);
        if ($this->isColumnModified(InspectionPeer::PROGRESSINSPECTOR)) $criteria->add(InspectionPeer::PROGRESSINSPECTOR, $this->progressinspector);
        if ($this->isColumnModified(InspectionPeer::WORKINGRATE)) $criteria->add(InspectionPeer::WORKINGRATE, $this->workingrate);
        if ($this->isColumnModified(InspectionPeer::PROGRESS)) $criteria->add(InspectionPeer::PROGRESS, $this->progress);
        if ($this->isColumnModified(InspectionPeer::CONCLUSION)) $criteria->add(InspectionPeer::CONCLUSION, $this->conclusion);
        if ($this->isColumnModified(InspectionPeer::WORKERS)) $criteria->add(InspectionPeer::WORKERS, $this->workers);
        if ($this->isColumnModified(InspectionPeer::STATUS)) $criteria->add(InspectionPeer::STATUS, $this->status);
        if ($this->isColumnModified(InspectionPeer::OTHERCOMMENTS)) $criteria->add(InspectionPeer::OTHERCOMMENTS, $this->othercomments);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(InspectionPeer::DATABASE_NAME);
        $criteria->add(InspectionPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Inspection (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setConstructionid($this->getConstructionid());
        $copyObj->setInspectorid($this->getInspectorid());
        $copyObj->setVisitdate($this->getVisitdate());
        $copyObj->setEnddate($this->getEnddate());
        $copyObj->setEnddateministry($this->getEnddateministry());
        $copyObj->setWorkshop($this->getWorkshop());
        $copyObj->setProgressinspector($this->getProgressinspector());
        $copyObj->setWorkingrate($this->getWorkingrate());
        $copyObj->setProgress($this->getProgress());
        $copyObj->setConclusion($this->getConclusion());
        $copyObj->setWorkers($this->getWorkers());
        $copyObj->setStatus($this->getStatus());
        $copyObj->setOthercomments($this->getOthercomments());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getInspectionPhotos() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addInspectionPhoto($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Inspection Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return InspectionPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new InspectionPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Construction object.
     *
     * @param             Construction $v
     * @return Inspection The current object (for fluent API support)
     * @throws PropelException
     */
    public function setConstruction(Construction $v = null)
    {
        if ($v === null) {
            $this->setConstructionid(NULL);
        } else {
            $this->setConstructionid($v->getId());
        }

        $this->aConstruction = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Construction object, it will not be re-added.
        if ($v !== null) {
            $v->addInspection($this);
        }


        return $this;
    }


    /**
     * Get the associated Construction object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Construction The associated Construction object.
     * @throws PropelException
     */
    public function getConstruction(PropelPDO $con = null)
    {
        if ($this->aConstruction === null && ($this->constructionid !== null)) {
            $this->aConstruction = ConstructionQuery::create()->findPk($this->constructionid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aConstruction->addInspections($this);
             */
        }

        return $this->aConstruction;
    }

    /**
     * Declares an association between this object and a Inspector object.
     *
     * @param             Inspector $v
     * @return Inspection The current object (for fluent API support)
     * @throws PropelException
     */
    public function setInspector(Inspector $v = null)
    {
        if ($v === null) {
            $this->setInspectorid(NULL);
        } else {
            $this->setInspectorid($v->getId());
        }

        $this->aInspector = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Inspector object, it will not be re-added.
        if ($v !== null) {
            $v->addInspection($this);
        }


        return $this;
    }


    /**
     * Get the associated Inspector object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Inspector The associated Inspector object.
     * @throws PropelException
     */
    public function getInspector(PropelPDO $con = null)
    {
        if ($this->aInspector === null && ($this->inspectorid !== null)) {
            $this->aInspector = InspectorQuery::create()->findPk($this->inspectorid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aInspector->addInspections($this);
             */
        }

        return $this->aInspector;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('InspectionPhoto' == $relationName) {
            $this->initInspectionPhotos();
        }
    }

    /**
     * Clears out the collInspectionPhotos collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addInspectionPhotos()
     */
    public function clearInspectionPhotos()
    {
        $this->collInspectionPhotos = null; // important to set this to null since that means it is uninitialized
        $this->collInspectionPhotosPartial = null;
    }

    /**
     * reset is the collInspectionPhotos collection loaded partially
     *
     * @return void
     */
    public function resetPartialInspectionPhotos($v = true)
    {
        $this->collInspectionPhotosPartial = $v;
    }

    /**
     * Initializes the collInspectionPhotos collection.
     *
     * By default this just sets the collInspectionPhotos collection to an empty array (like clearcollInspectionPhotos());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initInspectionPhotos($overrideExisting = true)
    {
        if (null !== $this->collInspectionPhotos && !$overrideExisting) {
            return;
        }
        $this->collInspectionPhotos = new PropelObjectCollection();
        $this->collInspectionPhotos->setModel('InspectionPhoto');
    }

    /**
     * Gets an array of InspectionPhoto objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Inspection is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|InspectionPhoto[] List of InspectionPhoto objects
     * @throws PropelException
     */
    public function getInspectionPhotos($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collInspectionPhotosPartial && !$this->isNew();
        if (null === $this->collInspectionPhotos || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collInspectionPhotos) {
                // return empty collection
                $this->initInspectionPhotos();
            } else {
                $collInspectionPhotos = InspectionPhotoQuery::create(null, $criteria)
                    ->filterByInspection($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collInspectionPhotosPartial && count($collInspectionPhotos)) {
                      $this->initInspectionPhotos(false);

                      foreach($collInspectionPhotos as $obj) {
                        if (false == $this->collInspectionPhotos->contains($obj)) {
                          $this->collInspectionPhotos->append($obj);
                        }
                      }

                      $this->collInspectionPhotosPartial = true;
                    }

                    return $collInspectionPhotos;
                }

                if($partial && $this->collInspectionPhotos) {
                    foreach($this->collInspectionPhotos as $obj) {
                        if($obj->isNew()) {
                            $collInspectionPhotos[] = $obj;
                        }
                    }
                }

                $this->collInspectionPhotos = $collInspectionPhotos;
                $this->collInspectionPhotosPartial = false;
            }
        }

        return $this->collInspectionPhotos;
    }

    /**
     * Sets a collection of InspectionPhoto objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $inspectionPhotos A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setInspectionPhotos(PropelCollection $inspectionPhotos, PropelPDO $con = null)
    {
        $this->inspectionPhotosScheduledForDeletion = $this->getInspectionPhotos(new Criteria(), $con)->diff($inspectionPhotos);

        foreach ($this->inspectionPhotosScheduledForDeletion as $inspectionPhotoRemoved) {
            $inspectionPhotoRemoved->setInspection(null);
        }

        $this->collInspectionPhotos = null;
        foreach ($inspectionPhotos as $inspectionPhoto) {
            $this->addInspectionPhoto($inspectionPhoto);
        }

        $this->collInspectionPhotos = $inspectionPhotos;
        $this->collInspectionPhotosPartial = false;
    }

    /**
     * Returns the number of related InspectionPhoto objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related InspectionPhoto objects.
     * @throws PropelException
     */
    public function countInspectionPhotos(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collInspectionPhotosPartial && !$this->isNew();
        if (null === $this->collInspectionPhotos || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collInspectionPhotos) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getInspectionPhotos());
                }
                $query = InspectionPhotoQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByInspection($this)
                    ->count($con);
            }
        } else {
            return count($this->collInspectionPhotos);
        }
    }

    /**
     * Method called to associate a InspectionPhoto object to this object
     * through the InspectionPhoto foreign key attribute.
     *
     * @param    InspectionPhoto $l InspectionPhoto
     * @return Inspection The current object (for fluent API support)
     */
    public function addInspectionPhoto(InspectionPhoto $l)
    {
        if ($this->collInspectionPhotos === null) {
            $this->initInspectionPhotos();
            $this->collInspectionPhotosPartial = true;
        }
        if (!$this->collInspectionPhotos->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddInspectionPhoto($l);
        }

        return $this;
    }

    /**
     * @param	InspectionPhoto $inspectionPhoto The inspectionPhoto object to add.
     */
    protected function doAddInspectionPhoto($inspectionPhoto)
    {
        $this->collInspectionPhotos[]= $inspectionPhoto;
        $inspectionPhoto->setInspection($this);
    }

    /**
     * @param	InspectionPhoto $inspectionPhoto The inspectionPhoto object to remove.
     */
    public function removeInspectionPhoto($inspectionPhoto)
    {
        if ($this->getInspectionPhotos()->contains($inspectionPhoto)) {
            $this->collInspectionPhotos->remove($this->collInspectionPhotos->search($inspectionPhoto));
            if (null === $this->inspectionPhotosScheduledForDeletion) {
                $this->inspectionPhotosScheduledForDeletion = clone $this->collInspectionPhotos;
                $this->inspectionPhotosScheduledForDeletion->clear();
            }
            $this->inspectionPhotosScheduledForDeletion[]= $inspectionPhoto;
            $inspectionPhoto->setInspection(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Inspection is new, it will return
     * an empty collection; or if this Inspection has previously
     * been saved, it will retrieve related InspectionPhotos from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Inspection.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|InspectionPhoto[] List of InspectionPhoto objects
     */
    public function getInspectionPhotosJoinResource($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = InspectionPhotoQuery::create(null, $criteria);
        $query->joinWith('Resource', $join_behavior);

        return $this->getInspectionPhotos($query, $con);
    }

    /**
     * Clears out the collResources collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addResources()
     */
    public function clearResources()
    {
        $this->collResources = null; // important to set this to null since that means it is uninitialized
        $this->collResourcesPartial = null;
    }

    /**
     * Initializes the collResources collection.
     *
     * By default this just sets the collResources collection to an empty collection (like clearResources());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initResources()
    {
        $this->collResources = new PropelObjectCollection();
        $this->collResources->setModel('Resource');
    }

    /**
     * Gets a collection of Resource objects related by a many-to-many relationship
     * to the current object by way of the constructions_inspectionPhoto cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Inspection is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Resource[] List of Resource objects
     */
    public function getResources($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collResources || null !== $criteria) {
            if ($this->isNew() && null === $this->collResources) {
                // return empty collection
                $this->initResources();
            } else {
                $collResources = ResourceQuery::create(null, $criteria)
                    ->filterByInspection($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collResources;
                }
                $this->collResources = $collResources;
            }
        }

        return $this->collResources;
    }

    /**
     * Sets a collection of Resource objects related by a many-to-many relationship
     * to the current object by way of the constructions_inspectionPhoto cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $resources A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setResources(PropelCollection $resources, PropelPDO $con = null)
    {
        $this->clearResources();
        $currentResources = $this->getResources();

        $this->resourcesScheduledForDeletion = $currentResources->diff($resources);

        foreach ($resources as $resource) {
            if (!$currentResources->contains($resource)) {
                $this->doAddResource($resource);
            }
        }

        $this->collResources = $resources;
    }

    /**
     * Gets the number of Resource objects related by a many-to-many relationship
     * to the current object by way of the constructions_inspectionPhoto cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Resource objects
     */
    public function countResources($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collResources || null !== $criteria) {
            if ($this->isNew() && null === $this->collResources) {
                return 0;
            } else {
                $query = ResourceQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByInspection($this)
                    ->count($con);
            }
        } else {
            return count($this->collResources);
        }
    }

    /**
     * Associate a Resource object to this object
     * through the constructions_inspectionPhoto cross reference table.
     *
     * @param  Resource $resource The InspectionPhoto object to relate
     * @return void
     */
    public function addResource(Resource $resource)
    {
        if ($this->collResources === null) {
            $this->initResources();
        }
        if (!$this->collResources->contains($resource)) { // only add it if the **same** object is not already associated
            $this->doAddResource($resource);

            $this->collResources[]= $resource;
        }
    }

    /**
     * @param	Resource $resource The resource object to add.
     */
    protected function doAddResource($resource)
    {
        $inspectionPhoto = new InspectionPhoto();
        $inspectionPhoto->setResource($resource);
        $this->addInspectionPhoto($inspectionPhoto);
    }

    /**
     * Remove a Resource object to this object
     * through the constructions_inspectionPhoto cross reference table.
     *
     * @param Resource $resource The InspectionPhoto object to relate
     * @return void
     */
    public function removeResource(Resource $resource)
    {
        if ($this->getResources()->contains($resource)) {
            $this->collResources->remove($this->collResources->search($resource));
            if (null === $this->resourcesScheduledForDeletion) {
                $this->resourcesScheduledForDeletion = clone $this->collResources;
                $this->resourcesScheduledForDeletion->clear();
            }
            $this->resourcesScheduledForDeletion[]= $resource;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->constructionid = null;
        $this->inspectorid = null;
        $this->visitdate = null;
        $this->enddate = null;
        $this->enddateministry = null;
        $this->workshop = null;
        $this->progressinspector = null;
        $this->workingrate = null;
        $this->progress = null;
        $this->conclusion = null;
        $this->workers = null;
        $this->status = null;
        $this->othercomments = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collInspectionPhotos) {
                foreach ($this->collInspectionPhotos as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collResources) {
                foreach ($this->collResources as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collInspectionPhotos instanceof PropelCollection) {
            $this->collInspectionPhotos->clearIterator();
        }
        $this->collInspectionPhotos = null;
        if ($this->collResources instanceof PropelCollection) {
            $this->collResources->clearIterator();
        }
        $this->collResources = null;
        $this->aConstruction = null;
        $this->aInspector = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(InspectionPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
