<?php



/**
 * This class defines the structure of the 'constructions_construction' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.constructions.classes.map
 */
class ConstructionTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'constructions.classes.map.ConstructionTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('constructions_construction');
        $this->setPhpName('Construction');
        $this->setClassname('Construction');
        $this->setPackage('constructions.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addForeignKey('PROYECTID', 'Proyectid', 'INTEGER', 'projects_project', 'ID', false, null, null);
        $this->addColumn('NAME', 'Name', 'VARCHAR', false, 255, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('DESCRIPTION', 'Description', 'LONGVARCHAR', false, null, null);
        $this->addForeignKey('CATEGORYID', 'Categoryid', 'INTEGER', 'categories_category', 'ID', false, null, null);
        $this->addColumn('LATITUDE', 'Latitude', 'NUMERIC', false, 12, null);
        $this->addColumn('LONGITUDE', 'Longitude', 'NUMERIC', false, 12, null);
        $this->addColumn('STREET', 'Street', 'VARCHAR', false, 100, null);
        $this->addColumn('NUMBER', 'Number', 'INTEGER', false, null, null);
        $this->addForeignKey('REGIONID', 'Regionid', 'INTEGER', 'regions_region', 'ID', false, null, null);
        $this->addColumn('ENDDATE', 'Enddate', 'DATE', false, null, null);
        $this->addColumn('STAGE', 'Stage', 'ENUM', false, null, null);
        $this->getColumn('STAGE', false)->setValueSet(array (
  0 => 'preliminary',
  1 => 'contracting',
  2 => 'execution',
));
        $this->addColumn('INAUGURATED', 'Inaugurated', 'BOOLEAN', false, 1, false);
        $this->addColumn('COMPANY', 'Company', 'VARCHAR', false, 255, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Project', 'Project', RelationMap::MANY_TO_ONE, array('proyectId' => 'id', ), 'CASCADE', null);
        $this->addRelation('Category', 'Category', RelationMap::MANY_TO_ONE, array('categoryId' => 'id', ), 'CASCADE', null);
        $this->addRelation('Region', 'Region', RelationMap::MANY_TO_ONE, array('regionId' => 'id', ), 'CASCADE', null);
        $this->addRelation('Inspection', 'Inspection', RelationMap::ONE_TO_MANY, array('id' => 'constructionId', ), 'CASCADE', null, 'Inspections');
        $this->addRelation('ConstructionProgress', 'ConstructionProgress', RelationMap::ONE_TO_MANY, array('id' => 'constructionId', ), null, null, 'ConstructionProgresss');
    } // buildRelations()

} // ConstructionTableMap
