<?php
use Egytca\Planning\YearFilter as PlanningYearFilter;

/**
 * Skeleton subclass for performing query and update operations on the 'constructions_construction' table.
 *
 * Seguimiento de obras
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.constructions.classes
 */
class ConstructionQuery extends BaseConstructionQuery {

    use PlanningYearFilter;

	const CONSTRUCTION_PROGRESS_ALIAS = 'ConstructionProgress';

	function preSelect() {

		$loggedUser = Common::getLoggedUser();
		if ($loggedUser && !$loggedUser->isSupervisor() && ConfigModule::get('projects', 'useFilterByUserGroup')) {
			$this->filterByLoggedUserGroup();
		}

        $this->useProjectQuery()
                ->filterByPlanningYears()
            ->endUse();

	}

	function filterByLoggedUserGroup() {
		return $this->useProjectQuery()
				->filterByLoggedUserGroup()
			->endUse();
	}

	function withStatusColumn(
			$constProgressAlias = self::CONSTRUCTION_PROGRESS_ALIAS,
			$columnName = 'Status') {
		return $this->withPFFStatusColumn($constProgressAlias, $columnName);
	}

	function withPFFStatusColumn(
			$constProgressAlias = self::CONSTRUCTION_PROGRESS_ALIAS,
			$columnName = 'PFFStatus') {

		$thisModelAlias = $this->getModelAlias();
		if (!$thisModelAlias) $thisModelAlias = $this->getModelName();

		return $this
			->joinConstructionProgress($constProgressAlias)
			->groupBy($thisModelAlias . '.Id')
			->withColumn(
				$this->sqlForPFFStatusColumn($constProgressAlias),
				$columnName
			);
	}

	function sqlForPFFStatusColumn(
			$constProgressAlias = self::CONSTRUCTION_PROGRESS_ALIAS) {

		$a = $constProgressAlias;

		$lastDate = $this->sqlForLastPFFRecordDateColumn($a);
		$trigger = 'DATE_SUB(CURDATE(), INTERVAL 2 MONTH)';
		$planned = $this->sqlForAccumulatedPlannedPhysicalProgressColumn($a);
		$real = $this->sqlForAccumulatedRealPhysicalProgressColumn($a);

		return 'CASE'
			. " WHEN ($planned) IS NULL OR ($planned = 0) THEN \"planned\""
			. " WHEN ($real) = 100 THEN \"finished\""
			. " WHEN ($real) < 0.75 * ($planned) THEN \"late\""
			. " WHEN ($lastDate) < ($trigger) THEN \"delayed\""
			. " WHEN ($real) < ($planned) THEN \"delayed\""
			. " ELSE \"onTime\""
		. ' END';
	}

	function sqlForAccumulatedPlannedPhysicalProgressColumn(
			$constProgressAlias = self::CONSTRUCTION_PROGRESS_ALIAS) {
		return "SUM($constProgressAlias.Physicalprogress)";
	}

	function sqlForAccumulatedPlannedFinancialProgressColumn(
			$constProgressAlias = self::CONSTRUCTION_PROGRESS_ALIAS) {
		return "SUM($constProgressAlias.Financialprogress)";
	}

	function sqlForAccumulatedRealPhysicalProgressColumn(
			$constProgressAlias = self::CONSTRUCTION_PROGRESS_ALIAS) {
		return "SUM($constProgressAlias.Realphysicalprogress)";
	}

	function sqlForAccumulatedRealFinancialProgressColumn(
			$constProgressAlias = self::CONSTRUCTION_PROGRESS_ALIAS) {
		return "SUM($constProgressAlias.Realfinancialprogress)";
	}

	function sqlForLastPFFRecordDateColumn(
			$constProgressAlias = self::CONSTRUCTION_PROGRESS_ALIAS) {
		$a = $constProgressAlias;
		return "MAX(CONCAT($a.Year, \"-\", $a.Month, \"-\", 1))";
	}

	function filterByName($name = null, $comparison = null) {
		return $this->useProjectQuery(null, Criteria::LEFT_JOIN)
			->filterByName($name, $comparison)
		->endUse();
	}

} // ConstructionQuery
