<?php



/**
 * This class defines the structure of the 'campaigns_campaign' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.campaigns.classes.map
 */
class CampaignTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'campaigns.classes.map.CampaignTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('campaigns_campaign');
        $this->setPhpName('Campaign');
        $this->setClassname('Campaign');
        $this->setPackage('campaigns.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'VARCHAR', false, 255, null);
        $this->getColumn('NAME', false)->setPrimaryString(true);
        $this->addColumn('TYPE', 'Type', 'INTEGER', false, null, null);
        $this->addColumn('STARTDATE', 'Startdate', 'DATE', false, null, null);
        $this->addColumn('FINISHDATE', 'Finishdate', 'DATE', false, null, null);
        $this->addColumn('CLIENTID', 'Clientid', 'INTEGER', false, null, null);
        $this->addColumn('DESCRIPTION', 'Description', 'LONGVARCHAR', false, null, null);
        $this->addColumn('LANGCODE', 'Langcode', 'CHAR', false, 2, null);
        $this->addColumn('DEFAULTKEYWORDS', 'Defaultkeywords', 'CHAR', false, 255, null);
        $this->addColumn('RESPONSIBLE', 'Responsible', 'CHAR', false, 120, null);
        $this->addColumn('SOURCES', 'Sources', 'INTEGER', false, null, 1);
        $this->addColumn('SEARCHQUERIES', 'Searchqueries', 'ARRAY', false, null, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('CampaignParticipant', 'CampaignParticipant', RelationMap::ONE_TO_MANY, array('id' => 'campaignId', ), 'CASCADE', null, 'CampaignParticipants');
        $this->addRelation('CampaignCommitment', 'CampaignCommitment', RelationMap::ONE_TO_MANY, array('id' => 'campaignId', ), 'CASCADE', null, 'CampaignCommitments');
        $this->addRelation('CampaignDocument', 'CampaignDocument', RelationMap::ONE_TO_MANY, array('id' => 'campaignId', ), 'CASCADE', null, 'CampaignDocuments');
        $this->addRelation('Document', 'Document', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Documents');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
        );
    } // getBehaviors()

} // CampaignTableMap
