<?php

/**
 * Skeleton subclass for performing query and update operations on the 'campaign_campaign' table.
 *
 * Base de Campaigns
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.campaign.classes
 */
class CampaignQuery extends BaseCampaignQuery {

	/**
	 * Agrega filtros de texto para encontrar un texto en nombre y descripcion
	 * @param $searchString string   texto a buscar
	 */
	public function searchString($searchString){
		return $this->filterByName("%$searchString%", Criteria::LIKE)
							->_or()
								->filterByDescription("%$searchString%", Criteria::LIKE);
	}

	/** 
	 * Agrega filtro para obtener campaigns activas
	 * para ser active tiene que haber empezado al menos hace $start dias
	 * @param $start  int que define cuantos dias atras puede haber empezado para ser activa
	 */
	public function active($start){
		return $this
			->filterByStartDate(array('min' => date('Y-m-d', strtotime("-$start days"))))
			->filterByFinishDate(array('min' => date('Y-m-d')));
	}

	/**
	 * Agrega filtro para las campaigns que tengan como fuente a $source
	 * @param $source int referencia de tipo de source
	 */
	public function withSource($source){
		return $this->where('sources & '. $source .' = '. $source);
	}

	/**
	 * Agrega filtros para campaigns activas que tengan como fuente a $source
	 * @param $source int referencia de tipo de source
	 * @param $daysAgo int cantidad de dias para retroceder la fecha
	 */
	public function filterByActiveAndSource($source, $daysAgo = 30){
		return $this
			->active($daysAgo)
			->withSource($source);
	}

	/**
	 * Agrega filtro para las campaigns mas recientes
	 * @param $limit   int cantidad de campaign mas recientes
	 */
	public function mostRecent($limit = 15){
		return $this->orderByFinishDate(Criteria::DESC)->limit($limit);
	}

} // CampaignQuery
