<?php

/**
 * CampaignsEditAction
 * Edicion de campaigns
 *
 * @package campaigns
 */
class CampaignsEditAction extends BaseSelectAction {

	function __construct() {
		parent::__construct('Campaign');
	}

	/**
	 * Acciones a ejecutar despues de obtener el objeto
	 */
	protected function postSelect() {
		parent::postSelect();

		$this->smarty->assign("sources", $this->entity->getSourcesArray());
		$this->smarty->assign("types", Campaign::getCampaignTypesTranslated());
		$this->smarty->assign("campaignSources", Campaign::getCampaignSourceTypes());
		$this->smarty->assign("actor", new Actor());

		//Adjuntar documentos
		$this->smarty->assign("documentsUpload", true); //en el template se realizan subidas de documentos
		$this->smarty->assign("documentTypes", DocumentPeer::getDocumentsTypesConfig());
		$this->smarty->assign("maxUploadSize", Common::maxUploadSize());

		// Busco todos los documentos asociados al campaign
		$this->smarty->assign("documents", $this->entity->getDocuments());

		require_once 'TwitterAnalyze.class.php';
		$this->smarty->assign('stopWordsLangs', TwitterAnalyze::getStopWordsLang());

		if ($_GET["report"]) {
			$this->template->template = "TemplatePrint.tpl";
			$this->smarty->assign("report",true);
		}

		// Busco los tweets aceptados, estados, valores y relevancias
		if($this->entity->hasSource(Campaign::TWITTER)) {

			// seteo los filtros para los tweets de esta campaign
			$twitterFilters = $_GET['twitter']['filters'];
			$twitterFilters['campaignId'] = $_GET["id"];
			$twitterFilters['status'] = TwitterTweet::ACCEPTED;
			if(isset($_GET['twitter']['filters']['processed'])){
				if($_GET['filters']['processed'] == -1)
					$twitterFilters['maxStatus'] = TwitterTweet::DISCARDED;
			}
			// hago la busqueda
			$tweetsQuery = BaseQuery::create('TwitterTweet');
			$tweets = $tweetsQuery->addFilters($twitterFilters)->find();
			$this->smarty->assign('twitterFilters', $twitterFilters);

			$this->smarty->assign('acceptedTweets', $tweets);
			$this->smarty->assign('tweetValues',TwitterTweet::getValues());
			$this->smarty->assign('tweetRelevances',TwitterTweet::getRelevances());
			$this->smarty->assign('tweetStatuses',TwitterTweet::getStatuses());

			// obtener el dia de hoy para el usuario
			$currentUserDate = Common::getDatetimeOnTimezone(date('Y-m-d H:i:s'));
			$timeRange = Common::findFirstAndLastTimes($currentUserDate);

			$this->smarty->assign('latestTopics',TwitterTrendingTopicQuery::getMostTrending($timeRange['from'], $timeRange['to'], 10));
			$this->smarty->assign('dateShowing',$currentUserDate);
			$this->smarty->assign('currentDate',$currentUserDate);

		}
	}

}
