<?php


/**
 * Base class that represents a query for the 'actors_formAnswer' table.
 *
 * Tabla de respuestas
 *
 * @method ActorFormAnswerQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ActorFormAnswerQuery orderByActorid($order = Criteria::ASC) Order by the actorId column
 * @method ActorFormAnswerQuery orderByQuestionid($order = Criteria::ASC) Order by the questionId column
 * @method ActorFormAnswerQuery orderByAnswer($order = Criteria::ASC) Order by the answer column
 * @method ActorFormAnswerQuery orderByJudgement($order = Criteria::ASC) Order by the judgement column
 * @method ActorFormAnswerQuery orderByCurrent($order = Criteria::ASC) Order by the current column
 * @method ActorFormAnswerQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 *
 * @method ActorFormAnswerQuery groupById() Group by the id column
 * @method ActorFormAnswerQuery groupByActorid() Group by the actorId column
 * @method ActorFormAnswerQuery groupByQuestionid() Group by the questionId column
 * @method ActorFormAnswerQuery groupByAnswer() Group by the answer column
 * @method ActorFormAnswerQuery groupByJudgement() Group by the judgement column
 * @method ActorFormAnswerQuery groupByCurrent() Group by the current column
 * @method ActorFormAnswerQuery groupByUpdated() Group by the updated column
 *
 * @method ActorFormAnswerQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ActorFormAnswerQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ActorFormAnswerQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ActorFormAnswerQuery leftJoinActor($relationAlias = null) Adds a LEFT JOIN clause to the query using the Actor relation
 * @method ActorFormAnswerQuery rightJoinActor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Actor relation
 * @method ActorFormAnswerQuery innerJoinActor($relationAlias = null) Adds a INNER JOIN clause to the query using the Actor relation
 *
 * @method ActorFormAnswerQuery leftJoinProfileForm($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProfileForm relation
 * @method ActorFormAnswerQuery rightJoinProfileForm($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProfileForm relation
 * @method ActorFormAnswerQuery innerJoinProfileForm($relationAlias = null) Adds a INNER JOIN clause to the query using the ProfileForm relation
 *
 * @method ActorFormAnswer findOne(PropelPDO $con = null) Return the first ActorFormAnswer matching the query
 * @method ActorFormAnswer findOneOrCreate(PropelPDO $con = null) Return the first ActorFormAnswer matching the query, or a new ActorFormAnswer object populated from the query conditions when no match is found
 *
 * @method ActorFormAnswer findOneById(int $id) Return the first ActorFormAnswer filtered by the id column
 * @method ActorFormAnswer findOneByActorid(int $actorId) Return the first ActorFormAnswer filtered by the actorId column
 * @method ActorFormAnswer findOneByQuestionid(int $questionId) Return the first ActorFormAnswer filtered by the questionId column
 * @method ActorFormAnswer findOneByAnswer(string $answer) Return the first ActorFormAnswer filtered by the answer column
 * @method ActorFormAnswer findOneByJudgement(string $judgement) Return the first ActorFormAnswer filtered by the judgement column
 * @method ActorFormAnswer findOneByCurrent(int $current) Return the first ActorFormAnswer filtered by the current column
 * @method ActorFormAnswer findOneByUpdated(string $updated) Return the first ActorFormAnswer filtered by the updated column
 *
 * @method array findById(int $id) Return ActorFormAnswer objects filtered by the id column
 * @method array findByActorid(int $actorId) Return ActorFormAnswer objects filtered by the actorId column
 * @method array findByQuestionid(int $questionId) Return ActorFormAnswer objects filtered by the questionId column
 * @method array findByAnswer(string $answer) Return ActorFormAnswer objects filtered by the answer column
 * @method array findByJudgement(string $judgement) Return ActorFormAnswer objects filtered by the judgement column
 * @method array findByCurrent(int $current) Return ActorFormAnswer objects filtered by the current column
 * @method array findByUpdated(string $updated) Return ActorFormAnswer objects filtered by the updated column
 *
 * @package    propel.generator.actors.classes.om
 */
abstract class BaseActorFormAnswerQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseActorFormAnswerQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ActorFormAnswer', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ActorFormAnswerQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ActorFormAnswerQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ActorFormAnswerQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ActorFormAnswerQuery) {
            return $criteria;
        }
        $query = new ActorFormAnswerQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ActorFormAnswer|ActorFormAnswer[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ActorFormAnswerPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ActorFormAnswerPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ActorFormAnswer A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `ACTORID`, `QUESTIONID`, `ANSWER`, `JUDGEMENT`, `CURRENT`, `UPDATED` FROM `actors_formAnswer` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ActorFormAnswer();
            $obj->hydrate($row);
            ActorFormAnswerPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ActorFormAnswer|ActorFormAnswer[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ActorFormAnswer[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ActorFormAnswerPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ActorFormAnswerPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ActorFormAnswerPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the actorId column
     *
     * Example usage:
     * <code>
     * $query->filterByActorid(1234); // WHERE actorId = 1234
     * $query->filterByActorid(array(12, 34)); // WHERE actorId IN (12, 34)
     * $query->filterByActorid(array('min' => 12)); // WHERE actorId > 12
     * </code>
     *
     * @see       filterByActor()
     *
     * @param     mixed $actorid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function filterByActorid($actorid = null, $comparison = null)
    {
        if (is_array($actorid)) {
            $useMinMax = false;
            if (isset($actorid['min'])) {
                $this->addUsingAlias(ActorFormAnswerPeer::ACTORID, $actorid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($actorid['max'])) {
                $this->addUsingAlias(ActorFormAnswerPeer::ACTORID, $actorid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ActorFormAnswerPeer::ACTORID, $actorid, $comparison);
    }

    /**
     * Filter the query on the questionId column
     *
     * Example usage:
     * <code>
     * $query->filterByQuestionid(1234); // WHERE questionId = 1234
     * $query->filterByQuestionid(array(12, 34)); // WHERE questionId IN (12, 34)
     * $query->filterByQuestionid(array('min' => 12)); // WHERE questionId > 12
     * </code>
     *
     * @see       filterByProfileForm()
     *
     * @param     mixed $questionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function filterByQuestionid($questionid = null, $comparison = null)
    {
        if (is_array($questionid)) {
            $useMinMax = false;
            if (isset($questionid['min'])) {
                $this->addUsingAlias(ActorFormAnswerPeer::QUESTIONID, $questionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($questionid['max'])) {
                $this->addUsingAlias(ActorFormAnswerPeer::QUESTIONID, $questionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ActorFormAnswerPeer::QUESTIONID, $questionid, $comparison);
    }

    /**
     * Filter the query on the answer column
     *
     * Example usage:
     * <code>
     * $query->filterByAnswer('fooValue');   // WHERE answer = 'fooValue'
     * $query->filterByAnswer('%fooValue%'); // WHERE answer LIKE '%fooValue%'
     * </code>
     *
     * @param     string $answer The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function filterByAnswer($answer = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($answer)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $answer)) {
                $answer = str_replace('*', '%', $answer);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ActorFormAnswerPeer::ANSWER, $answer, $comparison);
    }

    /**
     * Filter the query on the judgement column
     *
     * Example usage:
     * <code>
     * $query->filterByJudgement('fooValue');   // WHERE judgement = 'fooValue'
     * $query->filterByJudgement('%fooValue%'); // WHERE judgement LIKE '%fooValue%'
     * </code>
     *
     * @param     string $judgement The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function filterByJudgement($judgement = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($judgement)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $judgement)) {
                $judgement = str_replace('*', '%', $judgement);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ActorFormAnswerPeer::JUDGEMENT, $judgement, $comparison);
    }

    /**
     * Filter the query on the current column
     *
     * Example usage:
     * <code>
     * $query->filterByCurrent(1234); // WHERE current = 1234
     * $query->filterByCurrent(array(12, 34)); // WHERE current IN (12, 34)
     * $query->filterByCurrent(array('min' => 12)); // WHERE current > 12
     * </code>
     *
     * @param     mixed $current The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function filterByCurrent($current = null, $comparison = null)
    {
        if (is_array($current)) {
            $useMinMax = false;
            if (isset($current['min'])) {
                $this->addUsingAlias(ActorFormAnswerPeer::CURRENT, $current['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($current['max'])) {
                $this->addUsingAlias(ActorFormAnswerPeer::CURRENT, $current['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ActorFormAnswerPeer::CURRENT, $current, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ActorFormAnswerPeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ActorFormAnswerPeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ActorFormAnswerPeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query by a related Actor object
     *
     * @param   Actor|PropelObjectCollection $actor The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorFormAnswerQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActor($actor, $comparison = null)
    {
        if ($actor instanceof Actor) {
            return $this
                ->addUsingAlias(ActorFormAnswerPeer::ACTORID, $actor->getId(), $comparison);
        } elseif ($actor instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ActorFormAnswerPeer::ACTORID, $actor->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByActor() only accepts arguments of type Actor or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Actor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function joinActor($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Actor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Actor');
        }

        return $this;
    }

    /**
     * Use the Actor relation Actor object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorQuery A secondary query class using the current class as primary query
     */
    public function useActorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Actor', 'ActorQuery');
    }

    /**
     * Filter the query by a related ProfileForm object
     *
     * @param   ProfileForm|PropelObjectCollection $profileForm The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorFormAnswerQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProfileForm($profileForm, $comparison = null)
    {
        if ($profileForm instanceof ProfileForm) {
            return $this
                ->addUsingAlias(ActorFormAnswerPeer::QUESTIONID, $profileForm->getId(), $comparison);
        } elseif ($profileForm instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ActorFormAnswerPeer::QUESTIONID, $profileForm->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProfileForm() only accepts arguments of type ProfileForm or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProfileForm relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function joinProfileForm($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProfileForm');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProfileForm');
        }

        return $this;
    }

    /**
     * Use the ProfileForm relation ProfileForm object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProfileFormQuery A secondary query class using the current class as primary query
     */
    public function useProfileFormQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProfileForm($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProfileForm', 'ProfileFormQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ActorFormAnswer $actorFormAnswer Object to remove from the list of results
     *
     * @return ActorFormAnswerQuery The current query, for fluid interface
     */
    public function prune($actorFormAnswer = null)
    {
        if ($actorFormAnswer) {
            $this->addUsingAlias(ActorFormAnswerPeer::ID, $actorFormAnswer->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
