<?php



/**
 * Skeleton subclass for representing a row from the 'actors_actor' table.
 *
 * Base de Actores
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.actors.classes
 */
class Actor extends BaseActor {

	/** the default item name for this class */
	const ITEM_NAME = 'Actor';

	/**
	 * Devuelve aquellas positions en las que el usuario es funcionario a cargo.
	 */
	public function getPositions() {
		if (class_exists("PositionTenurePeer") && class_exists("PositionPeer"))
			return PositionQuery::create()
												->usePositionTenureQuery()
													->filterByObjecttype('Actor')
													->filterByObjectid($this->getId())
												->endUse()
											->find();
		else
			return;
	}

	function __toString() {
		return $this->getName().' '.$this->getSurname();
	}

} // Actor
