var system = require('system');

if (system.args.length < 3 || system.args.length > 4) {
	console.log('Usage: render.js URL filename [width*height]');
	phantom.exit(1);
}

var page = require('webpage').create();
var address = system.args[1];
var output = system.args[2];

page.open(address, function (status) {
	if (status !== 'success') {
		console.log('Unable to load the address!');
		phantom.exit();
	} else {
		if (system.args.length > 3) {
			var size = system.args[3].split('*');
			if (size.length === 2) {
				page.viewportSize = { width: size[0], height: size[1] };
	   		page.evaluate(function(w, h) {
	      	document.body.style.width = w + "px";
	      	document.body.style.height = h + "px";
	    	}, size[0], size[1]);
	  	}
		}
		window.setTimeout(function () {
			page.evaluate(function() {
				document.body.bgColor = 'white';
			});

			if (system.args.length > 3) {
				var size = system.args[3].split('*');
				if (size.length === 2)
			    page.clipRect = {top: 0, left: 0, width: size[0], height: size[1]};                                                                                                                           
			}
			page.render(output);
			phantom.exit();
		}, 200);
	}
});