<?php

namespace Egytca\Status;

trait PropagatedStatus {

	/**
	 * Returns a collection of objects which will propagate their
	 * status onto $this.
	 * The objects must implement the interface Egytca\Status.
	 */
	protected abstract function getStatusPropagators();

	function _calculateStatus() {

		// elements with higher index take precedence over the others
		$statusOrder = [
			'finished',
			'planned',
			'ontime',
			'undefined',
			'delayed',
			'late'
		];

		$thisStatus = $statusOrder[0];

		foreach ($this->getStatusPropagators() as $propagator) {
			$propagatorStatus = $propagator->_calculateStatus();
			if (array_search($propagatorStatus, $statusOrder) > array_search($thisStatus, $statusOrder))
				$thisStatus = $propagatorStatus;
			if ($thisStatus == 'late')
				break;
		}

		return $thisStatus;
	}
}
