<?php

namespace Egytca\Statements;

abstract class BinaryStatement extends Statement {

	protected $operand1;
	protected $operand2;

	function __construct($operator, $operatorMap, Statement $operand1, Statement $operand2) {
		parent::__construct($operator, $operatorMap);
		$this->operand1 = $operand1;
		$this->operand2 = $operand2;
	}

	function toString() {
		return '(' . $this->operand1->toString() . ' ' . $this->getOperator() . ' ' . $this->operand2->toString() . ')';
	}
}
