<?php

namespace Egytca\Archivable;

trait ArchivableList {

    function setupArchivedFilters() {
        if ($this->filters['archived'] == null) { // == is intentional. '' and null should enter. '0' should not.
            $this->filters['archived'] = '0'; // filter out archived entities by default
        } else if ($this->filters['archived'] == 'all') {
            unset($this->filters['archived']); // I want them all
        }
    }

    /**
     * needed for preList() conflict resolution with other traits
     */
    private function _preList() {
        $this->setupArchivedFilters();
        return true;
    }

    protected function preList() {
        return parent::preList() && $this->_preList();
    }
}