<?php

namespace Egytca\API;

use BaseAction;
use Common;
use Egytca\ParamChecker\ParamChecker;
use Egytca\HTTPError;

class Action extends BaseAction {

	protected $module;
	protected $templateName;
	protected $errorTemplateName;
	protected $paramDescriptorDefaults;

	function __construct() {
		parent::__construct();
		$this->templateName = 'API/Basic.tpl';
		$this->errorTemplateName = 'API/Basic.tpl';
	}

	public function execute($mapping, $form, &$request, &$response) {

		parent::execute($mapping, $form, $request, $response);

		$this->template->template = 'TemplateAjax.tpl';
	}

	protected function returnFailure($errorCode, $errorMessage) {

		if ($errorCode === null)
			$errorCode = HTTPError::INTERNAL_SERVER_ERROR;
		if ($errorMessage === null)
			$errorMessage = HTTPError::errorMessage($errorCode);

		header('HTTP/1.1 ' . $errorCode . ' ' . $errorMessage);
		header('Content-Type: application/json; charset=UTF-8');
		$this->smarty->display($this->errorTemplateName);
	}

	protected function returnSuccess() {
		header('Content-Type: application/json; charset=UTF-8');
		$this->smarty->display($this->templateName);
	}

	protected function checkParams($descriptors) {

        $paramChecker = new ParamChecker($this->paramDescriptorDefaults);

        $result = $paramChecker->check($descriptors);
        if ($errors = $result->getErrors()) {
            $this->errors->add($errors);
            return false;
        } else {
            $this->params = $result->getParams();
            $this->debugData->set('params', $this->params);
            return true;
        }
    }
}