<?php

use Egytca\ErrorReporting\ErrorReport;

/**
 * BaseDoEditAction
 *
 * Meta clase para guardar un objeto en la base de datos
 *
 * @package phpMVC
 * @author Modulos Empresarios / Egytca
 * @copyright Copyright (c) 2015, Egytca
 */

class BaseDoEditAction extends BaseAction {

	private $entityClassName;
	protected $smarty;
	protected $entity;
	protected $entityParams;
	protected $ajaxTemplate;
	protected $params;
	protected $filters;
	protected $actionLog = true;
	protected $createEntityLog;
	protected $entityLog;
	protected $forwardName = 'success';
	protected $forwardFailureName = 'failure-edit';

	/**
	 * Constructor
	 *
	 * @param string $entityClassName Nombre de la clase que representa la entidad que se va a guardar
	 */
	function __construct($entityClassName) {
		if (empty($entityClassName))
			throw new Exception('$entityClassName must be set');
		$this->entityClassName = $entityClassName;
		if (substr(get_class($this), -7, 1) != 'X')
			$this->ajaxTemplate = str_replace('Action', '', get_class($this)) . 'X.tpl';
		else
			$this->ajaxTemplate = str_replace('Action', '', get_class($this)) . '.tpl';
	}

	/**
	 * Execute
	 * @see BaseAction::execute()
	 */
	public function execute($mapping, $form, &$request, &$response) {

		parent::execute($mapping, $form, $request, $response);

		// navegar a Main.php?do=processesDoEdit crea una entidad vacia nueva!!
		trigger_error('GET requests should not be accepted', E_USER_WARNING);

		$this->entityParams = Common::addUserInfoToParams($_POST['params']);

		$entityClassName = $this->entityClassName;
		$id = $request->getParameter('id');

		if (!empty($id)) {
			$this->params['id'] = $id;
			$this->entity = BaseQuery::create($entityClassName)->findOneById($id);
			if (empty($this->entity))
				return $this->addParamsAndFiltersToForwards($this->params, $this->filters, $mapping, 'failure-list');
		}
		else
			$this->entity = new $entityClassName();

		// Acciones a ejecutar antes de actualizar el objeto
		// Si el preUpdate devuelve false, se retorna $this->returnFailure (del BaseAction)
		if ($this->preUpdate() === false)
			return $this->returnFailure($mapping, $this->smarty, $this->entity, $this->forwardFailureName);

		$entityLogClassName = $this->entityClassName . 'Log';
		$setEntityId = 'set' . $this->entityClassName . 'id';
		if ($this->createEntityLog && class_exists($entityLogClassName)) {

			if (!$this->entity->isNew()) {
				$entityLog = new $entityLogClassName();
				$entityLog->fromJSON($this->entity->toJSON());
				$entityLog->setId(NULL);
				$entityLog->$setEntityId($id);
				$this->entityLog = $entityLog;
			}
		}

		$this->entity->fromArray($this->entityParams, BasePeer::TYPE_FIELDNAME);

		// Acciones a ejecutar despues de actualizar el objeto
		if ($this->postUpdate() === false)
			return $this->returnFailure($mapping, $this->smarty, $this->entity, $this->forwardFailureName);

		// Acciones a ejecutar antes de guardar el objeto
		$this->preSave();
		$action = $this->entity->isNew() ? 'create' : 'edit';

		try {
			$this->entity->save();
			$logSufix = ', ' . Common::getTranslation('action: ' . $action, 'common');
			if ($this->actionLog && method_exists($this->entity, 'getLogData'))
				Common::doLog('success', $this->entity->getLogData() . $logSufix);

			// Se agrega el Id del objeto guardado a los parametros de retorno
			if (!isset($this->params['id']) && !is_null($this->entity->getId()))
				$this->params['id'] = $this->entity->getId();

			if ($this->entityLog) {
				$this->entityLog->save();
			}

			// Acciones a ejecutar luego de guardar el objeto
			$this->postSave();
		} catch (Exception $e) {

			global $system;
			if (($system['config']['system']['parameters']['debugMode']['value'] == 'YES')) {
				ErrorReport::createFromException($e)->sendByMail();
			}

			//Elijo la vista basado en si es o no un pedido por AJAX
			if ($this->isAjax())
				return $this->returnAjaxFailure($e->getMessage());
			else {
				$this->onFailure($e);
				return $this->returnFailure($mapping, $this->smarty, $this->entity, $this->forwardFailureName);
			}
		}


		// Elijo la vista basado en si es o no un pedido por AJAX
		if ($this->isAjax())
			$this->smarty->display($this->ajaxTemplate);
		else
			return $this->addParamsAndFiltersToForwards($this->params, $this->filters, $mapping, $this->forwardName);

	}

	/**
	 * Chequeos previos al actualizar del objeto (update de datos sin guardarlos)
	 * Example:
	 * if (!checkOk()) {
	 *     $this->errors->add('error X');
	 *     return false;
	 * }
	 */
	protected function preUpdate() {

		// Procesar los valores del request asociados a filtros
		$this->prepareFilters();

	}

	/**
	 * Acciones a tomar despues de actualizar el objeto
	 */
	protected function postUpdate() {
		// default: do nothing
	}

	/**
	 * Acciones a tomar despues de actualizar el objeto pero antes de guardarlo
	 * Example:
	 * $this->entity->updateRegions()
	 */
	protected function preSave() {
		// default: do nothing
	}

	/**
	 * Acciones a tomar despues de guardar el objeto
	 */
	protected function postSave() {
		// default: do nothing
	}

	/**
	 * Asignacion de informacion y objeto en caso de fallo en el guardado
	 * @params $e exception generada al intentar guardar el objeto
	 */
	protected function onFailure($e) {
		$this->entity->fromArray($this->entityParams, BasePeer::TYPE_FIELDNAME);
		$this->smarty->assign('entity', $this->entity);
		$this->smarty->assign('errorMessage', $e->getMessage());
		$this->errors->add($e);
	}
}
