<?php

use Egytca\GlobalApp;

$webInfDir = __DIR__.'/../WEB-INF';
$templateSet = ConfigModule::get('global', 'templateSet');

$templateDirs = array();
$modulesPath = "$webInfDir/classes/modules";
$modules = scandir($modulesPath);

if ($templateSet != '' && $templateSet != 'tpl') {
	$templateDirs[] = "$webInfDir/$templateSet/";
}
$templateDirs[] = "$webInfDir/tpl/";
foreach ($modules as $module) {
	if (substr("$module", -1) != "." && is_dir("$modulesPath/$module"))
		if ($templateSet != '' && $templateSet != 'tpl') {
			$templateDirs[]	= "$modulesPath/$module/$templateSet/";
		}
		$templateDirs[]	= "$modulesPath/$module/tpl/";
}
return array(
	'templateDir' => $templateDirs,
	'pluginsDir' => "$webInfDir/smarty_tpl/plugins/",
	'compileDir' => "$webInfDir/smarty_tpl/templates_c/",
	'configDir' => "$webInfDir/smarty_tpl/configs/",
	'cacheDir' => "$webInfDir/smarty_tpl/cache/",
	'leftDelimiter' => '|-',
	'rightDelimiter' => '-|',
	'caching' => 'OFF', // [ OFF | LIFETIME_CURRENT | LIFETIME_SAVED ]
	'forceCompile' => GlobalApp::isDev() == 1 ? true : false  // Si esta en dev, true, si no, false
);
