<?php
function createAutoloader($namespace, $dir) {
    return function($classname) use ($namespace, $dir) {
        if (preg_match("/^$namespace\\\(.+)$/", $classname, $matches)) {
            $namespaceFileMap = str_replace('\\', '/', $matches[1]);
            $filename = "$dir/$namespaceFileMap.php";
            if (file_exists($filename)) {
                require_once $filename;
            }
        }
    };
}

spl_autoload_register(createAutoloader('Egytca', 'WEB-INF/classes/includes/Egytca'));
